/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.KeyConstraintViolatedException;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ArgumentDescriptor;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ProcedureDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class JdbcAccessImpl
implements JdbcAccess {
    private static final String SQL_STATE_KEY_VIOLATED = "23000";
    protected Logger logger;
    protected PersistenceBroker broker;

    public JdbcAccessImpl(PersistenceBroker persistenceBroker) {
        this.broker = persistenceBroker;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void executeDelete(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.safeDebug("executeDelete", object);
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.broker.serviceStatementManager().getDeleteStatement(classDescriptor);
            if (preparedStatement == null) {
                this.logger.error("getDeleteStatement returned a null statement");
                throw new PersistenceBrokerException("getDeleteStatement returned a null statement");
            }
            this.broker.serviceStatementManager().bindDelete(preparedStatement, classDescriptor, object);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeDelete: " + preparedStatement);
            }
            if (preparedStatement.executeUpdate() == 0 && classDescriptor.isLocking()) {
                throw new OptimisticLockException("Object has been modified or deleted by someone else", object);
            }
            this.harvestReturnValues(classDescriptor.getDeleteProcedure(), object, preparedStatement);
        }
        catch (OptimisticLockException optimisticLockException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("OptimisticLockException during the execution of delete: " + optimisticLockException.getMessage(), (Throwable)((Object)optimisticLockException));
            }
            throw optimisticLockException;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.logger.error("PersistenceBrokerException during the execution of delete: " + persistenceBrokerException.getMessage(), (Throwable)((Object)persistenceBrokerException));
            throw persistenceBrokerException;
        }
        catch (SQLException sQLException) {
            this.logger.error("SQLException during the execution of the delete (for a " + classDescriptor.getClassOfObject().getName() + "): " + sQLException.getMessage(), sQLException);
            throw new PersistenceBrokerSQLException(sQLException);
        }
        finally {
            this.broker.serviceStatementManager().closeResources(preparedStatement, null);
        }
    }

    public void executeDelete(Query query, ClassDescriptor classDescriptor) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.safeDebug("executeDelete (by Query)", query);
        }
        PreparedStatement preparedStatement = null;
        try {
            String string = this.broker.serviceSqlGenerator().getPreparedDeleteStatement(query, classDescriptor);
            preparedStatement = this.broker.serviceStatementManager().getPreparedStatement(classDescriptor, string, false);
            this.broker.serviceStatementManager().bindStatement(preparedStatement, query, classDescriptor, 1);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeDelete (by Query): " + preparedStatement);
            }
            preparedStatement.executeUpdate();
            this.broker.serviceStatementManager().closeResources(preparedStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                this.logger.error("SQLException during the execution of delete by query (for a " + classDescriptor.getClassOfObject().getName() + "): " + sQLException.getMessage(), sQLException);
                throw new PersistenceBrokerSQLException(sQLException);
            }
            catch (Throwable throwable) {
                this.broker.serviceStatementManager().closeResources(preparedStatement, null);
                throw throwable;
            }
        }
    }

    public void executeInsert(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.safeDebug("executeInsert", object);
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.broker.serviceStatementManager().getInsertStatement(classDescriptor);
            if (preparedStatement == null) {
                this.logger.error("getInsertStatement returned a null statement");
                throw new PersistenceBrokerException("getInsertStatement returned a null statement");
            }
            this.broker.serviceStatementManager().bindInsert(preparedStatement, classDescriptor, object);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeInsert: " + preparedStatement);
            }
            preparedStatement.executeUpdate();
            this.harvestReturnValues(classDescriptor.getInsertProcedure(), object, preparedStatement);
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.logger.error("PersistenceBrokerException during the execution of the insert: " + persistenceBrokerException.getMessage(), (Throwable)((Object)persistenceBrokerException));
            throw persistenceBrokerException;
        }
        catch (SQLException sQLException) {
            StringBuffer stringBuffer = new StringBuffer("SQL failure while insert object data for class ");
            try {
                stringBuffer.append(classDescriptor.getClassNameOfObject()).append(", PK of the given object is [");
                FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
                for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                    stringBuffer.append(" ").append(fieldDescriptorArray[i].getPersistentField().getName()).append("=").append(fieldDescriptorArray[i].getPersistentField().get(object));
                }
                stringBuffer.append("], object was " + object);
                stringBuffer.append(", exception message is [" + sQLException.getMessage() + "]");
            }
            catch (Exception exception) {
                stringBuffer.append("- Sorry, can't generate a more detailed message");
            }
            if (SQL_STATE_KEY_VIOLATED.equals(sQLException.getSQLState())) {
                throw new KeyConstraintViolatedException(stringBuffer.toString(), sQLException);
            }
            throw new PersistenceBrokerSQLException(stringBuffer.toString(), sQLException);
        }
        finally {
            this.broker.serviceStatementManager().closeResources(preparedStatement, null);
        }
    }

    public ResultSetAndStatement executeQuery(Query query, ClassDescriptor classDescriptor) throws PersistenceBrokerException {
        boolean bl;
        if (this.logger.isDebugEnabled()) {
            this.logger.safeDebug("executeQuery", query);
        }
        boolean bl2 = bl = query.getStartAtIndex() > 0 || query.getEndAtIndex() > 0;
        if (query != null && query.getPrefetchedRelationships() != null && !query.getPrefetchedRelationships().isEmpty()) {
            bl = true;
        }
        ResultSetAndStatement resultSetAndStatement = null;
        try {
            String string = this.broker.serviceSqlGenerator().getPreparedSelectStatement(query, classDescriptor);
            PreparedStatement preparedStatement = this.broker.serviceStatementManager().getPreparedStatement(classDescriptor, string, bl);
            this.broker.serviceStatementManager().bindStatement(preparedStatement, query, classDescriptor, 1);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeQuery: " + preparedStatement);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSetAndStatement = new ResultSetAndStatement(this.broker.serviceConnectionManager().getSupportedPlatform(), preparedStatement, resultSet);
            return resultSetAndStatement;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.logger.error("PersistenceBrokerException during the execution of the query: " + persistenceBrokerException.getMessage(), (Throwable)((Object)persistenceBrokerException));
            if (resultSetAndStatement != null) {
                resultSetAndStatement.close();
            }
            throw persistenceBrokerException;
        }
        catch (SQLException sQLException) {
            this.logger.error("SQLException during the execution of the query (for a " + classDescriptor.getClassOfObject().getName() + "): " + sQLException.getMessage(), sQLException);
            if (resultSetAndStatement != null) {
                resultSetAndStatement.close();
            }
            throw new PersistenceBrokerSQLException(sQLException);
        }
    }

    public ResultSetAndStatement executeSQL(String string, ClassDescriptor classDescriptor, boolean bl) throws PersistenceBrokerException {
        return this.executeSQL(string, classDescriptor, null, bl);
    }

    public ResultSetAndStatement executeSQL(String string, ClassDescriptor classDescriptor, ValueContainer[] valueContainerArray, boolean bl) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeSQL: " + string);
        }
        StatementManagerIF statementManagerIF = this.broker.serviceStatementManager();
        ResultSetAndStatement resultSetAndStatement = null;
        try {
            PreparedStatement preparedStatement = statementManagerIF.getPreparedStatement(classDescriptor, string, bl);
            statementManagerIF.bindValues(preparedStatement, valueContainerArray, 1);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSetAndStatement = new ResultSetAndStatement(this.broker.serviceConnectionManager().getSupportedPlatform(), preparedStatement, resultSet);
            return resultSetAndStatement;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.logger.error("PersistenceBrokerException during the execution of the SQL query: " + persistenceBrokerException.getMessage(), (Throwable)((Object)persistenceBrokerException));
            if (resultSetAndStatement != null) {
                resultSetAndStatement.close();
            }
            throw persistenceBrokerException;
        }
        catch (SQLException sQLException) {
            this.logger.error("SQLException during the execution of the SQL query: " + sQLException.getMessage(), sQLException);
            if (resultSetAndStatement != null) {
                resultSetAndStatement.close();
            }
            throw new PersistenceBrokerSQLException(sQLException);
        }
    }

    public int executeUpdateSQL(String string, ClassDescriptor classDescriptor) throws PersistenceBrokerException {
        return this.executeUpdateSQL(string, classDescriptor, null, null);
    }

    public int executeUpdateSQL(String string, ClassDescriptor classDescriptor, ValueContainer[] valueContainerArray, ValueContainer[] valueContainerArray2) throws PersistenceBrokerException {
        int n;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executeUpdateSQL: " + string);
        }
        PreparedStatement preparedStatement = null;
        StatementManagerIF statementManagerIF = this.broker.serviceStatementManager();
        try {
            preparedStatement = statementManagerIF.getPreparedStatement(classDescriptor, string, false);
            int n2 = statementManagerIF.bindValues(preparedStatement, valueContainerArray, 1);
            n2 = statementManagerIF.bindValues(preparedStatement, valueContainerArray2, n2);
            n = preparedStatement.executeUpdate();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.logger.error("PersistenceBrokerException during the execution of the Update SQL query: " + persistenceBrokerException.getMessage(), (Throwable)((Object)persistenceBrokerException));
            throw persistenceBrokerException;
        }
        catch (SQLException sQLException) {
            this.logger.error("SQLException during the execution of the Update SQL query (for a " + classDescriptor.getClassOfObject().getName() + "): " + sQLException.getMessage(), sQLException);
            if (SQL_STATE_KEY_VIOLATED.equals(sQLException.getSQLState())) {
                throw new KeyConstraintViolatedException(sQLException);
            }
            throw new PersistenceBrokerSQLException(sQLException);
        }
        finally {
            statementManagerIF.closeResources(preparedStatement, null);
        }
        return n;
    }

    public void executeUpdate(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        if (this.logger.isDebugEnabled()) {
            this.logger.safeDebug("executeUpdate", object);
        }
        PreparedStatement preparedStatement = null;
        if (classDescriptor.getNonPkRwFields().length == 0) {
            return;
        }
        ValueContainer[] valueContainerArray = classDescriptor.getCurrentLockingValues(object);
        try {
            preparedStatement = this.broker.serviceStatementManager().getUpdateStatement(classDescriptor);
            if (preparedStatement == null) {
                this.logger.error("getUpdateStatement returned a null statement");
                throw new PersistenceBrokerException("getUpdateStatement returned a null statement");
            }
            this.broker.serviceStatementManager().bindUpdate(preparedStatement, classDescriptor, object);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeUpdate: " + preparedStatement);
            }
            if (preparedStatement.executeUpdate() == 0 && classDescriptor.isLocking()) {
                throw new OptimisticLockException("Object has been modified by someone else", object);
            }
            this.harvestReturnValues(classDescriptor.getUpdateProcedure(), object, preparedStatement);
        }
        catch (OptimisticLockException optimisticLockException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("OptimisticLockException during the execution of update: " + optimisticLockException.getMessage(), (Throwable)((Object)optimisticLockException));
            }
            throw optimisticLockException;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.setLockingValues(classDescriptor, object, valueContainerArray);
            this.logger.error("PersistenceBrokerException during the execution of the update: " + persistenceBrokerException.getMessage(), (Throwable)((Object)persistenceBrokerException));
            throw persistenceBrokerException;
        }
        catch (SQLException sQLException) {
            this.setLockingValues(classDescriptor, object, valueContainerArray);
            this.logger.error("SQLException during the execution of the update (for a " + classDescriptor.getClassOfObject().getName() + "): " + sQLException.getMessage(), sQLException);
            if (SQL_STATE_KEY_VIOLATED.equals(sQLException.getSQLState())) {
                throw new KeyConstraintViolatedException(sQLException);
            }
            throw new PersistenceBrokerSQLException(sQLException);
        }
        finally {
            this.broker.serviceStatementManager().closeResources(preparedStatement, null);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object materializeObject(ClassDescriptor classDescriptor, Identity identity) throws PersistenceBrokerException {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.broker.serviceStatementManager().getSelectByPKStatement(classDescriptor);
            if (preparedStatement == null) {
                this.logger.error("getSelectByPKStatement returned a null statement");
                throw new PersistenceBrokerException("getSelectByPKStatement returned a null statement");
            }
            this.broker.serviceStatementManager().bindSelect(preparedStatement, identity, classDescriptor);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                HashMap hashMap = new HashMap();
                classDescriptor.getRowReader().readObjectArrayFrom(resultSet, hashMap);
                Object object = classDescriptor.getRowReader().readObjectFrom(hashMap);
                this.broker.serviceStatementManager().closeResources(preparedStatement, resultSet);
                return object;
            }
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            try {
                this.logger.error("PersistenceBrokerException during the execution of materializeObject: " + persistenceBrokerException.getMessage(), (Throwable)((Object)persistenceBrokerException));
                throw persistenceBrokerException;
                catch (SQLException sQLException) {
                    this.logger.error("SQLException during the execution of materializeObject (for a " + classDescriptor.getClassOfObject().getName() + "): " + sQLException.getMessage(), sQLException);
                    throw new PersistenceBrokerSQLException(sQLException);
                }
            }
            catch (Throwable throwable) {
                this.broker.serviceStatementManager().closeResources(preparedStatement, resultSet);
                throw throwable;
            }
        }
        {
            Object var5_6 = null;
            this.broker.serviceStatementManager().closeResources(preparedStatement, resultSet);
            return var5_6;
        }
    }

    private void setLockingValues(ClassDescriptor classDescriptor, Object object, ValueContainer[] valueContainerArray) {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getLockingFields();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            PersistentField persistentField = fieldDescriptorArray[i].getPersistentField();
            Object object2 = valueContainerArray[i].getValue();
            persistentField.set(object, object2);
        }
    }

    private void harvestReturnValues(ProcedureDescriptor procedureDescriptor, Object object, PreparedStatement preparedStatement) throws PersistenceBrokerSQLException {
        if (procedureDescriptor == null || !procedureDescriptor.hasReturnValues() || !(preparedStatement instanceof CallableStatement)) {
            return;
        }
        CallableStatement callableStatement = (CallableStatement)preparedStatement;
        int n = 0;
        if (procedureDescriptor.hasReturnValue()) {
            this.harvestReturnValue(object, callableStatement, procedureDescriptor.getReturnValueFieldRef(), ++n);
        }
        Iterator iterator = procedureDescriptor.getArguments().iterator();
        while (iterator.hasNext()) {
            ++n;
            ArgumentDescriptor argumentDescriptor = (ArgumentDescriptor)iterator.next();
            if (!argumentDescriptor.getIsReturnedByProcedure()) continue;
            this.harvestReturnValue(object, callableStatement, argumentDescriptor.getFieldRef(), n);
        }
    }

    private void harvestReturnValue(Object object, CallableStatement callableStatement, FieldDescriptor fieldDescriptor, int n) throws PersistenceBrokerSQLException {
        try {
            if (callableStatement != null && fieldDescriptor != null && object != null) {
                Object object2 = fieldDescriptor.getJdbcType().getObjectFromColumn(callableStatement, n);
                fieldDescriptor.getPersistentField().set(object, fieldDescriptor.getFieldConversion().sqlToJava(object2));
            }
        }
        catch (SQLException sQLException) {
            this.logger.error("SQLException during the execution of harvestReturnValue class=" + object.getClass().getName() + "," + " field=" + fieldDescriptor.getAttributeName() + " : " + sQLException.getMessage(), sQLException);
            throw new PersistenceBrokerSQLException(sQLException);
        }
    }
}

