/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.OJBIterator;

public class PagingIterator
implements OJBIterator {
    private final OJBIterator m_iterator;
    private int m_startAt;
    private int m_endAt;
    private int m_rowLimit;
    private int m_fullSize;
    private int m_currentCursorPosition;

    public PagingIterator(OJBIterator oJBIterator, int n, int n2) {
        if (n2 != 0 && n > n2) {
            throw new PersistenceBrokerException("startAt must be less than endAt.");
        }
        this.m_iterator = oJBIterator;
        this.m_fullSize = this.m_iterator.size();
        this.m_startAt = n == 0 ? 1 : n;
        this.m_endAt = n2 == 0 ? this.m_fullSize : Math.min(n2, this.m_fullSize);
        this.m_rowLimit = Math.max(0, this.m_endAt - this.m_startAt + 1);
        this.m_currentCursorPosition = this.m_startAt - 1;
        this.m_iterator.absolute(this.m_currentCursorPosition);
    }

    public int size() throws PersistenceBrokerException {
        if (this.m_fullSize < this.m_rowLimit) {
            return this.m_fullSize;
        }
        return this.m_rowLimit;
    }

    public int fullSize() throws PersistenceBrokerException {
        return this.m_fullSize;
    }

    public boolean absolute(int n) throws PersistenceBrokerException {
        int n2 = this.m_startAt - 1 + n;
        if (n2 < this.m_startAt) {
            n2 = Math.max(this.m_endAt + n, this.m_startAt - 1);
        }
        if (n2 > this.m_endAt) {
            n2 = this.m_endAt;
        }
        this.m_currentCursorPosition = n2;
        return this.m_iterator.absolute(n2);
    }

    public boolean relative(int n) throws PersistenceBrokerException {
        return this.absolute(this.m_currentCursorPosition - (this.m_startAt - 1) + n);
    }

    public void releaseDbResources() {
        this.m_iterator.releaseDbResources();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove not supported by PagingIterator");
    }

    public boolean hasNext() {
        if (this.m_currentCursorPosition < this.m_endAt) {
            return true;
        }
        this.releaseDbResources();
        return false;
    }

    public Object next() {
        ++this.m_currentCursorPosition;
        return this.m_iterator.next();
    }
}

