/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ArgumentDescriptor;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ProcedureDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformFactory;
import org.apache.ojb.broker.query.BetweenCriteria;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.ExistsCriteria;
import org.apache.ojb.broker.query.FieldCriteria;
import org.apache.ojb.broker.query.InCriteria;
import org.apache.ojb.broker.query.NullCriteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.SelectionCriteria;
import org.apache.ojb.broker.query.SqlCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class StatementManager
implements StatementManagerIF {
    private Logger m_log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$StatementManager == null ? (class$org$apache$ojb$broker$accesslayer$StatementManager = StatementManager.class$("org.apache.ojb.broker.accesslayer.StatementManager")) : class$org$apache$ojb$broker$accesslayer$StatementManager);
    private final PersistenceBroker m_broker;
    private Platform m_platform;
    private boolean m_eagerRelease;
    private ConnectionManagerIF m_conMan;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$StatementManager;

    public StatementManager(PersistenceBroker persistenceBroker) {
        this.m_broker = persistenceBroker;
        this.m_conMan = this.m_broker.serviceConnectionManager();
        this.m_eagerRelease = this.m_conMan.getConnectionDescriptor().getEagerRelease();
        this.m_platform = PlatformFactory.getPlatformFor(this.m_conMan.getConnectionDescriptor());
    }

    public void closeResources(Statement statement, ResultSet resultSet) {
        block6: {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug("closeResources was called");
            }
            try {
                this.m_platform.beforeStatementClose(statement, resultSet);
                if (statement != null) {
                    statement.close();
                    if (this.m_eagerRelease) {
                        this.m_conMan.releaseConnection();
                    }
                }
                this.m_platform.afterStatementClose(statement, resultSet);
            }
            catch (PlatformException platformException) {
                this.m_log.error("Platform dependent operation failed", (Throwable)((Object)platformException));
            }
            catch (SQLException sQLException) {
                if (!this.m_log.isDebugEnabled()) break block6;
                this.m_log.debug("Statement closing failed", sQLException);
            }
        }
    }

    public void bindDelete(PreparedStatement preparedStatement, Identity identity, ClassDescriptor classDescriptor) throws SQLException {
        int n;
        Object[] objectArray = identity.getPrimaryKeyValues();
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
        try {
            for (n = 0; n < objectArray.length; ++n) {
                this.m_platform.setObjectForStatement(preparedStatement, n + 1, objectArray[n], fieldDescriptorArray[n].getJdbcType().getType());
            }
        }
        catch (SQLException sQLException) {
            this.m_log.error("bindDelete failed for: " + identity.toString() + ", while set value '" + objectArray[n] + "' for column " + fieldDescriptorArray[n].getColumnName());
            throw sQLException;
        }
    }

    public void bindDelete(PreparedStatement preparedStatement, ClassDescriptor classDescriptor, Object object) throws SQLException {
        if (classDescriptor.getDeleteProcedure() != null) {
            this.bindProcedure(preparedStatement, classDescriptor, object, classDescriptor.getDeleteProcedure());
        } else {
            int n;
            int n2 = 1;
            ValueContainer[] valueContainerArray = classDescriptor.getCurrentLockingValues(object);
            ValueContainer[] valueContainerArray2 = this.getKeyValues(this.m_broker, classDescriptor, object);
            for (n = 0; n < valueContainerArray2.length; ++n) {
                this.m_platform.setObjectForStatement(preparedStatement, n2, valueContainerArray2[n].getValue(), valueContainerArray2[n].getJdbcType().getType());
                ++n2;
            }
            valueContainerArray2 = valueContainerArray;
            for (n = 0; n < valueContainerArray2.length; ++n) {
                this.m_platform.setObjectForStatement(preparedStatement, n2, valueContainerArray2[n].getValue(), valueContainerArray2[n].getJdbcType().getType());
                ++n2;
            }
        }
    }

    private int bindStatementValue(PreparedStatement preparedStatement, int n, Object object, Object object2, ClassDescriptor classDescriptor) throws SQLException {
        FieldDescriptor fieldDescriptor = null;
        if (object2 instanceof Query) {
            Query query = (Query)object2;
            return this.bindStatement(preparedStatement, query, classDescriptor.getRepository().getDescriptorFor(query.getSearchClass()), n);
        }
        if (object instanceof Query) {
            Query query = (Query)object;
            this.bindStatement(preparedStatement, query, classDescriptor.getRepository().getDescriptorFor(query.getSearchClass()), n);
        } else {
            fieldDescriptor = classDescriptor.getFieldDescriptorForPath((String)object);
        }
        if (fieldDescriptor != null) {
            if (object2 != null) {
                this.m_platform.setObjectForStatement(preparedStatement, n, fieldDescriptor.getFieldConversion().javaToSql(object2), fieldDescriptor.getJdbcType().getType());
            } else {
                this.m_platform.setNullForStatement(preparedStatement, n, fieldDescriptor.getJdbcType().getType());
            }
        } else if (object2 != null) {
            preparedStatement.setObject(n, object2);
        } else {
            preparedStatement.setNull(n, 0);
        }
        return ++n;
    }

    private int bindStatement(PreparedStatement preparedStatement, int n, SelectionCriteria selectionCriteria, ClassDescriptor classDescriptor) throws SQLException {
        return this.bindStatementValue(preparedStatement, n, selectionCriteria.getAttribute(), selectionCriteria.getValue(), classDescriptor);
    }

    private int bindStatement(PreparedStatement preparedStatement, int n, NullCriteria nullCriteria) {
        return n;
    }

    private int bindStatement(PreparedStatement preparedStatement, int n, FieldCriteria fieldCriteria) {
        return n;
    }

    private int bindStatement(PreparedStatement preparedStatement, int n, SqlCriteria sqlCriteria) {
        return n;
    }

    private int bindStatement(PreparedStatement preparedStatement, int n, BetweenCriteria betweenCriteria, ClassDescriptor classDescriptor) throws SQLException {
        n = this.bindStatementValue(preparedStatement, n, betweenCriteria.getAttribute(), betweenCriteria.getValue(), classDescriptor);
        return this.bindStatementValue(preparedStatement, n, betweenCriteria.getAttribute(), betweenCriteria.getValue2(), classDescriptor);
    }

    private int bindStatement(PreparedStatement preparedStatement, int n, InCriteria inCriteria, ClassDescriptor classDescriptor) throws SQLException {
        if (inCriteria.getValue() instanceof Collection) {
            Collection collection = (Collection)inCriteria.getValue();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                n = this.bindStatementValue(preparedStatement, n, inCriteria.getAttribute(), iterator.next(), classDescriptor);
            }
        } else {
            n = this.bindStatementValue(preparedStatement, n, inCriteria.getAttribute(), inCriteria.getValue(), classDescriptor);
        }
        return n;
    }

    private int bindStatement(PreparedStatement preparedStatement, int n, ExistsCriteria existsCriteria, ClassDescriptor classDescriptor) throws SQLException {
        Query query = (Query)existsCriteria.getValue();
        if (query.getCriteria() != null && !query.getCriteria().isEmpty()) {
            return this.bindStatement(preparedStatement, query.getCriteria(), classDescriptor.getRepository().getDescriptorFor(query.getSearchClass()), n);
        }
        return n;
    }

    public int bindStatement(PreparedStatement preparedStatement, Query query, ClassDescriptor classDescriptor, int n) throws SQLException {
        int n2 = this.bindStatement(preparedStatement, query.getCriteria(), classDescriptor, n);
        n2 = this.bindStatement(preparedStatement, query.getHavingCriteria(), classDescriptor, n2);
        return n2;
    }

    protected int bindStatement(PreparedStatement preparedStatement, Criteria criteria, ClassDescriptor classDescriptor, int n) throws SQLException {
        if (criteria != null) {
            Enumeration enumeration = criteria.getElements();
            while (enumeration.hasMoreElements()) {
                Serializable serializable;
                Object e = enumeration.nextElement();
                if (e instanceof Criteria) {
                    serializable = (Criteria)e;
                    n = this.bindStatement(preparedStatement, (Criteria)serializable, classDescriptor, n);
                    continue;
                }
                serializable = (SelectionCriteria)e;
                n = this.bindSelectionCriteria(preparedStatement, n, (SelectionCriteria)serializable, classDescriptor);
                for (int i = 0; i < ((SelectionCriteria)serializable).getNumberOfExtentsToBind(); ++i) {
                    n = this.bindSelectionCriteria(preparedStatement, n, (SelectionCriteria)serializable, classDescriptor);
                }
            }
        }
        return n;
    }

    private int bindSelectionCriteria(PreparedStatement preparedStatement, int n, SelectionCriteria selectionCriteria, ClassDescriptor classDescriptor) throws SQLException {
        n = selectionCriteria instanceof NullCriteria ? this.bindStatement(preparedStatement, n, (NullCriteria)selectionCriteria) : (selectionCriteria instanceof BetweenCriteria ? this.bindStatement(preparedStatement, n, (BetweenCriteria)selectionCriteria, classDescriptor) : (selectionCriteria instanceof InCriteria ? this.bindStatement(preparedStatement, n, (InCriteria)selectionCriteria, classDescriptor) : (selectionCriteria instanceof SqlCriteria ? this.bindStatement(preparedStatement, n, (SqlCriteria)selectionCriteria) : (selectionCriteria instanceof FieldCriteria ? this.bindStatement(preparedStatement, n, (FieldCriteria)selectionCriteria) : (selectionCriteria instanceof ExistsCriteria ? this.bindStatement(preparedStatement, n, (ExistsCriteria)selectionCriteria, classDescriptor) : this.bindStatement(preparedStatement, n, selectionCriteria, classDescriptor))))));
        return n;
    }

    public void bindInsert(PreparedStatement preparedStatement, ClassDescriptor classDescriptor, Object object) throws SQLException {
        classDescriptor.updateLockingValues(object);
        if (classDescriptor.getInsertProcedure() != null) {
            this.bindProcedure(preparedStatement, classDescriptor, object, classDescriptor.getInsertProcedure());
        } else {
            ValueContainer[] valueContainerArray = this.getAllValues(classDescriptor, object);
            for (int i = 0; i < valueContainerArray.length; ++i) {
                ValueContainer valueContainer = valueContainerArray[i];
                if (valueContainer.getValue() != null) {
                    this.m_platform.setObjectForStatement(preparedStatement, i + 1, valueContainer.getValue(), valueContainer.getJdbcType().getType());
                    continue;
                }
                this.m_platform.setNullForStatement(preparedStatement, i + 1, valueContainer.getJdbcType().getType());
            }
        }
    }

    public void bindSelect(PreparedStatement preparedStatement, Identity identity, ClassDescriptor classDescriptor) throws SQLException {
        ValueContainer[] valueContainerArray = null;
        int n = 0;
        if (classDescriptor == null) {
            classDescriptor = this.m_broker.getClassDescriptor(identity.getObjectsRealClass());
        }
        try {
            valueContainerArray = this.getKeyValues(this.m_broker, classDescriptor, identity);
            for (n = 0; n < valueContainerArray.length; ++n) {
                ValueContainer valueContainer = valueContainerArray[n];
                if (valueContainer.getValue() != null) {
                    this.m_platform.setObjectForStatement(preparedStatement, n + 1, valueContainer.getValue(), valueContainer.getJdbcType().getType());
                    continue;
                }
                this.m_platform.setNullForStatement(preparedStatement, n + 1, valueContainer.getJdbcType().getType());
            }
        }
        catch (SQLException sQLException) {
            this.m_log.error("bindSelect failed for: " + identity.toString() + ", PK: " + n + ", value: " + valueContainerArray[n]);
            throw sQLException;
        }
    }

    public void bindUpdate(PreparedStatement preparedStatement, ClassDescriptor classDescriptor, Object object) throws SQLException {
        if (classDescriptor.getUpdateProcedure() != null) {
            this.bindProcedure(preparedStatement, classDescriptor, object, classDescriptor.getUpdateProcedure());
        } else {
            int n;
            int n2 = 1;
            ValueContainer[] valueContainerArray = classDescriptor.getCurrentLockingValues(object);
            classDescriptor.updateLockingValues(object);
            ValueContainer[] valueContainerArray2 = this.getNonKeyValues(this.m_broker, classDescriptor, object);
            for (n = 0; n < valueContainerArray2.length; ++n) {
                if (valueContainerArray2[n].getValue() != null) {
                    this.m_platform.setObjectForStatement(preparedStatement, n2, valueContainerArray2[n].getValue(), valueContainerArray2[n].getJdbcType().getType());
                } else {
                    this.m_platform.setNullForStatement(preparedStatement, n2, valueContainerArray2[n].getJdbcType().getType());
                }
                ++n2;
            }
            valueContainerArray2 = this.getKeyValues(this.m_broker, classDescriptor, object);
            for (n = 0; n < valueContainerArray2.length; ++n) {
                if (valueContainerArray2[n].getValue() != null) {
                    preparedStatement.setObject(n2, valueContainerArray2[n].getValue(), valueContainerArray2[n].getJdbcType().getType());
                } else {
                    preparedStatement.setNull(n2, valueContainerArray2[n].getJdbcType().getType());
                }
                ++n2;
            }
            valueContainerArray2 = valueContainerArray;
            for (n = 0; n < valueContainerArray2.length; ++n) {
                if (valueContainerArray2[n].getValue() != null) {
                    preparedStatement.setObject(n2, valueContainerArray2[n].getValue(), valueContainerArray2[n].getJdbcType().getType());
                } else {
                    preparedStatement.setNull(n2, valueContainerArray2[n].getJdbcType().getType());
                }
                ++n2;
            }
        }
    }

    public int bindValues(PreparedStatement preparedStatement, ValueContainer[] valueContainerArray, int n) throws SQLException {
        if (valueContainerArray != null) {
            for (int i = 0; i < valueContainerArray.length; ++i) {
                this.m_platform.setObjectForStatement(preparedStatement, n, valueContainerArray[i].getValue(), valueContainerArray[i].getJdbcType().getType());
                ++n;
            }
        }
        return n;
    }

    public PreparedStatement getDeleteStatement(ClassDescriptor classDescriptor) throws PersistenceBrokerSQLException, PersistenceBrokerException {
        try {
            return classDescriptor.getStatementsForClass(this.m_conMan).getDeleteStmt(this.m_conMan.getConnection());
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerSQLException("Could not build statement ask for", sQLException);
        }
        catch (LookupException lookupException) {
            throw new PersistenceBrokerException("Used ConnectionManager instance could not obtain a connection", (Throwable)((Object)lookupException));
        }
    }

    public Statement getGenericStatement(ClassDescriptor classDescriptor, boolean bl) throws PersistenceBrokerException {
        try {
            return classDescriptor.getStatementsForClass(this.m_conMan).getGenericStmt(this.m_conMan.getConnection(), bl);
        }
        catch (LookupException lookupException) {
            throw new PersistenceBrokerException("Used ConnectionManager instance could not obtain a connection", (Throwable)((Object)lookupException));
        }
    }

    public PreparedStatement getInsertStatement(ClassDescriptor classDescriptor) throws PersistenceBrokerSQLException, PersistenceBrokerException {
        try {
            return classDescriptor.getStatementsForClass(this.m_conMan).getInsertStmt(this.m_conMan.getConnection());
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerSQLException("Could not build statement ask for", sQLException);
        }
        catch (LookupException lookupException) {
            throw new PersistenceBrokerException("Used ConnectionManager instance could not obtain a connection", (Throwable)((Object)lookupException));
        }
    }

    public PreparedStatement getPreparedStatement(ClassDescriptor classDescriptor, String string, boolean bl) throws PersistenceBrokerException {
        try {
            return classDescriptor.getStatementsForClass(this.m_conMan).getPreparedStmt(this.m_conMan.getConnection(), string, bl);
        }
        catch (LookupException lookupException) {
            throw new PersistenceBrokerException("Used ConnectionManager instance could not obtain a connection", (Throwable)((Object)lookupException));
        }
    }

    public PreparedStatement getSelectByPKStatement(ClassDescriptor classDescriptor) throws PersistenceBrokerSQLException, PersistenceBrokerException {
        try {
            return classDescriptor.getStatementsForClass(this.m_conMan).getSelectByPKStmt(this.m_conMan.getConnection());
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerSQLException("Could not build statement ask for", sQLException);
        }
        catch (LookupException lookupException) {
            throw new PersistenceBrokerException("Used ConnectionManager instance could not obtain a connection", (Throwable)((Object)lookupException));
        }
    }

    public PreparedStatement getUpdateStatement(ClassDescriptor classDescriptor) throws PersistenceBrokerSQLException, PersistenceBrokerException {
        try {
            return classDescriptor.getStatementsForClass(this.m_conMan).getUpdateStmt(this.m_conMan.getConnection());
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerSQLException("Could not build statement ask for", sQLException);
        }
        catch (LookupException lookupException) {
            throw new PersistenceBrokerException("Used ConnectionManager instance could not obtain a connection", (Throwable)((Object)lookupException));
        }
    }

    protected ValueContainer[] getAllValues(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        return this.m_broker.serviceBrokerHelper().getAllRwValues(classDescriptor, object);
    }

    protected ValueContainer[] getKeyValues(PersistenceBroker persistenceBroker, ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        return persistenceBroker.serviceBrokerHelper().getKeyValues(classDescriptor, object);
    }

    protected ValueContainer[] getKeyValues(PersistenceBroker persistenceBroker, ClassDescriptor classDescriptor, Identity identity) throws PersistenceBrokerException {
        return persistenceBroker.serviceBrokerHelper().getKeyValues(classDescriptor, identity);
    }

    protected ValueContainer[] getNonKeyValues(PersistenceBroker persistenceBroker, ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        return persistenceBroker.serviceBrokerHelper().getNonKeyRwValues(classDescriptor, object);
    }

    private void bindProcedure(PreparedStatement preparedStatement, ClassDescriptor classDescriptor, Object object, ProcedureDescriptor procedureDescriptor) throws SQLException {
        int n = 0;
        CallableStatement callableStatement = null;
        if (preparedStatement instanceof CallableStatement) {
            callableStatement = (CallableStatement)preparedStatement;
        }
        if (procedureDescriptor.hasReturnValue() && callableStatement != null) {
            int n2 = procedureDescriptor.getReturnValueFieldRef().getJdbcType().getType();
            this.m_platform.setNullForStatement(preparedStatement, n + 1, n2);
            callableStatement.registerOutParameter(n + 1, n2);
            ++n;
        }
        Iterator iterator = procedureDescriptor.getArguments().iterator();
        while (iterator.hasNext()) {
            ArgumentDescriptor argumentDescriptor = (ArgumentDescriptor)iterator.next();
            Object object2 = argumentDescriptor.getValue(object);
            int n3 = argumentDescriptor.getJdbcType();
            if (object2 != null) {
                this.m_platform.setObjectForStatement(preparedStatement, n + 1, object2, n3);
            } else {
                this.m_platform.setNullForStatement(preparedStatement, n + 1, n3);
            }
            if (argumentDescriptor.getIsReturnedByProcedure() && callableStatement != null) {
                callableStatement.registerOutParameter(n + 1, n3);
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

