/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.JoinSyntaxTypes;
import org.apache.ojb.broker.accesslayer.sql.SqlSelectStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.AnonymousPersistentFieldForInheritance;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.BetweenCriteria;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.ExistsCriteria;
import org.apache.ojb.broker.query.FieldCriteria;
import org.apache.ojb.broker.query.InCriteria;
import org.apache.ojb.broker.query.LikeCriteria;
import org.apache.ojb.broker.query.MtoNQuery;
import org.apache.ojb.broker.query.NullCriteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryBySQL;
import org.apache.ojb.broker.query.SelectionCriteria;
import org.apache.ojb.broker.query.SqlCriteria;
import org.apache.ojb.broker.query.UserAlias;
import org.apache.ojb.broker.util.SqlHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class SqlQueryStatement
implements SqlStatement,
JoinSyntaxTypes {
    private static final String ALIAS_SEPARATOR = ".";
    private SqlQueryStatement m_parentStatement;
    private Logger m_logger;
    private TableAlias m_root;
    private TableAlias m_search;
    private QueryByCriteria m_query;
    private HashMap m_pathToAlias = new HashMap();
    private HashMap m_cldToAlias = new HashMap();
    private HashMap m_joinTreeToCriteria = new HashMap();
    private Platform m_platform;
    private ClassDescriptor m_baseCld;
    private ClassDescriptor m_searchCld;
    private int m_aliasCount = 0;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement$TableAlias;

    public SqlQueryStatement(Platform platform, ClassDescriptor classDescriptor, Query query, Logger logger) {
        this(null, platform, classDescriptor, query, logger);
    }

    public SqlQueryStatement(SqlQueryStatement sqlQueryStatement, Platform platform, ClassDescriptor classDescriptor, Query query, Logger logger) {
        this.m_logger = logger != null ? logger : LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement == null ? (class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement = SqlQueryStatement.class$("org.apache.ojb.broker.accesslayer.sql.SqlQueryStatement")) : class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement);
        this.m_parentStatement = sqlQueryStatement;
        this.m_query = (QueryByCriteria)query;
        this.m_platform = platform;
        this.m_searchCld = classDescriptor;
        this.m_baseCld = this.m_query == null || this.m_query.getBaseClass() == this.m_query.getSearchClass() ? this.m_searchCld : classDescriptor.getRepository().getDescriptorFor(query.getBaseClass());
        this.m_root = this.createTableAlias(this.m_baseCld, null, "");
        this.m_search = this.m_searchCld == this.m_baseCld ? this.m_root : this.getTableAlias(this.m_query.getObjectProjectionAttribute(), false, null, null, this.m_query.getPathClasses());
        this.buildSuperJoinTree(this.m_root, this.m_baseCld, "");
        if (query != null) {
            this.splitCriteria();
        }
    }

    protected ClassDescriptor getBaseClassDescriptor() {
        return this.m_baseCld;
    }

    protected ClassDescriptor getSearchClassDescriptor() {
        return this.m_searchCld;
    }

    protected AttributeInfo getAttributeInfo(String string, boolean bl, UserAlias userAlias, Map map) {
        AttributeInfo attributeInfo = new AttributeInfo();
        TableAlias tableAlias = null;
        SqlHelper.PathInfo pathInfo = SqlHelper.splitPath(string);
        String string2 = pathInfo.column;
        if (string2.startsWith("parentQuery.") && this.m_parentStatement != null) {
            String[] stringArray = new String[]{string2.substring("parentQuery.".length())};
            return this.m_parentStatement.getAttributeInfo(stringArray[0], bl, userAlias, map);
        }
        int n = string2.lastIndexOf(ALIAS_SEPARATOR);
        if (n == -1) {
            tableAlias = this.getRoot();
        } else {
            String[] stringArray;
            String string3 = string2.substring(0, n);
            tableAlias = this.getTableAlias(string3, bl, userAlias, stringArray = new String[]{string2.substring(n + 1)}, map);
            if (tableAlias == null && string2.lastIndexOf(ALIAS_SEPARATOR) == -1) {
                tableAlias = this.getTableAlias(string3, bl, new UserAlias(string3, string3, string3), null, map);
            }
            if (tableAlias != null) {
                pathInfo.column = stringArray[0];
            }
        }
        attributeInfo.tableAlias = tableAlias;
        attributeInfo.pathInfo = pathInfo;
        return attributeInfo;
    }

    protected String getColName(TableAlias tableAlias, SqlHelper.PathInfo pathInfo, boolean bl) {
        FieldDescriptor fieldDescriptor = null;
        String string = null;
        if (bl) {
            fieldDescriptor = this.getFieldDescriptor(tableAlias, pathInfo);
            if (fieldDescriptor != null) {
                if (!fieldDescriptor.getClassDescriptor().getFullTableName().equals(tableAlias.table) && tableAlias.hasJoins()) {
                    Iterator iterator = tableAlias.joins.iterator();
                    while (iterator.hasNext()) {
                        Join join = (Join)iterator.next();
                        if (!join.right.table.equals(fieldDescriptor.getClassDescriptor().getFullTableName())) continue;
                        string = join.right.alias + ALIAS_SEPARATOR + fieldDescriptor.getColumnName();
                        break;
                    }
                    if (string == null) {
                        string = pathInfo.column;
                    }
                } else {
                    string = tableAlias.alias + ALIAS_SEPARATOR + fieldDescriptor.getColumnName();
                }
            } else {
                string = "*".equals(pathInfo.column) ? pathInfo.column : pathInfo.column;
            }
        } else {
            string = pathInfo.column;
        }
        return string;
    }

    protected boolean appendColName(TableAlias tableAlias, SqlHelper.PathInfo pathInfo, boolean bl, StringBuffer stringBuffer) {
        String string = pathInfo.prefix;
        String string2 = pathInfo.suffix;
        String string3 = this.getColName(tableAlias, pathInfo, bl);
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(string3);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        return true;
    }

    protected FieldDescriptor getFieldDescriptor(TableAlias tableAlias, SqlHelper.PathInfo pathInfo) {
        FieldDescriptor fieldDescriptor = null;
        String string = pathInfo.column;
        if (tableAlias != null && (fieldDescriptor = tableAlias.cld.getFieldDescriptorByName(string)) == null) {
            ObjectReferenceDescriptor objectReferenceDescriptor = tableAlias.cld.getObjectReferenceDescriptorByName(string);
            fieldDescriptor = objectReferenceDescriptor != null ? this.getFldFromReference(tableAlias, objectReferenceDescriptor) : this.getFldFromJoin(tableAlias, string);
        }
        return fieldDescriptor;
    }

    private FieldDescriptor getFldFromJoin(TableAlias tableAlias, String string) {
        FieldDescriptor fieldDescriptor = null;
        if (tableAlias.joins != null) {
            Iterator iterator = tableAlias.joins.iterator();
            while (iterator.hasNext()) {
                Join join = (Join)iterator.next();
                ClassDescriptor classDescriptor = join.right.cld;
                if (classDescriptor == null || (fieldDescriptor = classDescriptor.getFieldDescriptorByName(string)) == null) continue;
                break;
            }
        }
        return fieldDescriptor;
    }

    private FieldDescriptor getFldFromReference(TableAlias tableAlias, ObjectReferenceDescriptor objectReferenceDescriptor) {
        FieldDescriptor fieldDescriptor = null;
        if (tableAlias == this.getRoot()) {
            FieldDescriptor[] fieldDescriptorArray = objectReferenceDescriptor.getForeignKeyFieldDescriptors(tableAlias.cld);
            if (fieldDescriptorArray.length > 0) {
                fieldDescriptor = fieldDescriptorArray[0];
            }
        } else {
            ClassDescriptor classDescriptor = tableAlias.cld.getRepository().getDescriptorFor(objectReferenceDescriptor.getItemClass());
            if (classDescriptor != null) {
                fieldDescriptor = tableAlias.cld.getFieldDescriptorByName(classDescriptor.getPkFields()[0].getPersistentField().getName());
            }
        }
        return fieldDescriptor;
    }

    protected boolean appendColName(String string, boolean bl, UserAlias userAlias, StringBuffer stringBuffer) {
        AttributeInfo attributeInfo = this.getAttributeInfo(string, bl, userAlias, this.getQuery().getPathClasses());
        TableAlias tableAlias = attributeInfo.tableAlias;
        return this.appendColName(tableAlias, attributeInfo.pathInfo, true, stringBuffer);
    }

    protected boolean appendColName(String string, String string2, boolean bl, UserAlias userAlias, StringBuffer stringBuffer) {
        AttributeInfo attributeInfo = this.getAttributeInfo(string, bl, userAlias, this.getQuery().getPathClasses());
        TableAlias tableAlias = attributeInfo.tableAlias;
        SqlHelper.PathInfo pathInfo = attributeInfo.pathInfo;
        pathInfo.suffix = pathInfo.suffix != null ? pathInfo.suffix + " as " + string2 : " as " + string2;
        return this.appendColName(tableAlias, pathInfo, true, stringBuffer);
    }

    protected void ensureColumns(List list, List list2) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FieldHelper fieldHelper = (FieldHelper)iterator.next();
            if (list2.contains(fieldHelper.name)) continue;
            this.getAttributeInfo(fieldHelper.name, false, null, this.getQuery().getPathClasses());
        }
    }

    protected List ensureColumns(List list, List list2, StringBuffer stringBuffer) {
        if (list == null || list.isEmpty()) {
            return list2;
        }
        Iterator iterator = list.iterator();
        int n = list2.size() + 1;
        while (iterator.hasNext()) {
            FieldHelper fieldHelper = (FieldHelper)iterator.next();
            if (list2.contains(fieldHelper.name)) continue;
            list2.add(fieldHelper.name);
            stringBuffer.append(",");
            this.appendColName(fieldHelper.name, "ojb_col_" + n, false, null, stringBuffer);
            ++n;
        }
        return list2;
    }

    protected void appendWhereClause(StringBuffer stringBuffer, Criteria criteria, StringBuffer stringBuffer2) {
        if (stringBuffer.length() == 0) {
            stringBuffer = null;
        }
        if (stringBuffer != null || criteria != null && !criteria.isEmpty()) {
            stringBuffer2.append(" WHERE ");
            this.appendClause(stringBuffer, criteria, stringBuffer2);
        }
    }

    protected void appendHavingClause(StringBuffer stringBuffer, Criteria criteria, StringBuffer stringBuffer2) {
        if (stringBuffer.length() == 0) {
            stringBuffer = null;
        }
        if (stringBuffer != null || criteria != null) {
            stringBuffer2.append(" HAVING ");
            this.appendClause(stringBuffer, criteria, stringBuffer2);
        }
    }

    protected void appendClause(StringBuffer stringBuffer, Criteria criteria, StringBuffer stringBuffer2) {
        if (stringBuffer != null) {
            stringBuffer2.append(stringBuffer.toString());
        }
        if (criteria != null) {
            if (stringBuffer == null) {
                stringBuffer2.append(this.asSQLStatement(criteria));
            } else {
                stringBuffer2.append(" AND (");
                stringBuffer2.append(this.asSQLStatement(criteria));
                stringBuffer2.append(")");
            }
        }
    }

    private String asSQLStatement(Criteria criteria) {
        Enumeration enumeration = criteria.getElements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            Object e = enumeration.nextElement();
            if (e instanceof Criteria) {
                serializable = (Criteria)e;
                if (((Criteria)serializable).isEmpty()) continue;
                String string = "";
                String string2 = "";
                if (((Criteria)serializable).isEmbraced()) {
                    string = " (";
                    string2 = ")";
                }
                switch (((Criteria)serializable).getType()) {
                    case 0: {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(" OR ");
                        }
                        stringBuffer.append(string);
                        stringBuffer.append(this.asSQLStatement((Criteria)serializable));
                        stringBuffer.append(string2);
                        break;
                    }
                    case 1: {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.insert(0, "( ");
                            stringBuffer.append(") AND ");
                        }
                        stringBuffer.append(string);
                        stringBuffer.append(this.asSQLStatement((Criteria)serializable));
                        stringBuffer.append(string2);
                    }
                }
                continue;
            }
            serializable = (SelectionCriteria)e;
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, "(");
                stringBuffer.append(") AND ");
            }
            this.appendSQLClause((SelectionCriteria)serializable, stringBuffer);
        }
        if (criteria.isNegative()) {
            stringBuffer.insert(0, " NOT (");
            stringBuffer.append(")");
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    private void appendBetweenCriteria(TableAlias tableAlias, SqlHelper.PathInfo pathInfo, BetweenCriteria betweenCriteria, StringBuffer stringBuffer) {
        this.appendColName(tableAlias, pathInfo, betweenCriteria.isTranslateAttribute(), stringBuffer);
        stringBuffer.append(betweenCriteria.getClause());
        this.appendParameter(betweenCriteria.getValue(), stringBuffer);
        stringBuffer.append(" AND ");
        this.appendParameter(betweenCriteria.getValue2(), stringBuffer);
    }

    private void appendExistsCriteria(ExistsCriteria existsCriteria, StringBuffer stringBuffer) {
        Query query = (Query)existsCriteria.getValue();
        stringBuffer.append(existsCriteria.getClause());
        this.appendSubQuery(query, stringBuffer);
    }

    private void appendFieldCriteria(TableAlias tableAlias, SqlHelper.PathInfo pathInfo, FieldCriteria fieldCriteria, StringBuffer stringBuffer) {
        this.appendColName(tableAlias, pathInfo, fieldCriteria.isTranslateAttribute(), stringBuffer);
        stringBuffer.append(fieldCriteria.getClause());
        if (fieldCriteria.isTranslateField()) {
            this.appendColName((String)fieldCriteria.getValue(), false, fieldCriteria.getUserAlias(), stringBuffer);
        } else {
            stringBuffer.append(fieldCriteria.getValue());
        }
    }

    private void appendInCriteria(TableAlias tableAlias, SqlHelper.PathInfo pathInfo, InCriteria inCriteria, StringBuffer stringBuffer) {
        this.appendColName(tableAlias, pathInfo, inCriteria.isTranslateAttribute(), stringBuffer);
        stringBuffer.append(inCriteria.getClause());
        if (inCriteria.getValue() instanceof Collection) {
            Object[] objectArray = ((Collection)inCriteria.getValue()).toArray();
            int n = ((Collection)inCriteria.getValue()).size();
            stringBuffer.append("(");
            if (n > 0) {
                for (int i = 0; i < n - 1; ++i) {
                    this.appendParameter(objectArray[i], stringBuffer);
                    stringBuffer.append(",");
                }
                this.appendParameter(objectArray[n - 1], stringBuffer);
            }
            stringBuffer.append(")");
        } else {
            this.appendParameter(inCriteria.getValue(), stringBuffer);
        }
    }

    private void appendNullCriteria(TableAlias tableAlias, SqlHelper.PathInfo pathInfo, NullCriteria nullCriteria, StringBuffer stringBuffer) {
        this.appendColName(tableAlias, pathInfo, nullCriteria.isTranslateAttribute(), stringBuffer);
        stringBuffer.append(nullCriteria.getClause());
    }

    private void appendSQLCriteria(SqlCriteria sqlCriteria, StringBuffer stringBuffer) {
        stringBuffer.append(sqlCriteria.getClause());
    }

    private void appendSelectionCriteria(TableAlias tableAlias, SqlHelper.PathInfo pathInfo, SelectionCriteria selectionCriteria, StringBuffer stringBuffer) {
        this.appendColName(tableAlias, pathInfo, selectionCriteria.isTranslateAttribute(), stringBuffer);
        stringBuffer.append(selectionCriteria.getClause());
        this.appendParameter(selectionCriteria.getValue(), stringBuffer);
    }

    private void appendLikeCriteria(TableAlias tableAlias, SqlHelper.PathInfo pathInfo, LikeCriteria likeCriteria, StringBuffer stringBuffer) {
        this.appendColName(tableAlias, pathInfo, likeCriteria.isTranslateAttribute(), stringBuffer);
        stringBuffer.append(likeCriteria.getClause());
        this.appendParameter(likeCriteria.getValue(), stringBuffer);
        stringBuffer.append(this.m_platform.getEscapeClause(likeCriteria));
    }

    protected void appendCriteria(TableAlias tableAlias, SqlHelper.PathInfo pathInfo, SelectionCriteria selectionCriteria, StringBuffer stringBuffer) {
        if (selectionCriteria instanceof FieldCriteria) {
            this.appendFieldCriteria(tableAlias, pathInfo, (FieldCriteria)selectionCriteria, stringBuffer);
        } else if (selectionCriteria instanceof NullCriteria) {
            this.appendNullCriteria(tableAlias, pathInfo, (NullCriteria)selectionCriteria, stringBuffer);
        } else if (selectionCriteria instanceof BetweenCriteria) {
            this.appendBetweenCriteria(tableAlias, pathInfo, (BetweenCriteria)selectionCriteria, stringBuffer);
        } else if (selectionCriteria instanceof InCriteria) {
            this.appendInCriteria(tableAlias, pathInfo, (InCriteria)selectionCriteria, stringBuffer);
        } else if (selectionCriteria instanceof SqlCriteria) {
            this.appendSQLCriteria((SqlCriteria)selectionCriteria, stringBuffer);
        } else if (selectionCriteria instanceof ExistsCriteria) {
            this.appendExistsCriteria((ExistsCriteria)selectionCriteria, stringBuffer);
        } else if (selectionCriteria instanceof LikeCriteria) {
            this.appendLikeCriteria(tableAlias, pathInfo, (LikeCriteria)selectionCriteria, stringBuffer);
        } else {
            this.appendSelectionCriteria(tableAlias, pathInfo, selectionCriteria, stringBuffer);
        }
    }

    protected void appendSQLClause(SelectionCriteria selectionCriteria, StringBuffer stringBuffer) {
        if (selectionCriteria instanceof SqlCriteria) {
            stringBuffer.append(selectionCriteria.getAttribute());
            return;
        }
        if (selectionCriteria.getAttribute() instanceof Query) {
            Query query = (Query)selectionCriteria.getAttribute();
            stringBuffer.append("(");
            stringBuffer.append(this.getSubQuerySQL(query));
            stringBuffer.append(")");
            stringBuffer.append(selectionCriteria.getClause());
            this.appendParameter(selectionCriteria.getValue(), stringBuffer);
            return;
        }
        AttributeInfo attributeInfo = this.getAttributeInfo((String)selectionCriteria.getAttribute(), false, selectionCriteria.getUserAlias(), selectionCriteria.getPathClasses());
        TableAlias tableAlias = attributeInfo.tableAlias;
        if (tableAlias != null) {
            boolean bl = tableAlias.hasExtents();
            if (bl) {
                stringBuffer.append("(");
                this.appendCriteria(tableAlias, attributeInfo.pathInfo, selectionCriteria, stringBuffer);
                selectionCriteria.setNumberOfExtentsToBind(tableAlias.extents.size());
                Iterator iterator = tableAlias.iterateExtents();
                while (iterator.hasNext()) {
                    TableAlias tableAlias2 = (TableAlias)iterator.next();
                    stringBuffer.append(" OR ");
                    this.appendCriteria(tableAlias2, attributeInfo.pathInfo, selectionCriteria, stringBuffer);
                }
                stringBuffer.append(")");
            } else {
                this.appendCriteria(tableAlias, attributeInfo.pathInfo, selectionCriteria, stringBuffer);
            }
        } else {
            this.appendCriteria(tableAlias, attributeInfo.pathInfo, selectionCriteria, stringBuffer);
        }
    }

    private void appendParameter(Object object, StringBuffer stringBuffer) {
        if (object instanceof Query) {
            this.appendSubQuery((Query)object, stringBuffer);
        } else {
            stringBuffer.append("?");
        }
    }

    private void appendSubQuery(Query query, StringBuffer stringBuffer) {
        stringBuffer.append(" (");
        stringBuffer.append(this.getSubQuerySQL(query));
        stringBuffer.append(") ");
    }

    private String getSubQuerySQL(Query query) {
        ClassDescriptor classDescriptor = this.getRoot().cld.getRepository().getDescriptorFor(query.getSearchClass());
        String string = query instanceof QueryBySQL ? ((QueryBySQL)query).getSql() : new SqlSelectStatement(this, this.m_platform, classDescriptor, query, this.m_logger).getStatement();
        return string;
    }

    private TableAlias getTableAlias(String string, boolean bl, UserAlias userAlias, String[] stringArray, Map map) {
        String string2 = null;
        ClassDescriptor classDescriptor = null;
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        boolean bl2 = bl;
        String string3 = userAlias == null ? null : userAlias.getAlias(string);
        TableAlias tableAlias = this.getTableAliasForPath(string, string3);
        if (tableAlias != null) {
            return tableAlias;
        }
        ArrayList arrayList = this.getRoot().cld.getAttributeDescriptorsForPath(string, map);
        TableAlias tableAlias2 = this.getRoot();
        if ((arrayList == null || arrayList.size() == 0) && tableAlias2.hasJoins()) {
            Iterator iterator = tableAlias2.iterateJoins();
            while (iterator.hasNext()) {
                tableAlias2 = ((Join)iterator.next()).left;
                arrayList = tableAlias2.cld.getAttributeDescriptorsForPath(string, map);
                if (arrayList.size() <= 0) continue;
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            if (!(arrayList.get(i) instanceof ObjectReferenceDescriptor)) continue;
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)arrayList.get(i);
            String string4 = objectReferenceDescriptor.getAttributeName();
            string2 = string2 == null ? string4 : string2 + ALIAS_SEPARATOR + string4;
            boolean bl3 = bl2 = bl2 || this.getQuery().isPathOuterJoin(string4);
            if (objectReferenceDescriptor instanceof CollectionDescriptor) {
                CollectionDescriptor collectionDescriptor = (CollectionDescriptor)objectReferenceDescriptor;
                classDescriptor = this.getItemClassDescriptor(collectionDescriptor, string2, map);
                if (!collectionDescriptor.isMtoNRelation()) {
                    objectArray = tableAlias2.cld.getPkFields();
                    objectArray2 = collectionDescriptor.getForeignKeyFieldDescriptors(classDescriptor);
                } else {
                    String string5;
                    object = string2 + "*";
                    TableAlias tableAlias3 = this.getTableAliasForPath((String)object, string5 = userAlias == null ? null : userAlias + "*");
                    if (tableAlias3 == null) {
                        tableAlias3 = this.createTableAlias(collectionDescriptor.getIndirectionTable(), (String)object, string5);
                        objectArray = tableAlias2.cld.getPkFields();
                        objectArray2 = collectionDescriptor.getFksToThisClass();
                        this.addJoin(tableAlias2, objectArray, tableAlias3, objectArray2, bl2, string4 + "*");
                    }
                    tableAlias2 = tableAlias3;
                    objectArray = collectionDescriptor.getFksToItemClass();
                    objectArray2 = classDescriptor.getPkFields();
                }
            } else {
                classDescriptor = this.getItemClassDescriptor(objectReferenceDescriptor, string2, map);
                if (!tableAlias2.cld.equals(objectReferenceDescriptor.getClassDescriptor())) {
                    tableAlias2 = this.getTableAliasForClassDescriptor(objectReferenceDescriptor.getClassDescriptor());
                }
                objectArray = objectReferenceDescriptor.getForeignKeyFieldDescriptors(tableAlias2.cld);
                objectArray2 = classDescriptor.getPkFields();
                if (stringArray != null && i == n - 1) {
                    object = classDescriptor.getPkFields();
                    for (int j = 0; j < ((FieldDescriptor[])object).length; ++j) {
                        if (!object[j].getAttributeName().equals(stringArray[0])) continue;
                        stringArray[0] = ((FieldDescriptor)objectArray[j]).getAttributeName();
                        return tableAlias2;
                    }
                }
            }
            string3 = userAlias == null ? null : userAlias.getAlias(string2);
            tableAlias = this.getTableAliasForPath(string2, string3);
            if (tableAlias == null) {
                object = (List)map.get(string);
                tableAlias = this.createTableAlias(classDescriptor, string2, string3, (List)object);
                bl2 = bl2 || tableAlias.cld == tableAlias2.cld || tableAlias.hasExtents() || bl;
                this.addJoin(tableAlias2, objectArray, tableAlias, objectArray2, bl2, string4);
                this.buildSuperJoinTree(tableAlias, classDescriptor, string);
            }
            tableAlias2 = tableAlias;
        }
        this.m_logger.debug("Result of getTableAlias(): " + tableAlias);
        return tableAlias;
    }

    private void addJoin(TableAlias tableAlias, Object[] objectArray, TableAlias tableAlias2, Object[] objectArray2, boolean bl, String string) {
        Object[] objectArray3;
        TableAlias tableAlias3;
        int n;
        tableAlias.addJoin(new Join(tableAlias, objectArray, tableAlias2, objectArray2, bl, string));
        if (tableAlias2.hasExtents()) {
            for (n = 0; n < tableAlias2.extents.size(); ++n) {
                tableAlias3 = (TableAlias)tableAlias2.extents.get(n);
                objectArray3 = this.getExtentFieldDescriptors(tableAlias3, (FieldDescriptor[])objectArray2);
                tableAlias.addJoin(new Join(tableAlias, objectArray, tableAlias3, objectArray3, true, string));
            }
        }
        if (tableAlias.hasExtents()) {
            for (n = 0; n < tableAlias.extents.size(); ++n) {
                tableAlias3 = (TableAlias)tableAlias.extents.get(n);
                objectArray3 = this.getExtentFieldDescriptors(tableAlias3, (FieldDescriptor[])objectArray);
                TableAlias tableAlias4 = tableAlias2.copy("C" + n);
                tableAlias2.extents.add(tableAlias4);
                tableAlias2.extents.addAll(tableAlias4.extents);
                this.addJoin(tableAlias3, objectArray3, tableAlias4, objectArray2, true, string);
            }
        }
    }

    private FieldDescriptor[] getExtentFieldDescriptors(TableAlias tableAlias, FieldDescriptor[] fieldDescriptorArray) {
        FieldDescriptor[] fieldDescriptorArray2 = new FieldDescriptor[fieldDescriptorArray.length];
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            fieldDescriptorArray2[i] = tableAlias.cld.getFieldDescriptorByName(fieldDescriptorArray[i].getAttributeName());
        }
        return fieldDescriptorArray2;
    }

    private char getAliasChar() {
        char c = 'A';
        if (this.m_parentStatement != null) {
            c = (char)(this.m_parentStatement.getAliasChar() + '\u0001');
        }
        return c;
    }

    private TableAlias createTableAlias(ClassDescriptor classDescriptor, String string, String string2, List list) {
        if (string2 == null) {
            return this.createTableAlias(classDescriptor, list, string);
        }
        return this.createTableAlias(classDescriptor, list, string2 + ALIAS_SEPARATOR + string);
    }

    private TableAlias createTableAlias(ClassDescriptor classDescriptor, List list, String string) {
        boolean bl = false;
        if (!classDescriptor.getExtentClasses().isEmpty() && string.length() > 0) {
            bl = true;
        }
        String string2 = String.valueOf(this.getAliasChar()) + this.m_aliasCount++;
        TableAlias tableAlias = new TableAlias(classDescriptor, string2, bl, list);
        this.m_pathToAlias.put(string, tableAlias);
        return tableAlias;
    }

    private TableAlias createTableAlias(String string, String string2, String string3) {
        if (string3 == null) {
            return this.createTableAlias(string, string2);
        }
        return this.createTableAlias(string, string3 + ALIAS_SEPARATOR + string2);
    }

    private TableAlias createTableAlias(String string, String string2) {
        if (string == null) {
            this.getLogger().warn("Creating TableAlias without table for path: " + string2);
        }
        String string3 = String.valueOf(this.getAliasChar()) + this.m_aliasCount++;
        TableAlias tableAlias = new TableAlias(string, string3);
        this.m_pathToAlias.put(string2, tableAlias);
        this.m_logger.debug("createTableAlias2: path: " + string2 + " tableAlias: " + tableAlias);
        return tableAlias;
    }

    private TableAlias getTableAliasForPath(String string) {
        return (TableAlias)this.m_pathToAlias.get(string);
    }

    private TableAlias getTableAliasForClassDescriptor(ClassDescriptor classDescriptor) {
        return (TableAlias)this.m_cldToAlias.get(classDescriptor);
    }

    private TableAlias getTableAliasForPath(String string, String string2) {
        if (string2 == null) {
            return this.getTableAliasForPath(string);
        }
        return this.getTableAliasForPath(string2 + ALIAS_SEPARATOR + string);
    }

    private ClassDescriptor getItemClassDescriptor(ObjectReferenceDescriptor objectReferenceDescriptor, String string, Map map) {
        ArrayList<Class> arrayList = (ArrayList<Class>)map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Class>();
            arrayList.add(objectReferenceDescriptor.getItemClass());
        }
        ArrayList<ClassDescriptor> arrayList2 = new ArrayList<ClassDescriptor>(arrayList.size());
        DescriptorRepository descriptorRepository = objectReferenceDescriptor.getClassDescriptor().getRepository();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            arrayList2.add(descriptorRepository.getDescriptorFor(clazz));
        }
        return (ClassDescriptor)arrayList2.get(0);
    }

    protected void appendOrderByClause(List list, List list2, StringBuffer stringBuffer) {
        if (list == null || list.size() == 0) {
            return;
        }
        stringBuffer.append(" ORDER BY ");
        for (int i = 0; i < list.size(); ++i) {
            FieldHelper fieldHelper = (FieldHelper)list.get(i);
            int n = list2.indexOf(fieldHelper.name);
            if (i > 0) {
                stringBuffer.append(",");
            }
            if (n >= 0) {
                stringBuffer.append(n + 1);
            } else {
                this.appendColName(fieldHelper.name, false, null, stringBuffer);
            }
            if (fieldHelper.isAscending) continue;
            stringBuffer.append(" DESC");
        }
    }

    protected void appendGroupByClause(List list, StringBuffer stringBuffer) {
        if (list == null || list.size() == 0) {
            return;
        }
        stringBuffer.append(" GROUP BY ");
        for (int i = 0; i < list.size(); ++i) {
            FieldHelper fieldHelper = (FieldHelper)list.get(i);
            if (i > 0) {
                stringBuffer.append(",");
            }
            this.appendColName(fieldHelper.name, false, null, stringBuffer);
        }
    }

    protected void appendTableWithJoins(TableAlias tableAlias, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        int n = 0;
        byte by = this.getJoinSyntaxType();
        if (by == 0) {
            n = stringBuffer2.length();
        }
        if (by != 1 || tableAlias == this.getRoot()) {
            stringBuffer2.append(tableAlias.getTableAndAlias());
            if (this.getQuery() instanceof MtoNQuery) {
                stringBuffer2.append(",");
                stringBuffer2.append(((MtoNQuery)((Object)this.getQuery())).getIndirectionTable());
            }
        }
        if (!tableAlias.hasJoins()) {
            return;
        }
        Iterator iterator = tableAlias.iterateJoins();
        while (iterator.hasNext()) {
            Join join = (Join)iterator.next();
            if (by == 0) {
                this.appendJoinSQL92(join, stringBuffer, stringBuffer2);
                if (!iterator.hasNext()) continue;
                stringBuffer2.insert(n, "(");
                stringBuffer2.append(")");
                continue;
            }
            if (by == 1) {
                this.appendJoinSQL92NoParen(join, stringBuffer, stringBuffer2);
                continue;
            }
            this.appendJoin(stringBuffer, stringBuffer2, join);
        }
    }

    private void appendJoin(StringBuffer stringBuffer, StringBuffer stringBuffer2, Join join) {
        stringBuffer2.append(",");
        this.appendTableWithJoins(join.right, stringBuffer, stringBuffer2);
        if (stringBuffer.length() > 0) {
            stringBuffer.append(" AND ");
        }
        join.appendJoinEqualities(stringBuffer);
    }

    private void appendJoinSQL92(Join join, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (join.isOuter) {
            stringBuffer2.append(" LEFT OUTER JOIN ");
        } else {
            stringBuffer2.append(" INNER JOIN ");
        }
        if (join.right.hasJoins()) {
            stringBuffer2.append("(");
            this.appendTableWithJoins(join.right, stringBuffer, stringBuffer2);
            stringBuffer2.append(")");
        } else {
            this.appendTableWithJoins(join.right, stringBuffer, stringBuffer2);
        }
        stringBuffer2.append(" ON ");
        join.appendJoinEqualities(stringBuffer2);
    }

    private void appendJoinSQL92NoParen(Join join, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (join.isOuter) {
            stringBuffer2.append(" LEFT OUTER JOIN ");
        } else {
            stringBuffer2.append(" INNER JOIN ");
        }
        stringBuffer2.append(join.right.getTableAndAlias());
        stringBuffer2.append(" ON ");
        join.appendJoinEqualities(stringBuffer2);
        this.appendTableWithJoins(join.right, stringBuffer, stringBuffer2);
    }

    private void buildJoinTree(Criteria criteria) {
        Enumeration enumeration = criteria.getElements();
        while (enumeration.hasMoreElements()) {
            boolean bl;
            Object e = enumeration.nextElement();
            if (e instanceof Criteria) {
                this.buildJoinTree((Criteria)e);
                continue;
            }
            SelectionCriteria selectionCriteria = (SelectionCriteria)e;
            if (selectionCriteria instanceof SqlCriteria) continue;
            boolean bl2 = bl = criteria.getType() == 0;
            if (selectionCriteria.getAttribute() != null && selectionCriteria.getAttribute() instanceof String) {
                this.buildJoinTreeForColumn((String)selectionCriteria.getAttribute(), bl, selectionCriteria.getUserAlias(), selectionCriteria.getPathClasses());
            }
            if (!(selectionCriteria instanceof FieldCriteria)) continue;
            FieldCriteria fieldCriteria = (FieldCriteria)selectionCriteria;
            this.buildJoinTreeForColumn((String)fieldCriteria.getValue(), bl, selectionCriteria.getUserAlias(), selectionCriteria.getPathClasses());
        }
    }

    private void buildJoinTreeForColumn(String string, boolean bl, UserAlias userAlias, Map map) {
        String string2 = SqlHelper.cleanPath(string);
        int n = string2.lastIndexOf(ALIAS_SEPARATOR);
        if (n >= 0) {
            this.getTableAlias(string2.substring(0, n), bl, userAlias, new String[]{string2.substring(n + 1)}, map);
        }
    }

    protected void buildSuperJoinTree(TableAlias tableAlias, ClassDescriptor classDescriptor, String string) {
        Iterator iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        while (iterator.hasNext()) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            Object[] objectArray = objectReferenceDescriptor.getForeignKeyFieldDescriptors(classDescriptor);
            ClassDescriptor classDescriptor2 = classDescriptor.getRepository().getDescriptorFor(objectReferenceDescriptor.getItemClassName());
            if (!(objectReferenceDescriptor.getPersistentField() instanceof AnonymousPersistentFieldForInheritance)) continue;
            TableAlias tableAlias2 = this.getTableAliasForPath(string, null);
            String string2 = String.valueOf(this.getAliasChar()) + this.m_aliasCount++;
            TableAlias tableAlias3 = new TableAlias(classDescriptor2, string2, false, null);
            Join join = new Join(tableAlias, objectArray, tableAlias3, classDescriptor2.getPkFields(), false, "superClass");
            tableAlias2.addJoin(join);
            this.buildSuperJoinTree(tableAlias3, classDescriptor2, string);
        }
    }

    protected void splitCriteria() {
        Criteria criteria = this.getQuery().getCriteria();
        Criteria criteria2 = this.getQuery().getHavingCriteria();
        if (criteria == null || criteria.isEmpty()) {
            this.getJoinTreeToCriteria().put(this.getRoot(), null);
        } else {
            this.getJoinTreeToCriteria().put(this.getRoot(), criteria);
            this.buildJoinTree(criteria);
        }
        if (criteria2 != null && !criteria2.isEmpty()) {
            this.buildJoinTree(criteria2);
        }
    }

    protected QueryByCriteria getQuery() {
        return this.m_query;
    }

    protected TableAlias getRoot() {
        return this.m_root;
    }

    protected void setRoot(TableAlias tableAlias) {
        this.m_root = tableAlias;
    }

    protected TableAlias getSearchTable() {
        return this.m_search;
    }

    protected HashMap getJoinTreeToCriteria() {
        return this.m_joinTreeToCriteria;
    }

    protected byte getJoinSyntaxType() {
        return this.m_platform.getJoinSyntaxType();
    }

    protected Logger getLogger() {
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final class Join {
        final TableAlias left;
        final String[] leftKeys;
        final TableAlias right;
        final String[] rightKeys;
        final boolean isOuter;
        final String name;

        Join(TableAlias tableAlias, Object[] objectArray, TableAlias tableAlias2, Object[] objectArray2, boolean bl, String string) {
            this.left = tableAlias;
            this.leftKeys = this.getColumns(objectArray);
            this.right = tableAlias2;
            this.rightKeys = this.getColumns(objectArray2);
            this.isOuter = bl;
            this.name = string;
        }

        private String[] getColumns(Object[] objectArray) {
            String[] stringArray = new String[objectArray.length];
            if (objectArray instanceof FieldDescriptor[]) {
                FieldDescriptor[] fieldDescriptorArray = (FieldDescriptor[])objectArray;
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = fieldDescriptorArray[i].getColumnName();
                }
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = objectArray[i].toString();
                }
            }
            return stringArray;
        }

        void appendJoinEqualities(StringBuffer stringBuffer) {
            byte by = SqlQueryStatement.this.getJoinSyntaxType();
            for (int i = 0; i < this.leftKeys.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(this.left.alias);
                stringBuffer.append(SqlQueryStatement.ALIAS_SEPARATOR);
                stringBuffer.append(this.leftKeys[i]);
                if (this.isOuter && by == 3) {
                    stringBuffer.append("*=");
                } else {
                    stringBuffer.append("=");
                }
                stringBuffer.append(this.right.alias);
                stringBuffer.append(SqlQueryStatement.ALIAS_SEPARATOR);
                stringBuffer.append(this.rightKeys[i]);
                if (!this.isOuter || by != 2) continue;
                stringBuffer.append("(+)");
            }
        }

        public boolean equals(Object object) {
            Join join = (Join)object;
            return this.name.equals(join.name) && this.isOuter == join.isOuter && this.right.equals(join.right);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.left.alias + " -> " + this.right.alias;
        }
    }

    final class TableAlias {
        Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement$TableAlias == null ? (class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement$TableAlias = SqlQueryStatement.class$("org.apache.ojb.broker.accesslayer.sql.SqlQueryStatement$TableAlias")) : class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement$TableAlias);
        ClassDescriptor cld;
        String table;
        final String alias;
        List extents = new ArrayList();
        List hints = new ArrayList();
        List joins;

        TableAlias(String string, String string2) {
            this.cld = null;
            this.table = string;
            this.alias = string2;
        }

        TableAlias(ClassDescriptor classDescriptor, String string) {
            this(classDescriptor, string, false, null);
        }

        TableAlias(ClassDescriptor classDescriptor, String string, boolean bl, List list) {
            this.cld = classDescriptor;
            this.table = classDescriptor.getFullTableName();
            this.alias = string;
            boolean bl2 = false;
            SqlQueryStatement.this.m_cldToAlias.put(classDescriptor, this);
            if (list != null && list.size() > 0) {
                bl2 = true;
            }
            this.logger.debug("TableAlias(): using hints ? " + bl2);
            if (bl) {
                ClassDescriptor[] classDescriptorArray = classDescriptor.getRepository().getAllConcreteSubclassDescriptors(classDescriptor).toArray(new ClassDescriptor[0]);
                HashMap<String, TableAlias> hashMap = new HashMap<String, TableAlias>();
                int n = 0;
                for (int i = 0; i < classDescriptorArray.length; ++i) {
                    ClassDescriptor classDescriptor2 = classDescriptorArray[i];
                    Class clazz = classDescriptor2.getClassOfObject();
                    if (bl2 && !list.contains(clazz)) {
                        this.logger.debug("Skipping class [" + clazz + "] from extents List");
                        ++n;
                        continue;
                    }
                    String string2 = classDescriptor2.getFullTableName();
                    if (classDescriptor.isAbstract() && i == n) {
                        this.cld = classDescriptor2;
                        this.table = string2;
                        continue;
                    }
                    if (hashMap.get(string2) != null || string2.equals(this.table)) continue;
                    hashMap.put(string2, new TableAlias(classDescriptor2, string + "E" + i, false, list));
                }
                this.extents.addAll(hashMap.values());
            }
            if (this.cld == null) {
                throw new PersistenceBrokerSQLException("Table is NULL for alias: " + this.alias);
            }
        }

        ClassDescriptor getClassDescriptor() {
            return this.cld;
        }

        String getTableAndAlias() {
            return this.table + " " + this.alias;
        }

        boolean hasExtents() {
            return !this.extents.isEmpty();
        }

        Iterator iterateExtents() {
            return this.extents.iterator();
        }

        TableAlias copy(String string) {
            Iterator iterator = this.iterateExtents();
            TableAlias tableAlias = this.cld == null ? new TableAlias(this.table, this.alias + string) : new TableAlias(this.cld, this.alias + string);
            while (iterator.hasNext()) {
                TableAlias tableAlias2 = (TableAlias)iterator.next();
                tableAlias.extents.add(tableAlias2.copy(string));
            }
            return tableAlias;
        }

        void addJoin(Join join) {
            if (this.joins == null) {
                this.joins = new ArrayList();
            }
            this.joins.add(join);
        }

        Iterator iterateJoins() {
            return this.joins.iterator();
        }

        boolean hasJoins() {
            return this.joins != null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(1024);
            boolean bl = true;
            stringBuffer.append(this.getTableAndAlias());
            if (this.joins != null) {
                stringBuffer.append(" [");
                Iterator iterator = this.joins.iterator();
                while (iterator.hasNext()) {
                    Join join = (Join)iterator.next();
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("-(");
                    stringBuffer.append(join.name);
                    stringBuffer.append(")->");
                    stringBuffer.append(join.right);
                }
                stringBuffer.append("]");
            }
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            TableAlias tableAlias = (TableAlias)object;
            return this.table.equals(tableAlias.table);
        }

        public int hashCode() {
            return this.table.hashCode();
        }
    }

    static final class AttributeInfo {
        TableAlias tableAlias;
        SqlHelper.PathInfo pathInfo;

        AttributeInfo() {
        }
    }
}

