/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.IdentityFactory;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;

public class IdentityFactoryImpl
implements IdentityFactory {
    private PersistenceBroker broker;

    public IdentityFactoryImpl(PersistenceBroker persistenceBroker) {
        this.broker = persistenceBroker;
    }

    public Identity buildIdentity(Object object) {
        return new Identity(object, this.broker);
    }

    public Identity buildIdentity(ClassDescriptor classDescriptor, Object object) {
        return new Identity(object, this.broker, classDescriptor);
    }

    public Identity buildIdentity(Class clazz, Class clazz2, String[] stringArray, Object[] objectArray) {
        FieldDescriptor[] fieldDescriptorArray;
        Object[] objectArray2 = objectArray;
        if (objectArray == null) {
            throw new NullPointerException("Given primary key value array can't be null");
        }
        if ((objectArray.length != 1 || stringArray != null && stringArray.length != 1) && !this.isOrdered(fieldDescriptorArray = this.broker.getClassDescriptor(clazz).getPkFields(), stringArray)) {
            objectArray2 = this.reorderPKValues(fieldDescriptorArray, stringArray, objectArray);
        }
        return new Identity(clazz, clazz2, objectArray2);
    }

    private Object[] reorderPKValues(FieldDescriptor[] fieldDescriptorArray, String[] stringArray, Object[] objectArray) {
        String string = null;
        Object[] objectArray2 = new Object[fieldDescriptorArray.length];
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            string = fieldDescriptorArray[i].getPersistentField().getName();
            int n = this.findFieldName(stringArray, string);
            objectArray2[i] = objectArray[n];
        }
        return objectArray2;
    }

    private int findFieldName(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        throw new PersistenceBrokerException("Can't find field name '" + string + "' in given array of field names");
    }

    private boolean isOrdered(FieldDescriptor[] fieldDescriptorArray, String[] stringArray) {
        if (fieldDescriptorArray.length > 1 && stringArray == null || fieldDescriptorArray.length != stringArray.length) {
            throw new PersistenceBrokerException("pkFieldName length does not match number of defined PK fields. Expected number of PK fields is " + fieldDescriptorArray.length + ", given number was " + (stringArray != null ? stringArray.length : 0));
        }
        boolean bl = true;
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            bl = bl && fieldDescriptor.getPersistentField().getName().equals(stringArray[i]);
        }
        return bl;
    }

    public Identity buildIdentity(Class clazz, String[] stringArray, Object[] objectArray) {
        return this.buildIdentity(clazz, this.broker.getTopLevelClass(clazz), stringArray, objectArray);
    }

    public Identity buildIdentity(Class clazz, Object object) {
        return this.buildIdentity(clazz, null, new Object[]{object});
    }
}

