/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.accesslayer.RowReader;
import org.apache.ojb.broker.accesslayer.StatementsForClassFactory;
import org.apache.ojb.broker.accesslayer.StatementsForClassIF;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.AnonymousObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DeleteProcedureDescriptor;
import org.apache.ojb.broker.metadata.DescriptorBase;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.IndexDescriptor;
import org.apache.ojb.broker.metadata.InsertProcedureDescriptor;
import org.apache.ojb.broker.metadata.IsolationLevels;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.ObjectCacheDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.UpdateProcedureDescriptor;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.SqlHelper;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public final class ClassDescriptor
extends DescriptorBase
implements Serializable,
XmlCapable,
IsolationLevels {
    private String persistentFieldClassName;
    private static final long serialVersionUID = -5212253607374173965L;
    public static final String OJB_CONCRETE_CLASS = "ojbConcreteClass";
    private static final Class[] NO_PARAMS = new Class[0];
    private InsertProcedureDescriptor insertProcedure;
    private UpdateProcedureDescriptor updateProcedure;
    private DeleteProcedureDescriptor deleteProcedure;
    private transient Method initializationMethod;
    private String initializationMethodName;
    private transient Method factoryMethod;
    private String factoryMethodName;
    private transient boolean alreadyLookedupZeroArguments = false;
    private transient Constructor zeroArgumentConstructor = null;
    private transient boolean ojbConcreteFieldCheckDone = false;
    private transient FieldDescriptor ojbConcreteClassField;
    private transient StatementsForClassIF statementsForClass;
    private DescriptorRepository m_repository;
    private Class factoryClass;
    private String baseClass = null;
    private int m_IsolationLevel = 0;
    private String schema = null;
    private Class m_Class = null;
    private boolean isAbstract = false;
    private String m_TableName = null;
    private Vector superPersistentFieldDescriptors = null;
    private RowReader m_rowReader = null;
    private String superClass;
    private int superClassFieldRef;
    private boolean m_isInterface = false;
    private Class proxyClass = null;
    private String proxyClassName = null;
    private boolean acceptLocks = true;
    private boolean alwaysRefresh = false;
    private int m_ProxyPrefetchingLimit = 50;
    private ObjectCacheDescriptor objectCacheDescriptor;
    private Class[] m_dynamicProxyClassInterfaces;
    private Vector indexes = new Vector();
    private FieldDescriptor m_autoIncrementField = null;
    private FieldDescriptor[] m_FieldDescriptions = null;
    private Vector m_CollectionDescriptors = new Vector();
    private Vector m_ObjectReferenceDescriptors = new Vector();
    private FieldDescriptor[] m_nonPkFieldDescriptors = null;
    private FieldDescriptor[] m_PkFieldDescriptors = null;
    private FieldDescriptor[] m_RwFieldDescriptors = null;
    private FieldDescriptor[] m_RwNonPkFieldDescriptors = null;
    private FieldDescriptor[] m_lockingFieldDescriptors = null;
    private Vector extentClasses = new Vector();
    private Vector extentClassNames = new Vector();
    private Map m_fieldDescriptorNameMap = null;
    private Map m_collectionDescriptorNameMap = null;
    private Map m_objectReferenceDescriptorsNameMap = null;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$ClassDescriptor;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public ClassDescriptor(DescriptorRepository descriptorRepository) {
        this.m_repository = descriptorRepository;
    }

    public String getBaseClass() {
        return this.baseClass;
    }

    public void setBaseClass(String string) {
        this.baseClass = string;
    }

    public void setSuperPersistentFieldDescriptors(Vector vector) {
        this.superPersistentFieldDescriptors = vector;
    }

    public Vector getSuperPersistentFieldDescriptors() {
        return this.superPersistentFieldDescriptors;
    }

    public ObjectCacheDescriptor getObjectCacheDescriptor() {
        return this.objectCacheDescriptor;
    }

    public void setObjectCacheDescriptor(ObjectCacheDescriptor objectCacheDescriptor) {
        this.objectCacheDescriptor = objectCacheDescriptor;
    }

    public void setRowReader(RowReader rowReader) {
        this.m_rowReader = rowReader;
    }

    public synchronized RowReader getRowReader() {
        if (this.m_rowReader == null) {
            OjbConfigurator ojbConfigurator = OjbConfigurator.getInstance();
            Configuration configuration = ojbConfigurator.getConfigurationFor(null);
            Class clazz = configuration.getClass("RowReaderDefaultClass", class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl == null ? (class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl = ClassDescriptor.class$("org.apache.ojb.broker.accesslayer.RowReaderDefaultImpl")) : class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl);
            this.setRowReader(clazz.getName());
        }
        return this.m_rowReader;
    }

    public void setRowReader(String string) {
        try {
            this.m_rowReader = (RowReader)ClassHelper.newInstance(string, class$org$apache$ojb$broker$metadata$ClassDescriptor == null ? (class$org$apache$ojb$broker$metadata$ClassDescriptor = ClassDescriptor.class$("org.apache.ojb.broker.metadata.ClassDescriptor")) : class$org$apache$ojb$broker$metadata$ClassDescriptor, (Object)this);
        }
        catch (Exception exception) {
            throw new MetadataException("Instantiating of current set RowReader failed", exception);
        }
    }

    public String getRowReaderClassName() {
        return this.m_rowReader != null ? this.m_rowReader.getClass().getName() : null;
    }

    public String getClassNameOfObject() {
        return this.m_Class != null ? this.m_Class.getName() : null;
    }

    public Class getClassOfObject() {
        return this.m_Class;
    }

    public void setClassOfObject(Class clazz) {
        this.m_Class = clazz;
        this.isAbstract = Modifier.isAbstract(this.m_Class.getModifiers());
    }

    public void addFieldDescriptor(FieldDescriptor fieldDescriptor) {
        fieldDescriptor.setClassDescriptor(this);
        if (this.m_FieldDescriptions == null) {
            this.m_FieldDescriptions = new FieldDescriptor[1];
            this.m_FieldDescriptions[0] = fieldDescriptor;
        } else {
            int n = this.m_FieldDescriptions.length;
            FieldDescriptor[] fieldDescriptorArray = new FieldDescriptor[n + 1];
            System.arraycopy(this.m_FieldDescriptions, 0, fieldDescriptorArray, 0, n);
            fieldDescriptorArray[n] = fieldDescriptor;
            this.m_FieldDescriptions = fieldDescriptorArray;
            Arrays.sort(this.m_FieldDescriptions, FieldDescriptor.getComparator());
        }
        this.m_fieldDescriptorNameMap = null;
        this.m_PkFieldDescriptors = null;
        this.m_nonPkFieldDescriptors = null;
        this.m_lockingFieldDescriptors = null;
        this.m_RwFieldDescriptors = null;
        this.m_RwNonPkFieldDescriptors = null;
    }

    public boolean removeFieldDescriptor(FieldDescriptor fieldDescriptor) {
        boolean bl = false;
        if (this.m_FieldDescriptions == null) {
            return bl;
        }
        ArrayList<FieldDescriptor> arrayList = new ArrayList<FieldDescriptor>(Arrays.asList(this.m_FieldDescriptions));
        bl = arrayList.remove(fieldDescriptor);
        this.m_FieldDescriptions = arrayList.toArray(new FieldDescriptor[arrayList.size()]);
        this.m_fieldDescriptorNameMap = null;
        this.m_PkFieldDescriptors = null;
        this.m_nonPkFieldDescriptors = null;
        this.m_lockingFieldDescriptors = null;
        this.m_RwFieldDescriptors = null;
        this.m_RwNonPkFieldDescriptors = null;
        return bl;
    }

    public Vector getCollectionDescriptors() {
        return this.m_CollectionDescriptors;
    }

    public void addCollectionDescriptor(CollectionDescriptor collectionDescriptor) {
        this.m_CollectionDescriptors.add(collectionDescriptor);
        collectionDescriptor.setClassDescriptor(this);
        this.m_collectionDescriptorNameMap = null;
    }

    public void removeCollectionDescriptor(CollectionDescriptor collectionDescriptor) {
        this.m_CollectionDescriptors.remove(collectionDescriptor);
        this.m_collectionDescriptorNameMap = null;
    }

    public Vector getObjectReferenceDescriptors() {
        return this.m_ObjectReferenceDescriptors;
    }

    public void addObjectReferenceDescriptor(ObjectReferenceDescriptor objectReferenceDescriptor) {
        this.m_ObjectReferenceDescriptors.add(objectReferenceDescriptor);
        objectReferenceDescriptor.setClassDescriptor(this);
        this.m_objectReferenceDescriptorsNameMap = null;
    }

    public void removeObjectReferenceDescriptor(ObjectReferenceDescriptor objectReferenceDescriptor) {
        this.m_ObjectReferenceDescriptors.remove(objectReferenceDescriptor);
        this.m_objectReferenceDescriptorsNameMap = null;
    }

    public ObjectReferenceDescriptor getObjectReferenceDescriptorByName(String string) {
        Serializable serializable;
        Serializable serializable2;
        if (string == null) {
            return null;
        }
        if (this.m_objectReferenceDescriptorsNameMap == null) {
            serializable2 = new HashMap();
            serializable = this.getObjectReferenceDescriptors();
            for (int i = ((Vector)serializable).size() - 1; i >= 0; --i) {
                ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)((Vector)serializable).get(i);
                ((HashMap)serializable2).put(objectReferenceDescriptor.getPersistentField().getName(), objectReferenceDescriptor);
            }
            this.m_objectReferenceDescriptorsNameMap = serializable2;
        }
        if ((serializable2 = (ObjectReferenceDescriptor)this.m_objectReferenceDescriptorsNameMap.get(string)) == null && (serializable = (ObjectReferenceDescriptor)this.m_objectReferenceDescriptorsNameMap.get(AnonymousObjectReferenceDescriptor.ANONYMOUS_NAME)) != null) {
            ClassDescriptor classDescriptor = this.getRepository().getDescriptorFor(((ObjectReferenceDescriptor)serializable).getItemClass());
            serializable2 = classDescriptor.getObjectReferenceDescriptorByName(string);
        }
        return serializable2;
    }

    public CollectionDescriptor getCollectionDescriptorByName(String string) {
        if (string == null) {
            return null;
        }
        if (this.m_collectionDescriptorNameMap == null) {
            HashMap<String, CollectionDescriptor> hashMap = new HashMap<String, CollectionDescriptor>();
            Vector vector = this.getCollectionDescriptors();
            for (int i = vector.size() - 1; i >= 0; --i) {
                CollectionDescriptor collectionDescriptor = (CollectionDescriptor)vector.get(i);
                hashMap.put(collectionDescriptor.getPersistentField().getName(), collectionDescriptor);
            }
            this.m_collectionDescriptorNameMap = hashMap;
        }
        return (CollectionDescriptor)this.m_collectionDescriptorNameMap.get(string);
    }

    public void addExtentClassName(Class clazz) {
        this.addExtentClass(clazz);
    }

    public void addExtentClass(Class clazz) {
        this.extentClasses.add(clazz);
        this.addExtentClass(clazz.getName());
    }

    public void addExtentClass(String string) {
        this.extentClassNames.add(string);
        if (this.m_repository != null) {
            this.m_repository.addExtent(string, this);
        }
    }

    public void removeExtentClass(String string) {
        this.extentClassNames.remove(string);
        if (this.m_repository != null) {
            this.m_repository.removeExtent(string);
        }
    }

    public synchronized Vector getExtentClasses() {
        if (this.extentClassNames.size() != this.extentClasses.size()) {
            this.extentClasses.clear();
            Iterator iterator = this.extentClassNames.iterator();
            while (iterator.hasNext()) {
                Class clazz;
                String string = (String)iterator.next();
                try {
                    clazz = ClassHelper.getClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new MetadataException("Unable to load class [" + string + "]. Make sure it is available on the classpath.", classNotFoundException);
                }
                this.extentClasses.add(clazz);
            }
        }
        return this.extentClasses;
    }

    public synchronized Vector getExtentClassNames() {
        return this.extentClassNames;
    }

    public boolean isExtent() {
        return this.getExtentClassNames().size() > 0;
    }

    public synchronized Class getProxyClass() {
        if (this.proxyClass == null && this.proxyClassName != null) {
            String string = "dynamic";
            if (string.equalsIgnoreCase(this.proxyClassName)) {
                this.proxyClass = this.getDynamicProxyClass();
            } else {
                try {
                    this.proxyClass = ClassHelper.getClass(this.proxyClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new MetadataException(classNotFoundException);
                }
            }
        }
        return this.proxyClass;
    }

    public void setProxyClass(Class clazz) {
        this.proxyClass = clazz;
        if (this.proxyClass == null) {
            this.setProxyClassName(null);
        } else {
            this.proxyClassName = this.proxyClass.getName();
        }
    }

    public void setProxyClassName(String string) {
        this.proxyClassName = string;
    }

    public String getProxyClassName() {
        return this.proxyClassName;
    }

    public FieldDescriptor[] getFieldDescriptions() {
        return this.m_FieldDescriptions;
    }

    public FieldDescriptor getFieldDescriptorByIndex(int n) {
        return this.m_FieldDescriptions[n - 1];
    }

    public FieldDescriptor getFieldDescriptorByName(String string) {
        if (string == null || this.m_FieldDescriptions == null) {
            return null;
        }
        if (this.m_fieldDescriptorNameMap == null) {
            HashMap<String, FieldDescriptor> hashMap = new HashMap<String, FieldDescriptor>();
            FieldDescriptor[] fieldDescriptorArray = this.getFieldDescriptions();
            for (int i = fieldDescriptorArray.length - 1; i >= 0; --i) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                hashMap.put(fieldDescriptor.getPersistentField().getName(), fieldDescriptor);
            }
            this.m_fieldDescriptorNameMap = hashMap;
        }
        return (FieldDescriptor)this.m_fieldDescriptorNameMap.get(string);
    }

    public FieldDescriptor getFieldDescriptorForPath(String string, Map map) {
        Object e;
        ArrayList arrayList = this.getAttributeDescriptorsForPath(string, map);
        FieldDescriptor fieldDescriptor = null;
        if (!arrayList.isEmpty() && (e = arrayList.get(arrayList.size() - 1)) instanceof FieldDescriptor) {
            fieldDescriptor = (FieldDescriptor)e;
        }
        return fieldDescriptor;
    }

    public FieldDescriptor getFieldDescriptorForPath(String string) {
        return this.getFieldDescriptorForPath(string, new HashMap());
    }

    public FieldDescriptor[] getFieldDescriptorsInHeirarchy() {
        if (this.superClass == null) {
            return this.getFieldDescriptions();
        }
        ClassDescriptor classDescriptor = this.getRepository().getDescriptorFor(this.superClass);
        return this.appendFieldDescriptorArrays(this.getFieldDescriptions(), classDescriptor.getFieldDescriptorsInHeirarchy());
    }

    private FieldDescriptor[] appendFieldDescriptorArrays(FieldDescriptor[] fieldDescriptorArray, FieldDescriptor[] fieldDescriptorArray2) {
        FieldDescriptor fieldDescriptor;
        int n = fieldDescriptorArray.length + fieldDescriptorArray2.length;
        FieldDescriptor[] fieldDescriptorArray3 = new FieldDescriptor[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < fieldDescriptorArray.length) {
            fieldDescriptorArray3[n2] = fieldDescriptor = fieldDescriptorArray[n3];
            ++n3;
            ++n2;
        }
        n3 = 0;
        while (n3 < fieldDescriptorArray2.length) {
            fieldDescriptorArray3[n2] = fieldDescriptor = fieldDescriptorArray2[n3];
            ++n3;
            ++n2;
        }
        return fieldDescriptorArray3;
    }

    public FieldDescriptor getAutoIncrementField() {
        if (this.m_autoIncrementField == null) {
            FieldDescriptor[] fieldDescriptorArray = this.getPkFields();
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                if (!fieldDescriptor.isAutoIncrement()) continue;
                this.m_autoIncrementField = fieldDescriptor;
                break;
            }
        }
        if (this.m_autoIncrementField == null) {
            LoggerFactory.getDefaultLogger().warn(this.getClass().getName() + ": " + "Could not find autoincrement attribute for class: " + this.getClassNameOfObject());
        }
        return this.m_autoIncrementField;
    }

    public FieldDescriptor[] getAutoIncrementFields() {
        ArrayList<FieldDescriptor> arrayList = new ArrayList<FieldDescriptor>();
        for (int i = 0; i < this.m_FieldDescriptions.length; ++i) {
            FieldDescriptor fieldDescriptor = this.m_FieldDescriptions[i];
            if (!fieldDescriptor.isAutoIncrement()) continue;
            arrayList.add(fieldDescriptor);
        }
        return arrayList.toArray(new FieldDescriptor[arrayList.size()]);
    }

    public ValueContainer[] getCurrentLockingValues(Object object) throws PersistenceBrokerException {
        FieldDescriptor[] fieldDescriptorArray = this.getLockingFields();
        ValueContainer[] valueContainerArray = new ValueContainer[fieldDescriptorArray.length];
        for (int i = 0; i < valueContainerArray.length; ++i) {
            ValueContainer valueContainer;
            valueContainerArray[i] = valueContainer = new ValueContainer(fieldDescriptorArray[i].getPersistentField().get(object), fieldDescriptorArray[i].getJdbcType());
        }
        return valueContainerArray;
    }

    public void updateLockingValues(Object object) throws PersistenceBrokerException {
        FieldDescriptor[] fieldDescriptorArray = this.getLockingFields();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            if (!fieldDescriptor.isUpdateLock()) continue;
            PersistentField persistentField = fieldDescriptor.getPersistentField();
            Object object2 = null;
            object2 = persistentField.get(object);
            if (persistentField.getType() == Integer.TYPE || persistentField.getType() == (class$java$lang$Integer == null ? ClassDescriptor.class$("java.lang.Integer") : class$java$lang$Integer)) {
                int n = 0;
                if (object2 != null) {
                    n = ((Number)object2).intValue();
                }
                persistentField.set(object, new Integer(++n));
                continue;
            }
            if (persistentField.getType() == Long.TYPE || persistentField.getType() == (class$java$lang$Long == null ? ClassDescriptor.class$("java.lang.Long") : class$java$lang$Long)) {
                long l = 0L;
                if (object2 != null) {
                    l = ((Number)object2).longValue();
                }
                persistentField.set(object, new Long(++l));
                continue;
            }
            if (persistentField.getType() != (class$java$sql$Timestamp == null ? ClassDescriptor.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) continue;
            long l = new Date().getTime();
            Timestamp timestamp = new Timestamp(l);
            timestamp.setNanos(0);
            persistentField.set(object, timestamp);
        }
    }

    public FieldDescriptor[] getNonPkFields() {
        if (this.m_nonPkFieldDescriptors == null) {
            Vector<FieldDescriptor> vector = new Vector<FieldDescriptor>();
            for (int i = 0; i < this.m_FieldDescriptions.length; ++i) {
                FieldDescriptor fieldDescriptor = this.m_FieldDescriptions[i];
                if (fieldDescriptor.isPrimaryKey()) continue;
                vector.add(fieldDescriptor);
            }
            Collections.sort(vector, FieldDescriptor.getComparator());
            this.m_nonPkFieldDescriptors = vector.toArray(new FieldDescriptor[vector.size()]);
        }
        return this.m_nonPkFieldDescriptors;
    }

    public FieldDescriptor[] getPkFields() {
        if (this.m_PkFieldDescriptors == null) {
            Vector<FieldDescriptor> vector = new Vector<FieldDescriptor>();
            FieldDescriptor[] fieldDescriptorArray = null;
            if (this.m_isInterface) {
                if (this.getExtentClasses().size() == 0) {
                    throw new PersistenceBrokerException("No Implementors declared for interface " + this.getClassOfObject().getName());
                }
                Class clazz = (Class)this.getExtentClasses().get(0);
                ClassDescriptor classDescriptor = this.getRepository().getDescriptorFor(clazz);
                this.m_PkFieldDescriptors = classDescriptor.getPkFields();
                return this.m_PkFieldDescriptors;
            }
            fieldDescriptorArray = this.getFieldDescriptions();
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                if (!fieldDescriptor.isPrimaryKey()) continue;
                vector.add(fieldDescriptor);
            }
            Collections.sort(vector, FieldDescriptor.getComparator());
            this.m_PkFieldDescriptors = vector.toArray(new FieldDescriptor[vector.size()]);
        }
        return this.m_PkFieldDescriptors;
    }

    public FieldDescriptor[] getNonPkRwFields() {
        if (this.m_RwNonPkFieldDescriptors == null) {
            FieldDescriptor[] fieldDescriptorArray = this.getNonPkFields();
            ArrayList<FieldDescriptor> arrayList = new ArrayList<FieldDescriptor>();
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                if (fieldDescriptor.isAccessReadOnly()) continue;
                arrayList.add(fieldDescriptor);
            }
            this.m_RwNonPkFieldDescriptors = arrayList.toArray(new FieldDescriptor[arrayList.size()]);
        }
        return this.m_RwNonPkFieldDescriptors;
    }

    public FieldDescriptor[] getAllRwFields() {
        if (this.m_RwFieldDescriptors == null) {
            FieldDescriptor[] fieldDescriptorArray = this.getFieldDescriptions();
            ArrayList<FieldDescriptor> arrayList = new ArrayList<FieldDescriptor>();
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                if (fieldDescriptor.isAccessReadOnly()) continue;
                arrayList.add(fieldDescriptor);
            }
            this.m_RwFieldDescriptors = arrayList.toArray(new FieldDescriptor[arrayList.size()]);
        }
        return this.m_RwFieldDescriptors;
    }

    public FieldDescriptor getPrimaryKey() {
        FieldDescriptor[] fieldDescriptorArray = this.getPkFields();
        if (fieldDescriptorArray != null && fieldDescriptorArray.length > 0) {
            return fieldDescriptorArray[0];
        }
        return null;
    }

    public FieldDescriptor[] getLockingFields() {
        if (this.m_lockingFieldDescriptors == null) {
            Vector<FieldDescriptor> vector = new Vector<FieldDescriptor>();
            for (int i = 0; i < this.m_FieldDescriptions.length; ++i) {
                FieldDescriptor fieldDescriptor = this.m_FieldDescriptions[i];
                if (!fieldDescriptor.isLocking()) continue;
                vector.add(fieldDescriptor);
            }
            Collections.sort(vector, FieldDescriptor.getComparator());
            this.m_lockingFieldDescriptors = vector.toArray(new FieldDescriptor[vector.size()]);
        }
        return this.m_lockingFieldDescriptors;
    }

    public boolean isLocking() {
        return this.getLockingFields().length > 0;
    }

    public Class getDynamicProxyClass() {
        Class clazz = this.getClassOfObject();
        if (this.m_dynamicProxyClassInterfaces == null) {
            this.m_dynamicProxyClassInterfaces = this.getInterfaces(clazz);
        }
        Class<?> clazz2 = Proxy.getProxyClass(clazz.getClassLoader(), this.m_dynamicProxyClassInterfaces);
        return clazz2;
    }

    private Class[] getInterfaces(Class clazz) {
        Object object;
        Class clazz2 = clazz;
        Class[] classArray = clazz.getInterfaces();
        if (clazz.isInterface()) {
            object = new Class[classArray.length + 1];
            object[0] = clazz;
            System.arraycopy(classArray, 0, object, 1, classArray.length);
            classArray = object;
        }
        while ((clazz2 = clazz2.getSuperclass()) != null) {
            object = clazz2.getInterfaces();
            Class[] classArray2 = new Class[classArray.length + ((Class[])object).length];
            System.arraycopy(classArray, 0, classArray2, 0, classArray.length);
            System.arraycopy(object, 0, classArray2, classArray.length, ((Object)object).length);
            classArray = classArray2;
        }
        object = new HashMap();
        for (int i = 0; i < classArray.length; ++i) {
            ((HashMap)object).put(classArray[i].getName(), classArray[i]);
        }
        classArray = ((HashMap)object).values().toArray(new Class[((HashMap)object).size()]);
        return classArray;
    }

    public ArrayList getAttributeDescriptorsForPath(String string) {
        return this.getAttributeDescriptorsForPath(string, new HashMap());
    }

    public ArrayList getAttributeDescriptorsForPath(String string, Map map) {
        return this.getAttributeDescriptorsForCleanPath(SqlHelper.cleanPath(string), map);
    }

    private ArrayList getAttributeDescriptorsForCleanPath(String string, Map map) {
        ArrayList<AttributeDescriptorBase> arrayList = new ArrayList<AttributeDescriptorBase>();
        ClassDescriptor classDescriptor = this;
        ObjectReferenceDescriptor objectReferenceDescriptor = null;
        FieldDescriptor fieldDescriptor = null;
        String string2 = string;
        Class clazz = null;
        while (string2.length() > 0) {
            String string3;
            int n = string2.indexOf(".");
            if (n >= 0) {
                string3 = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            } else {
                string3 = string2;
                string2 = "";
            }
            objectReferenceDescriptor = classDescriptor.getObjectReferenceDescriptorByName(string3);
            if (objectReferenceDescriptor == null) {
                objectReferenceDescriptor = classDescriptor.getCollectionDescriptorByName(string3);
            }
            if (objectReferenceDescriptor != null) {
                List list = (List)map.get(string3);
                clazz = list != null && list.get(0) != null ? (Class)list.get(0) : objectReferenceDescriptor.getItemClass();
                classDescriptor = classDescriptor.getRepository().getDescriptorFor(clazz);
                arrayList.add(objectReferenceDescriptor);
                continue;
            }
            fieldDescriptor = classDescriptor.getFieldDescriptorByName(string3);
            if (fieldDescriptor == null) continue;
            arrayList.add(fieldDescriptor);
        }
        return arrayList;
    }

    public Constructor getZeroArgumentConstructor() {
        if (this.zeroArgumentConstructor == null && !this.alreadyLookedupZeroArguments) {
            try {
                this.zeroArgumentConstructor = this.getClassOfObject().getConstructor(NO_PARAMS);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    this.zeroArgumentConstructor = this.getClassOfObject().getDeclaredConstructor(NO_PARAMS);
                    this.zeroArgumentConstructor.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    LoggerFactory.getDefaultLogger().warn(this.getClass().getName() + ": " + "No zero argument constructor defined for " + this.getClassOfObject());
                }
            }
            this.alreadyLookedupZeroArguments = true;
        }
        return this.zeroArgumentConstructor;
    }

    public String toXML() {
        RepositoryTags repositoryTags = RepositoryTags.getInstance();
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(string);
        stringBuffer.append("  <!-- Mapping for Class ");
        stringBuffer.append(this.getClassNameOfObject());
        stringBuffer.append(" -->");
        stringBuffer.append(string);
        stringBuffer.append("  ");
        stringBuffer.append(repositoryTags.getOpeningTagNonClosingById(12));
        stringBuffer.append(string);
        stringBuffer.append("    ");
        stringBuffer.append(repositoryTags.getAttribute(13, this.getClassNameOfObject()));
        stringBuffer.append(string);
        if (null != this.getRepository() && this.getIsolationLevel() != this.getRepository().getDefaultIsolationLevel()) {
            stringBuffer.append("    ");
            stringBuffer.append(repositoryTags.getAttribute(34, this.isolationLevelXml()));
            stringBuffer.append(string);
        }
        Class clazz = null;
        try {
            clazz = this.getProxyClass();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (clazz != null) {
            if (ProxyHelper.isNormalOjbProxy(clazz)) {
                stringBuffer.append("    ");
                stringBuffer.append(repositoryTags.getAttribute(35, "dynamic"));
                stringBuffer.append(string);
            } else {
                stringBuffer.append("    ");
                stringBuffer.append(repositoryTags.getAttribute(35, this.getProxyClassName()));
                stringBuffer.append(string);
            }
            stringBuffer.append("        ");
            stringBuffer.append(repositoryTags.getAttribute(114, "" + this.getProxyPrefetchingLimit()));
            stringBuffer.append(string);
        }
        if (this.getSchema() != null) {
            stringBuffer.append("    ");
            stringBuffer.append(repositoryTags.getAttribute(5, this.getSchema()));
            stringBuffer.append(string);
        }
        if (this.getTableName() != null) {
            stringBuffer.append("    ");
            stringBuffer.append(repositoryTags.getAttribute(14, this.getTableName()));
            stringBuffer.append(string);
        }
        if (this.getRowReaderClassName() != null) {
            stringBuffer.append("    ");
            stringBuffer.append(repositoryTags.getAttribute(32, this.getRowReaderClassName()));
            stringBuffer.append(string);
        }
        if (!this.acceptLocks) {
            stringBuffer.append("        ");
            stringBuffer.append(repositoryTags.getAttribute(78, "false"));
            stringBuffer.append(string);
        }
        if (this.getInitializationMethod() != null) {
            stringBuffer.append("    ");
            stringBuffer.append(repositoryTags.getAttribute(93, this.getInitializationMethod().getName()));
            stringBuffer.append(string);
        }
        if (this.getFactoryClass() != null) {
            stringBuffer.append("    ");
            stringBuffer.append(repositoryTags.getAttribute(100, this.getFactoryClass().getName()));
            stringBuffer.append(string);
        }
        if (this.getFactoryMethod() != null) {
            stringBuffer.append("    ");
            stringBuffer.append(repositoryTags.getAttribute(101, this.getFactoryMethod().getName()));
            stringBuffer.append(string);
        }
        if (this.isAlwaysRefresh()) {
            stringBuffer.append("    ");
            stringBuffer.append(repositoryTags.getAttribute(47, "true"));
            stringBuffer.append(string);
        }
        stringBuffer.append("  >");
        stringBuffer.append(string);
        if (this.isInterface()) {
            for (int i = 0; i < this.getExtentClassNames().size(); ++i) {
                stringBuffer.append("      ");
                stringBuffer.append(repositoryTags.getOpeningTagNonClosingById(33));
                stringBuffer.append(" ");
                stringBuffer.append(repositoryTags.getAttribute(68, this.getExtentClassNames().get(i).toString()));
                stringBuffer.append(" />");
                stringBuffer.append(string);
            }
        } else {
            int n;
            if (this.isExtent()) {
                for (int i = 0; i < this.getExtentClassNames().size(); ++i) {
                    stringBuffer.append("      ");
                    stringBuffer.append(repositoryTags.getOpeningTagNonClosingById(33));
                    stringBuffer.append(" ");
                    stringBuffer.append(repositoryTags.getAttribute(68, this.getExtentClassNames().get(i).toString()));
                    stringBuffer.append(" />");
                    stringBuffer.append(string);
                }
            }
            FieldDescriptor[] fieldDescriptorArray = this.getFieldDescriptions();
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                stringBuffer.append(fieldDescriptorArray[i].toXML());
            }
            Vector vector = this.getObjectReferenceDescriptors();
            for (int i = 0; i < vector.size(); ++i) {
                stringBuffer.append(((ObjectReferenceDescriptor)vector.get(i)).toXML());
            }
            Vector vector2 = this.getCollectionDescriptors();
            for (n = 0; n < vector2.size(); ++n) {
                stringBuffer.append(((CollectionDescriptor)vector2.get(n)).toXML());
            }
            for (n = 0; n < this.indexes.size(); ++n) {
                IndexDescriptor indexDescriptor = (IndexDescriptor)this.indexes.elementAt(n);
                stringBuffer.append(indexDescriptor.toXML());
            }
            if (this.getInsertProcedure() != null) {
                stringBuffer.append(this.getInsertProcedure().toXML());
            }
            if (this.getUpdateProcedure() != null) {
                stringBuffer.append(this.getUpdateProcedure().toXML());
            }
            if (this.getDeleteProcedure() != null) {
                stringBuffer.append(this.getDeleteProcedure().toXML());
            }
        }
        stringBuffer.append("  ");
        stringBuffer.append(repositoryTags.getClosingTagById(12));
        return stringBuffer.toString();
    }

    private String isolationLevelXml() {
        switch (this.getIsolationLevel()) {
            case 4: {
                return "optimistic";
            }
            case 1: {
                return "read-committed";
            }
            case 0: {
                return "read-uncommitted";
            }
            case 2: {
                return "repeatable-read";
            }
            case 3: {
                return "serializable";
            }
        }
        return "read-uncommitted";
    }

    public void setSuperClass(String string) {
        this.superClass = string;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public void setSuperClassFieldRef(int n) {
        this.superClassFieldRef = n;
    }

    public int getSuperClassFieldRef() {
        return this.superClassFieldRef;
    }

    public boolean isInterface() {
        return this.m_isInterface;
    }

    public void setIsInterface(boolean bl) {
        this.m_isInterface = bl;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isAcceptLocks() {
        return this.acceptLocks;
    }

    public void setAcceptLocks(boolean bl) {
        this.acceptLocks = bl;
    }

    public Vector getIndexes() {
        return this.indexes;
    }

    public void setIndexes(Vector vector) {
        this.indexes = vector;
    }

    public DescriptorRepository getRepository() {
        return this.m_repository;
    }

    public void setRepository(DescriptorRepository descriptorRepository) {
        this.m_repository = descriptorRepository;
    }

    public int getIsolationLevel() {
        return this.m_IsolationLevel;
    }

    public void setIsolationLevel(int n) {
        this.m_IsolationLevel = n;
    }

    private String getTableName() {
        return this.m_TableName;
    }

    public void setTableName(String string) {
        this.m_TableName = string;
    }

    public String getFullTableName() {
        if (this.getSchema() != null) {
            return this.getSchema() + "." + this.getTableName();
        }
        return this.getTableName();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        return toStringBuilder.append("classNameOfObject", (Object)this.getClassNameOfObject()).append("tableName", (Object)this.getTableName()).append("schema", (Object)this.getSchema()).append("isInterface", this.isInterface()).append("extendClassNames", (Object)this.getExtentClassNames().toString()).append((Object[])this.getFieldDescriptions()).toString();
    }

    private void setInitializationMethod(Method method) {
        if (method != null) {
            if (method.getParameterTypes().length > 0) {
                throw new MetadataException("Initialization methods must be zero argument methods: " + method.getClass().getName() + "." + method.getName());
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
        }
        this.initializationMethod = method;
    }

    public void setInitializationMethod(String string) {
        Method method = null;
        if (string != null) {
            this.initializationMethodName = string;
            try {
                method = this.getClassOfObject().getMethod(string, NO_PARAMS);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = this.getClassOfObject().getDeclaredMethod(string, NO_PARAMS);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    throw new MetadataException("Invalid initialization method, there is not a zero argument method named " + string + " on class " + this.getClassOfObject().getName() + ".");
                }
            }
        }
        this.setInitializationMethod(method);
    }

    public synchronized Method getInitializationMethod() {
        if (this.initializationMethod == null) {
            this.setInitializationMethod(this.initializationMethodName);
        }
        return this.initializationMethod;
    }

    public boolean isAlwaysRefresh() {
        return this.alwaysRefresh;
    }

    public void setAlwaysRefresh(boolean bl) {
        this.alwaysRefresh = bl;
    }

    public int getProxyPrefetchingLimit() {
        return this.m_ProxyPrefetchingLimit;
    }

    public void setProxyPrefetchingLimit(int n) {
        this.m_ProxyPrefetchingLimit = n;
    }

    public synchronized Class getFactoryClass() {
        return this.factoryClass;
    }

    public synchronized Method getFactoryMethod() {
        if (this.factoryMethod == null && this.factoryMethodName != null) {
            this.setFactoryMethod(this.factoryMethodName);
        }
        return this.factoryMethod;
    }

    public void setFactoryClass(Class clazz) {
        this.factoryClass = clazz;
    }

    public void setFactoryClass(String string) {
        if (null != string) {
            try {
                Class<?> clazz = Class.forName(string);
                this.setFactoryClass(clazz);
            }
            catch (Exception exception) {
                throw new MetadataException("Invalid factory class: " + string + ".");
            }
        } else {
            this.setFactoryClass((Class)null);
        }
    }

    private void setFactoryMethod(Method method) {
        if (method != null) {
            if (method.getParameterTypes().length > 0) {
                throw new MetadataException("Factory methods must be zero argument methods: " + method.getClass().getName() + "." + method.getName());
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
        }
        this.factoryMethod = method;
    }

    public void setFactoryMethod(String string) {
        Method method = null;
        this.factoryMethodName = string;
        if (string != null) {
            try {
                method = this.getFactoryClass().getMethod(string, NO_PARAMS);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = this.getFactoryClass().getDeclaredMethod(string, NO_PARAMS);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    throw new MetadataException("Invalid factory method, there is not a zero argument method named " + string + " on class " + this.getFactoryClass().getName() + ".");
                }
            }
        }
        this.setFactoryMethod(method);
    }

    public void setInsertProcedure(InsertProcedureDescriptor insertProcedureDescriptor) {
        this.insertProcedure = insertProcedureDescriptor;
    }

    public InsertProcedureDescriptor getInsertProcedure() {
        return this.insertProcedure;
    }

    public void setUpdateProcedure(UpdateProcedureDescriptor updateProcedureDescriptor) {
        this.updateProcedure = updateProcedureDescriptor;
    }

    public UpdateProcedureDescriptor getUpdateProcedure() {
        return this.updateProcedure;
    }

    public void setDeleteProcedure(DeleteProcedureDescriptor deleteProcedureDescriptor) {
        this.deleteProcedure = deleteProcedureDescriptor;
    }

    public DeleteProcedureDescriptor getDeleteProcedure() {
        return this.deleteProcedure;
    }

    public FieldDescriptor getOjbConcreteClassField() {
        if (!this.ojbConcreteFieldCheckDone) {
            this.ojbConcreteClassField = this.getFieldDescriptorByName(OJB_CONCRETE_CLASS);
            this.ojbConcreteFieldCheckDone = true;
        }
        return this.ojbConcreteClassField;
    }

    public StatementsForClassIF getStatementsForClass(ConnectionManagerIF connectionManagerIF) {
        if (this.statementsForClass == null) {
            this.statementsForClass = StatementsForClassFactory.getInstance().getStatementsForClass(connectionManagerIF.getConnectionDescriptor(), this);
        }
        return this.statementsForClass;
    }

    public void setPersistentFieldClassName(String string) {
        this.persistentFieldClassName = string;
    }

    public String getPersistentFieldClassName() {
        return this.persistentFieldClassName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

