/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.util.ConstructorHelper;

public class ClassHelper {
    private static final Object[] NO_ARGS = new Object[0];
    private static final Class[] NO_ARGS_CLASS = new Class[0];
    private static ClassLoader _classLoader = null;
    private static Object _mutex = new Object();

    private ClassHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClassLoader(ClassLoader classLoader) {
        Object object = _mutex;
        synchronized (object) {
            _classLoader = classLoader;
        }
    }

    public static ClassLoader getClassLoader() {
        return _classLoader == null ? Thread.currentThread().getContextClassLoader() : _classLoader;
    }

    public static URL getResource(String string) {
        return ClassHelper.getClassLoader().getResource(string);
    }

    public static Class getClass(String string, boolean bl) throws ClassNotFoundException {
        return Class.forName(string, bl, ClassHelper.getClassLoader());
    }

    public static Object newInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    public static Object newInstance(Class clazz, boolean bl) throws InstantiationException, IllegalAccessException {
        if (bl) {
            try {
                return ClassHelper.newInstance(clazz, NO_ARGS_CLASS, NO_ARGS, bl);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new OJBRuntimeException("Unexpected exception while instantiate class '" + clazz + "' with default constructor", invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new OJBRuntimeException("Unexpected exception while instantiate class '" + clazz + "' with default constructor", noSuchMethodException);
            }
        }
        return clazz.newInstance();
    }

    public static Object newInstance(Class clazz, Class[] classArray, Object[] objectArray) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return ClassHelper.newInstance(clazz, classArray, objectArray, false);
    }

    public static Object newInstance(Class clazz, Class[] classArray, Object[] objectArray, boolean bl) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Constructor constructor;
        if (bl) {
            constructor = clazz.getDeclaredConstructor(classArray);
            if (bl && !constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
        } else {
            constructor = clazz.getConstructor(classArray);
        }
        return constructor.newInstance(objectArray);
    }

    public static Method getMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Field getField(Class clazz, String string) {
        try {
            return clazz.getField(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Class getClass(String string) throws ClassNotFoundException {
        return ClassHelper.getClass(string, true);
    }

    public static Object newInstance(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return ClassHelper.newInstance(ClassHelper.getClass(string));
    }

    public static Object newInstance(String string, Class[] classArray, Object[] objectArray) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        return ClassHelper.newInstance(ClassHelper.getClass(string), classArray, objectArray);
    }

    public static Object newInstance(Class clazz, Class clazz2, Object object) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return ClassHelper.newInstance(clazz, new Class[]{clazz2}, new Object[]{object});
    }

    public static Object newInstance(String string, Class clazz, Object object) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        return ClassHelper.newInstance(string, new Class[]{clazz}, new Object[]{object});
    }

    public static Method getMethod(Object object, String string, Class[] classArray) {
        return ClassHelper.getMethod(object.getClass(), string, classArray);
    }

    public static Method getMethod(String string, String string2, Class[] classArray) {
        try {
            return ClassHelper.getMethod(ClassHelper.getClass(string, false), string2, classArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object buildNewObjectInstance(ClassDescriptor classDescriptor) {
        Object object = null;
        if (classDescriptor.getFactoryClass() == null || classDescriptor.getFactoryMethod() == null) {
            try {
                Constructor constructor = classDescriptor.getZeroArgumentConstructor();
                object = ConstructorHelper.instantiate(constructor);
            }
            catch (InstantiationException instantiationException) {
                throw new ClassNotPersistenceCapableException("Can't instantiate class '" + classDescriptor.getClassNameOfObject() + "'");
            }
        }
        try {
            Method method = classDescriptor.getFactoryMethod();
            if (Modifier.isStatic(method.getModifiers())) {
                object = method.invoke(null, null);
            } else {
                Object t = classDescriptor.getFactoryClass().newInstance();
                object = method.invoke(t, null);
            }
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException("Unable to build object instance of class '" + classDescriptor.getClassNameOfObject() + "' from factory:" + classDescriptor.getFactoryClass() + "." + classDescriptor.getFactoryMethod(), exception);
        }
        return object;
    }
}

