/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.ObjectModificationDefaultImpl;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;
import org.apache.ojb.broker.util.sequence.HighLowSequence;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public class SequenceManagerHighLowImpl
extends AbstractSequenceManager {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl = SequenceManagerHighLowImpl.class$("org.apache.ojb.broker.util.sequence.SequenceManagerHighLowImpl")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl);
    private static final String GLOBAL_SEQUENCE_NAME = "global - default sequence name";
    public static final String PROPERTY_GRAB_SIZE = "grabSize";
    public static final String PROPERTY_GLOBAL_SEQUENCE_ID = "globalSequenceId";
    public static final String PROPERTY_GLOBAL_SEQUENCE_START = "globalSequenceStart";
    private static final String DEPRECATED_COLUMN = "deprecatedColumn";
    private static final String PK_FIELD = "tableName";
    protected static Map sequencesMap = new HashMap();
    protected boolean useGlobalSequenceIdentities;
    protected int grabSize = Integer.parseInt(this.getConfigurationProperty("grabSize", "20"));
    protected long globalSequenceStart;
    protected int attempts;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$HighLowSequence;

    public SequenceManagerHighLowImpl(PersistenceBroker persistenceBroker) {
        super(persistenceBroker);
        this.useGlobalSequenceIdentities = Boolean.valueOf(this.getConfigurationProperty(PROPERTY_GLOBAL_SEQUENCE_ID, "false"));
        this.globalSequenceStart = Long.parseLong(this.getConfigurationProperty(PROPERTY_GLOBAL_SEQUENCE_START, "10000"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getUniqueLong(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        String string = this.buildSequenceName(fieldDescriptor);
        Map map = sequencesMap;
        synchronized (map) {
            long l;
            HighLowSequence highLowSequence = (HighLowSequence)sequencesMap.get(string);
            if (highLowSequence == null) {
                highLowSequence = this.getSequence(this.getBrokerForClass(), fieldDescriptor, string);
                sequencesMap.put(string, highLowSequence);
            }
            if ((l = highLowSequence.getNextId()) == 0L) {
                highLowSequence = this.getSequence(this.getBrokerForClass(), fieldDescriptor, string);
                sequencesMap.put(string, highLowSequence);
                l = highLowSequence.getNextId();
                if (l == 0L) {
                    sequencesMap.remove(string);
                    throw new SequenceManagerException("Sequence generation failed: " + SystemUtils.LINE_SEPARATOR + "Sequence: " + highLowSequence + ". Unable to build new ID, id was always 0." + SystemUtils.LINE_SEPARATOR + "Thread: " + Thread.currentThread() + SystemUtils.LINE_SEPARATOR + "PB: " + this.getBrokerForClass());
                }
            }
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HighLowSequence getSequence(PersistenceBroker persistenceBroker, FieldDescriptor fieldDescriptor, String string) throws SequenceManagerException {
        HighLowSequence highLowSequence = null;
        PersistenceBroker persistenceBroker2 = null;
        try {
            try {
                persistenceBroker2 = PersistenceBrokerFactory.createPersistenceBroker(persistenceBroker.getPBKey());
                persistenceBroker2.beginTransaction();
                highLowSequence = this.lookupStoreSequence(persistenceBroker2, fieldDescriptor, string);
                persistenceBroker2.commitTransaction();
                if (log.isDebugEnabled()) {
                    log.debug("new sequence was " + highLowSequence);
                }
            }
            catch (Exception exception) {
                log.error("Can't lookup new HighLowSequence for field " + (fieldDescriptor != null ? fieldDescriptor.getAttributeName() : null) + " using sequence name " + string, exception);
                if (persistenceBroker2 == null) throw new SequenceManagerException("Can't build new sequence", exception);
                if (!persistenceBroker2.isInTransaction()) throw new SequenceManagerException("Can't build new sequence", exception);
                persistenceBroker2.abortTransaction();
                throw new SequenceManagerException("Can't build new sequence", exception);
            }
            Object var8_6 = null;
            this.attempts = 0;
            if (persistenceBroker2 == null) return highLowSequence;
            persistenceBroker2.close();
            return highLowSequence;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.attempts = 0;
            if (persistenceBroker2 == null) throw throwable;
            persistenceBroker2.close();
            throw throwable;
        }
    }

    protected HighLowSequence lookupStoreSequence(PersistenceBroker persistenceBroker, FieldDescriptor fieldDescriptor, String string) {
        HighLowSequence highLowSequence = null;
        boolean bl = false;
        Criteria criteria = new Criteria();
        criteria.addEqualTo(PK_FIELD, string);
        QueryByCriteria queryByCriteria = new QueryByCriteria(class$org$apache$ojb$broker$util$sequence$HighLowSequence == null ? (class$org$apache$ojb$broker$util$sequence$HighLowSequence = SequenceManagerHighLowImpl.class$("org.apache.ojb.broker.util.sequence.HighLowSequence")) : class$org$apache$ojb$broker$util$sequence$HighLowSequence, criteria);
        highLowSequence = (HighLowSequence)persistenceBroker.getObjectByQuery(queryByCriteria);
        if (highLowSequence == null) {
            if (log.isDebugEnabled()) {
                log.debug("sequence for field " + fieldDescriptor + " not found in db, store new HighLowSequence");
            }
            long l = this.getMaxKeyForSequence(this.getBrokerForClass(), fieldDescriptor);
            highLowSequence = this.newSequenceObject(string, fieldDescriptor);
            highLowSequence.setMaxKey(l);
            bl = true;
        }
        highLowSequence.setGrabSize(this.grabSize);
        highLowSequence.grabNextKeySet();
        try {
            if (bl) {
                persistenceBroker.store(highLowSequence, ObjectModificationDefaultImpl.INSERT);
            } else {
                persistenceBroker.store(highLowSequence, ObjectModificationDefaultImpl.UPDATE);
            }
        }
        catch (OptimisticLockException optimisticLockException) {
            if (this.attempts < 5) {
                log.info("OptimisticLockException was thrown, will try again to store sequence. Sequence was " + highLowSequence);
                ++this.attempts;
                highLowSequence = this.lookupStoreSequence(persistenceBroker, fieldDescriptor, string);
            }
            throw optimisticLockException;
        }
        return highLowSequence;
    }

    protected HighLowSequence newSequenceObject(String string, FieldDescriptor fieldDescriptor) {
        HighLowSequence highLowSequence = new HighLowSequence();
        highLowSequence.setTableName(string);
        highLowSequence.setFieldName(DEPRECATED_COLUMN);
        highLowSequence.setGrabSize(this.grabSize);
        return highLowSequence;
    }

    protected long getMaxKeyForSequence(PersistenceBroker persistenceBroker, FieldDescriptor fieldDescriptor) {
        long l = 0L;
        l = this.useGlobalSequenceIdentities ? this.globalSequenceStart : SequenceManagerHelper.getMaxForExtent(persistenceBroker, fieldDescriptor);
        return l;
    }

    private String buildSequenceName(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        String string = null;
        string = this.useGlobalSequenceIdentities ? GLOBAL_SEQUENCE_NAME : this.calculateSequenceName(fieldDescriptor);
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

