/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo;

import java.util.Collection;
import java.util.Map;
import javax.jdo.Extent;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.apache.ojb.jdo.ExtentImpl;
import org.apache.ojb.jdo.PersistenceManagerImpl;
import org.apache.ojb.jdo.jdoql.Expression;
import org.apache.ojb.jdo.jdoql.LocalVariable;
import org.apache.ojb.jdo.jdoql.QueryParsingHelper;
import org.apache.ojb.jdo.jdoql.QueryTreeResolver;

public class QueryImpl
implements Query {
    private PersistenceManagerImpl _persistenceManager;
    private Class _searchedClass;
    private Collection _candidateInstances;
    private String _filterString;
    private Expression _filterExpression;
    private String _importString;
    private Collection _imports;
    private String _parameterString;
    private Map _parameters;
    private String _variableString;
    private Map _variables;
    private String _orderingString;
    private Collection _orderings;
    private boolean _ignoreCache;
    private boolean _needsCompilation = true;

    public QueryImpl(PersistenceManagerImpl persistenceManagerImpl) {
        this._persistenceManager = persistenceManagerImpl;
        this._candidateInstances = null;
    }

    public PersistenceManager getPersistenceManager() {
        return this._persistenceManager;
    }

    public void setClass(Class clazz) {
        this._searchedClass = clazz;
        this._needsCompilation = true;
    }

    public Class getSearchedClass() {
        return this._searchedClass;
    }

    public void setCandidates(Extent extent) {
        this._searchedClass = ((ExtentImpl)extent).ojbGetClass();
        this._needsCompilation = true;
    }

    public void setCandidates(Collection collection) {
        this._candidateInstances = collection;
        this._needsCompilation = true;
    }

    public void setFilter(String string) throws JDOUserException {
        this._filterString = string;
        this._filterExpression = new QueryParsingHelper().parseFilter(string);
        this._needsCompilation = true;
    }

    public Expression getFilterExpression() {
        return this._filterExpression;
    }

    public void declareImports(String string) throws JDOUserException {
        this._importString = string;
        this._imports = new QueryParsingHelper().parseImports(string);
        this._needsCompilation = true;
    }

    public Collection getImports() {
        return this._imports;
    }

    public void declareParameters(String string) throws JDOUserException {
        this._parameterString = string;
        this._parameters = new QueryParsingHelper().parseParameters(string);
        this._needsCompilation = true;
    }

    public Map getParameters() {
        return this._parameters;
    }

    public LocalVariable getParameter(String string) {
        return (LocalVariable)this._variables.get(string);
    }

    public void declareVariables(String string) throws JDOUserException {
        this._variableString = string;
        this._variables = new QueryParsingHelper().parseVariables(string);
        this._needsCompilation = true;
    }

    public Map getVariables() {
        return this._variables;
    }

    public LocalVariable getVariable(String string) {
        return (LocalVariable)this._variables.get(string);
    }

    public void setOrdering(String string) throws JDOUserException {
        this._orderingString = string;
        this._orderings = new QueryParsingHelper().parseOrderings(string);
        this._needsCompilation = true;
    }

    public Collection getOrderings() {
        return this._orderings;
    }

    public void setIgnoreCache(boolean bl) {
        this._ignoreCache = bl;
    }

    public boolean getIgnoreCache() {
        return this._ignoreCache;
    }

    public void compile() {
        if (this._needsCompilation) {
            new QueryTreeResolver().resolveAndCheck(this);
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    public Object execute() {
        if (this._needsCompilation) {
            this.compile();
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Object execute(Object object) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Object execute(Object object, Object object2) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Object execute(Object object, Object object2, Object object3) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Object executeWithMap(Map map) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Object executeWithArray(Object[] objectArray) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public void close(Object object) {
    }

    public void closeAll() {
    }

    QueryImpl ojbClone() {
        QueryImpl queryImpl = new QueryImpl(this._persistenceManager);
        queryImpl.setClass(this._searchedClass);
        queryImpl.setCandidates(this._candidateInstances);
        queryImpl.declareImports(this._importString);
        queryImpl.declareParameters(this._parameterString);
        queryImpl.declareVariables(this._variableString);
        queryImpl.setFilter(this._filterString);
        queryImpl.setOrdering(this._orderingString);
        return queryImpl;
    }
}

