/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.List;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.Configurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.DatabaseImpl;
import org.apache.ojb.odmg.OJBTxManager;
import org.apache.ojb.odmg.TransactionExt;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DCollectionFactory;
import org.apache.ojb.odmg.oql.EnhancedOQLQuery;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DArray;
import org.odmg.DBag;
import org.odmg.DList;
import org.odmg.DMap;
import org.odmg.DSet;
import org.odmg.Database;
import org.odmg.DatabaseClosedException;
import org.odmg.Implementation;
import org.odmg.ODMGRuntimeException;
import org.odmg.Transaction;

public class ImplementationImpl
implements Implementation {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$ImplementationImpl == null ? (class$org$apache$ojb$odmg$ImplementationImpl = ImplementationImpl.class$("org.apache.ojb.odmg.ImplementationImpl")) : class$org$apache$ojb$odmg$ImplementationImpl);
    private List usedDatabases = new ArrayList();
    private DatabaseImpl currentDatabase;
    private Configurator configurator;
    private OJBTxManager ojbTxManager = TxManagerFactory.instance();
    static /* synthetic */ Class class$org$apache$ojb$odmg$ImplementationImpl;

    protected ImplementationImpl() {
        this.setConfigurator(PersistenceBrokerFactory.getConfigurator());
    }

    protected synchronized void setCurrentDatabase(DatabaseImpl databaseImpl) {
        this.currentDatabase = databaseImpl;
    }

    public DatabaseImpl getCurrentDatabase() {
        return this.currentDatabase;
    }

    public PBKey getCurrentPBKey() {
        return this.currentDatabase.getPBKey();
    }

    public Configurator getConfigurator() {
        return this.configurator;
    }

    public void setConfigurator(Configurator configurator) {
        this.configurator = configurator;
    }

    public Transaction newTransaction() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, must have a DB in order to create a transaction");
        }
        TransactionImpl transactionImpl = new TransactionImpl(this.getCurrentDatabase());
        try {
            this.getConfigurator().configure(transactionImpl);
        }
        catch (ConfigurationException configurationException) {
            throw new ODMGRuntimeException("Error in configuration of TransactionImpl instance: " + configurationException.getMessage());
        }
        return transactionImpl;
    }

    public Transaction currentTransaction() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, must have a DB in order to create a transaction");
        }
        return this.ojbTxManager.getTransaction();
    }

    public boolean hasOpenTransaction() {
        TransactionImpl transactionImpl = this.ojbTxManager.getTransaction();
        return transactionImpl != null ? transactionImpl.isOpen() : false;
    }

    public Database newDatabase() {
        return new DatabaseImpl(this);
    }

    public EnhancedOQLQuery newOQLQuery() {
        if (this.getCurrentDatabase() == null || !this.getCurrentDatabase().isOpen()) {
            throw new DatabaseClosedException("Database is not open");
        }
        OQLQueryImpl oQLQueryImpl = new OQLQueryImpl(this.getCurrentPBKey());
        try {
            this.getConfigurator().configure(oQLQueryImpl);
        }
        catch (ConfigurationException configurationException) {
            throw new ODMGRuntimeException("Error in configuration of OQLQueryImpl instance: " + configurationException.getMessage());
        }
        return oQLQueryImpl;
    }

    public DList newDList() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DList with a null database.");
        }
        return DCollectionFactory.getInstance().createDList(this.getCurrentPBKey());
    }

    public DBag newDBag() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DBag with a null database.");
        }
        return DCollectionFactory.getInstance().createDBag(this.getCurrentPBKey());
    }

    public DSet newDSet() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DSet with a null database.");
        }
        return DCollectionFactory.getInstance().createDSet(this.getCurrentPBKey());
    }

    public DArray newDArray() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DArray with a null database.");
        }
        return DCollectionFactory.getInstance().createDArray(this.getCurrentPBKey());
    }

    public DMap newDMap() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DMap with a null database.");
        }
        return DCollectionFactory.getInstance().createDMap(this.getCurrentPBKey());
    }

    public String getObjectId(Object object) {
        Identity identity = null;
        PersistenceBroker persistenceBroker = this.getCurrentDatabase() != null ? PersistenceBrokerFactory.createPersistenceBroker(this.getCurrentDatabase().getPBKey()) : PersistenceBrokerFactory.defaultPersistenceBroker();
        identity = new Identity(object, persistenceBroker);
        return new String(identity.serialize());
    }

    public Database getDatabase(Object object) {
        return this.getCurrentDatabase();
    }

    protected synchronized void registerOpenDatabase(DatabaseImpl databaseImpl) {
        DatabaseImpl databaseImpl2 = this.getCurrentDatabase();
        if (databaseImpl2 != null) {
            try {
                if (databaseImpl2.isOpen()) {
                    this.log.warn("## There is still an opened database, close old one ##");
                    databaseImpl2.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Set current database " + databaseImpl + " PBKey was " + databaseImpl.getPBKey());
        }
        this.setCurrentDatabase(databaseImpl);
        this.usedDatabases.add(databaseImpl.getPBKey());
    }

    public void setImplicitLocking(boolean bl) {
        ((TransactionExt)this.currentTransaction()).setImplicitLocking(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

