/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.locking.AbstractLockStrategy;
import org.apache.ojb.odmg.locking.LockEntry;
import org.apache.ojb.odmg.locking.LockMap;
import org.apache.ojb.odmg.locking.LockStrategyFactory;
import org.apache.ojb.odmg.locking.ObjectLocks;

public class InMemoryLockMapImpl
implements LockMap {
    private HashMap locktable = new HashMap();
    private long m_lastCleanupAt = System.currentTimeMillis();
    private static long CLEANUP_FREQUENCY = 500L;
    private static int MAX_LOCKS_TO_CLEAN = 50;

    public LockEntry getWriter(Object object) {
        PersistenceBroker persistenceBroker = this.getBroker();
        Identity identity = new Identity(object, persistenceBroker);
        return this.getWriter(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockEntry getWriter(Identity identity) {
        this.checkTimedOutLocks();
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(identity.toString());
        }
        if (objectLocks == null) {
            return null;
        }
        return objectLocks.getWriter();
    }

    private PersistenceBroker getBroker() {
        return TxManagerFactory.instance().getCurrentTransaction().getBroker();
    }

    public Collection getReaders(Object object) {
        this.checkTimedOutLocks();
        Identity identity = new Identity(object, this.getBroker());
        return this.getReaders(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getReaders(Identity identity) {
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(identity.toString());
        }
        if (objectLocks == null) {
            return new Vector();
        }
        return objectLocks.getReaders().values();
    }

    public boolean addReader(TransactionImpl transactionImpl, Object object) {
        this.checkTimedOutLocks();
        Identity identity = new Identity(object, this.getBroker());
        LockEntry lockEntry = new LockEntry(identity.toString(), transactionImpl.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(object), LockEntry.LOCK_READ);
        this.addReaderInternal(lockEntry);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReaderInternal(LockEntry lockEntry) {
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            String string = lockEntry.getOidString();
            objectLocks = (ObjectLocks)this.locktable.get(string);
            if (objectLocks == null) {
                objectLocks = new ObjectLocks();
                this.locktable.put(string, objectLocks);
            }
        }
        objectLocks.addReader(lockEntry);
    }

    public void removeReader(TransactionImpl transactionImpl, Object object) {
        this.checkTimedOutLocks();
        Identity identity = new Identity(object, this.getBroker());
        String string = identity.toString();
        String string2 = transactionImpl.getGUID();
        this.removeReaderInternal(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReaderInternal(String string, String string2) {
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(string);
        }
        if (objectLocks == null) {
            return;
        }
        hashMap = this.locktable;
        synchronized (hashMap) {
            Hashtable hashtable = objectLocks.getReaders();
            hashtable.remove(string2);
            if (objectLocks.getWriter() == null && hashtable.size() == 0) {
                this.locktable.remove(string);
            }
        }
    }

    void removeReaderByLock(LockEntry lockEntry) {
        String string = lockEntry.getOidString();
        String string2 = lockEntry.getTransactionId();
        this.removeReaderInternal(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriter(LockEntry lockEntry) {
        this.checkTimedOutLocks();
        String string = lockEntry.getOidString();
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(string);
        }
        if (objectLocks == null) {
            return;
        }
        hashMap = this.locktable;
        synchronized (hashMap) {
            Hashtable hashtable = objectLocks.getReaders();
            objectLocks.setWriter(null);
            if (hashtable.size() == 0) {
                this.locktable.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upgradeLock(LockEntry lockEntry) {
        this.checkTimedOutLocks();
        String string = lockEntry.getOidString();
        ObjectLocks objectLocks = null;
        Serializable serializable = this.locktable;
        synchronized (serializable) {
            objectLocks = (ObjectLocks)this.locktable.get(string);
        }
        if (objectLocks == null) {
            return false;
        }
        serializable = new LockEntry(lockEntry.getOidString(), lockEntry.getTransactionId(), System.currentTimeMillis(), lockEntry.getIsolationLevel(), LockEntry.LOCK_WRITE);
        objectLocks.setWriter((LockEntry)serializable);
        objectLocks.getReaders().remove(lockEntry.getTransactionId());
        return true;
    }

    public boolean setWriter(TransactionImpl transactionImpl, Object object) {
        this.checkTimedOutLocks();
        Identity identity = new Identity(object, transactionImpl.getBroker());
        LockEntry lockEntry = new LockEntry(identity.toString(), transactionImpl.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(object), LockEntry.LOCK_WRITE);
        String string = identity.toString();
        this.setWriterInternal(lockEntry, string);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWriterInternal(LockEntry lockEntry, String string) {
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(string);
            if (objectLocks == null) {
                objectLocks = new ObjectLocks();
                this.locktable.put(string, objectLocks);
            }
        }
        objectLocks.setWriter(lockEntry);
    }

    void setWriterByLock(LockEntry lockEntry) {
        String string = lockEntry.getOidString();
        this.setWriterInternal(lockEntry, string);
    }

    public boolean hasReadLock(TransactionImpl transactionImpl, Object object) {
        this.checkTimedOutLocks();
        Identity identity = new Identity(object, this.getBroker());
        String string = identity.toString();
        String string2 = transactionImpl.getGUID();
        return this.hasReadLockInternal(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasReadLockInternal(String string, String string2) {
        ObjectLocks objectLocks = null;
        Serializable serializable = this.locktable;
        synchronized (serializable) {
            objectLocks = (ObjectLocks)this.locktable.get(string);
        }
        if (objectLocks == null) {
            return false;
        }
        serializable = objectLocks.getReader(string2);
        return serializable != null;
    }

    boolean hasReadLock(LockEntry lockEntry) {
        String string = lockEntry.getOidString();
        String string2 = lockEntry.getTransactionId();
        return this.hasReadLockInternal(string, string2);
    }

    private void checkTimedOutLocks() {
        if (System.currentTimeMillis() - this.m_lastCleanupAt > CLEANUP_FREQUENCY) {
            this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
            this.m_lastCleanupAt = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTimedOutLocks(long l) {
        long l2 = System.currentTimeMillis() - l;
        boolean bl = false;
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            Iterator iterator = this.locktable.values().iterator();
            for (int i = 0; iterator.hasNext() && !bl && i <= MAX_LOCKS_TO_CLEAN; ++i) {
                objectLocks = (ObjectLocks)iterator.next();
                if (objectLocks.getWriter() != null && objectLocks.getWriter().getTimestamp() < l2) {
                    objectLocks.setWriter(null);
                }
                if (objectLocks.getYoungestReader() < l2) {
                    objectLocks.getReaders().clear();
                    if (objectLocks.getWriter() != null) continue;
                    iterator.remove();
                    continue;
                }
                Iterator iterator2 = objectLocks.getReaders().values().iterator();
                LockEntry lockEntry = null;
                while (iterator2.hasNext()) {
                    lockEntry = (LockEntry)iterator2.next();
                    if (lockEntry.getTimestamp() >= l2) continue;
                    iterator2.remove();
                }
            }
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
    }

    int getSize() {
        return this.locktable.size();
    }
}

