/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.LocaleUtility;
import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.RawCollationKey;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;

public abstract class Collator
implements Comparator,
Cloneable {
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int QUATERNARY = 3;
    public static final int IDENTICAL = 15;
    public static final int NO_DECOMPOSITION = 16;
    public static final int CANONICAL_DECOMPOSITION = 17;
    private static ServiceShim shim;
    private int m_strength_ = 2;
    private int m_decomposition_ = 17;
    private ULocale validLocale;
    private ULocale actualLocale;

    public void setStrength(int newStrength) {
        if (newStrength != 0 && newStrength != 1 && newStrength != 2 && newStrength != 3 && newStrength != 15) {
            throw new IllegalArgumentException("Incorrect comparison level.");
        }
        this.m_strength_ = newStrength;
    }

    public void setDecomposition(int decomposition) {
        if (decomposition != 16 && decomposition != 17) {
            throw new IllegalArgumentException("Wrong decomposition mode.");
        }
        this.m_decomposition_ = decomposition;
    }

    public static final Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static ServiceShim getShim() {
        if (shim == null) {
            try {
                Class<?> cls = Class.forName("com.ibm.icu.text.CollatorServiceShim");
                shim = (ServiceShim)cls.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        return shim;
    }

    public static final Collator getInstance(Locale locale) {
        Collator coll = null;
        coll = shim == null ? new RuleBasedCollator(locale) : shim.getInstance(locale);
        return coll;
    }

    public static final Object registerInstance(Collator collator, Locale locale) {
        return Collator.getShim().registerInstance(collator, locale);
    }

    public static final Object registerFactory(CollatorFactory factory) {
        return Collator.getShim().registerFactory(factory);
    }

    public static final boolean unregister(Object registryKey) {
        if (shim == null) {
            return false;
        }
        return shim.unregister(registryKey);
    }

    public static Locale[] getAvailableLocales() {
        if (shim == null) {
            return ICULocaleData.getAvailableLocales();
        }
        return shim.getAvailableLocales();
    }

    public static String getDisplayName(Locale objectLocale, Locale displayLocale) {
        return Collator.getShim().getDisplayName(objectLocale, displayLocale);
    }

    public static String getDisplayName(Locale objectLocale) {
        return Collator.getShim().getDisplayName(objectLocale, Locale.getDefault());
    }

    public int getStrength() {
        return this.m_strength_;
    }

    public int getDecomposition() {
        return this.m_decomposition_;
    }

    public int compare(Object source, Object target) {
        if (!(source instanceof String) || !(target instanceof String)) {
            throw new IllegalArgumentException("Arguments have to be of type String");
        }
        return this.compare((String)source, (String)target);
    }

    public boolean equals(String source, String target) {
        return this.compare(source, target) == 0;
    }

    public UnicodeSet getTailoredSet() {
        return new UnicodeSet(0, 0x10FFFF);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract int compare(String var1, String var2);

    public abstract CollationKey getCollationKey(String var1);

    public abstract RawCollationKey getRawCollationKey(String var1, RawCollationKey var2);

    public abstract int setVariableTop(String var1);

    public abstract int getVariableTop();

    public abstract void setVariableTop(int var1);

    public abstract VersionInfo getVersion();

    public abstract VersionInfo getUCAVersion();

    protected Collator() {
    }

    public final ULocale getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    final void setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }

    static abstract class ServiceShim {
        ServiceShim() {
        }

        abstract Collator getInstance(Locale var1);

        abstract Object registerInstance(Collator var1, Locale var2);

        abstract Object registerFactory(CollatorFactory var1);

        abstract boolean unregister(Object var1);

        abstract Locale[] getAvailableLocales();

        abstract String getDisplayName(Locale var1, Locale var2);
    }

    public static abstract class CollatorFactory {
        public boolean visible() {
            return true;
        }

        public abstract Collator createCollator(Locale var1);

        public String getDisplayName(Locale objectLocale, Locale displayLocale) {
            String name;
            Set supported;
            if (this.visible() && (supported = this.getSupportedLocaleIDs()).contains(name = LocaleUtility.canonicalLocaleString(objectLocale.toString()))) {
                return objectLocale.getDisplayName(displayLocale);
            }
            return null;
        }

        public abstract Set getSupportedLocaleIDs();

        protected CollatorFactory() {
        }
    }
}

