/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.NumberFormatServiceShim;
import com.ibm.icu.util.ULocale;
import java.util.Locale;
import java.util.Set;

class NumberFormatServiceShim
extends NumberFormat.NumberFormatShim {
    private static ICULocaleService service = new NFService();

    NumberFormatServiceShim() {
    }

    Locale[] getAvailableLocales() {
        if (service.isDefault()) {
            return ICULocaleData.getAvailableLocales();
        }
        return service.getAvailableLocales();
    }

    Object registerFactory(NumberFormat.NumberFormatFactory factory) {
        return service.registerFactory(new NFFactory(factory));
    }

    boolean unregister(Object registryKey) {
        return service.unregisterFactory((ICUService.Factory)registryKey);
    }

    NumberFormat createInstance(Locale desiredLocale, int choice) {
        if (service.isDefault()) {
            return NumberFormat.createInstance(desiredLocale, choice);
        }
        Locale[] actualLoc = new Locale[1];
        NumberFormat fmt = (NumberFormat)service.get(desiredLocale, choice, actualLoc);
        ULocale uloc = new ULocale(actualLoc[0]);
        fmt.setLocale(uloc, uloc);
        return fmt;
    }

    private static class NFService
    extends ICULocaleService {
        NFService() {
            super("NumberFormat");
            class RBNumberFormatFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                private final /* synthetic */ NFService this$0;

                RBNumberFormatFactory(NFService this$0) {
                    this.this$0 = this$0;
                }

                protected Object handleCreate(Locale loc, int kind, ICUService service) {
                    return NumberFormat.createInstance(loc, kind);
                }
            }
            this.registerFactory(new RBNumberFormatFactory(this));
            this.markDefault();
        }
    }

    private static final class NFFactory
    extends ICULocaleService.LocaleKeyFactory {
        private NumberFormat.NumberFormatFactory delegate;

        NFFactory(NumberFormat.NumberFormatFactory delegate) {
            super(delegate.visible() ? 0 : 1);
            this.delegate = delegate;
        }

        public Object create(ICUService.Key key, ICUService service) {
            if (this.handlesKey(key)) {
                int kind;
                ICULocaleService.LocaleKey lkey = (ICULocaleService.LocaleKey)key;
                Locale loc = lkey.canonicalLocale();
                Object result = this.delegate.createFormat(loc, kind = lkey.kind());
                if (result == null) {
                    result = service.getKey(key, null, this);
                }
                return result;
            }
            return null;
        }

        protected Set getSupportedIDs() {
            return this.delegate.getSupportedLocaleNames();
        }
    }
}

