/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webservices.instrument;

import java.util.ArrayList;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.webservices.instrument.InstrumentationService;
import org.apache.excalibur.instrument.InstrumentManager;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentableDescriptorLocal;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentSampleDescriptor;

public final class InstrumentationServiceImpl
extends AbstractLogEnabled
implements InstrumentationService {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private DefaultInstrumentManager m_iManager;

    public void setInstrumentManager(InstrumentManager iManager) {
        if (iManager == null && this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("No instrument manager available,please enable instrumentation in your web.xml");
        }
        if (!(iManager instanceof DefaultInstrumentManager)) {
            throw new UnsupportedOperationException("InstrumentationService only supports DefaultInstrumentManager");
        }
        this.m_iManager = (DefaultInstrumentManager)iManager;
    }

    public int[] getSampleSnapshot(String path) throws Exception {
        if (!this.haveInstrumentManager()) {
            this.getLogger().warn("No instrument manager available,please enable instrumentation in your web.xml");
            return EMPTY_INT_ARRAY;
        }
        return this.m_iManager.locateInstrumentSampleDescriptor(path).getSnapshot().getSamples();
    }

    public String[] getSampleNames() {
        if (!this.haveInstrumentManager()) {
            this.getLogger().warn("No instrument manager available,please enable instrumentation in your web.xml");
            return EMPTY_STRING_ARRAY;
        }
        InstrumentableDescriptorLocal[] descriptors = this.m_iManager.getInstrumentableDescriptors();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < descriptors.length; ++i) {
            InstrumentDescriptor[] insts = descriptors[i].getInstrumentDescriptors();
            for (int k = 0; k < insts.length; ++k) {
                InstrumentSampleDescriptor[] samples = insts[k].getInstrumentSampleDescriptors();
                for (int j = 0; j < samples.length; ++j) {
                    names.add(samples[j].getName());
                }
            }
        }
        return names.toArray(new String[0]);
    }

    private boolean haveInstrumentManager() {
        return this.m_iManager != null;
    }
}

