/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server;

import java.util.ArrayList;
import org.apache.altrmi.server.PublicationDescriptionItem;
import org.apache.altrmi.server.PublicationException;

public final class PublicationDescription {
    private ArrayList m_interfacesToExpose = new ArrayList();
    private ArrayList m_additionalFacades = new ArrayList();

    public PublicationDescription(Class interfaceToExpose) {
        this(new Class[]{interfaceToExpose}, new Class[0]);
    }

    public PublicationDescription(Class interfaceToExpose, Class additionalFacade) {
        this(new Class[]{interfaceToExpose}, new Class[]{additionalFacade});
    }

    public PublicationDescription(Class interfaceToExpose, Class[] additionalFacades) {
        this(new Class[]{interfaceToExpose}, additionalFacades);
    }

    public PublicationDescription(Class[] interfacesToExpose) {
        this(interfacesToExpose, new Class[0]);
    }

    public PublicationDescription(Class[] interfacesToExpose, Class[] additionalFacades) {
        this.addInterfacesToExpose(interfacesToExpose);
        this.addAdditionalFacadesToExpose(additionalFacades);
    }

    public PublicationDescription(String interfaceToExpose, ClassLoader classLoader) throws PublicationException {
        this(PublicationDescription.makeClasses(new String[]{interfaceToExpose}, classLoader), new Class[0]);
    }

    public PublicationDescription(String interfaceToExpose, String additionalFacade, ClassLoader classLoader) throws PublicationException {
        this(PublicationDescription.makeClasses(new String[]{interfaceToExpose}, classLoader), PublicationDescription.makeClasses(new String[]{additionalFacade}, classLoader));
    }

    public PublicationDescription(String interfaceToExpose, String[] additionalFacades, ClassLoader classLoader) throws PublicationException {
        this(PublicationDescription.makeClasses(new String[]{interfaceToExpose}, classLoader), PublicationDescription.makeClasses(additionalFacades, classLoader));
    }

    public PublicationDescription(String[] interfacesToExpose, ClassLoader classLoader) throws PublicationException {
        this(PublicationDescription.makeClasses(interfacesToExpose, classLoader), new Class[0]);
    }

    public PublicationDescription(String[] interfacesToExpose, String[] additionalFacades, ClassLoader classLoader) throws PublicationException {
        this(PublicationDescription.makeClasses(interfacesToExpose, classLoader), PublicationDescription.makeClasses(additionalFacades, classLoader));
    }

    public PublicationDescription() {
    }

    private static Class[] makeClasses(String[] classNames, ClassLoader classLoader) throws PublicationException {
        try {
            Class[] classes = new Class[classNames.length];
            int i = 0;
            while (i < classNames.length) {
                String clsNam = classNames[i];
                classes[i] = classLoader.loadClass(clsNam);
                ++i;
            }
            return classes;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new PublicationException("Class not found during publication:" + e.getMessage() + " " + e.getException().getMessage());
        }
    }

    public void addInterfacesToExpose(Class[] interfacesToExpose) {
        int i = 0;
        while (i < interfacesToExpose.length) {
            Class interfaceToExpose = interfacesToExpose[i];
            this.addInterfaceToExpose(new PublicationDescriptionItem(interfaceToExpose));
            ++i;
        }
    }

    public void addInterfaceToExpose(PublicationDescriptionItem publicationDescriptionItem) {
        this.addInterfacesToExpose(new PublicationDescriptionItem[]{publicationDescriptionItem});
    }

    public void addInterfacesToExpose(PublicationDescriptionItem[] publicationDescriptionItems) {
        int i = 0;
        while (i < publicationDescriptionItems.length) {
            PublicationDescriptionItem publicationDescriptionItem = publicationDescriptionItems[i];
            if (publicationDescriptionItem == null) {
                throw new RuntimeException("'PubDescItem' cannot be null");
            }
            if (publicationDescriptionItem.getFacadeClass() == null) {
                throw new RuntimeException("'Class' cannot be null");
            }
            this.m_interfacesToExpose.add(publicationDescriptionItem);
            ++i;
        }
    }

    public void addAdditionalFacadesToExpose(Class[] additionalFacades) {
        int i = 0;
        while (i < additionalFacades.length) {
            Class additionalFacade = additionalFacades[i];
            this.addAdditionalFacadeToExpose(new PublicationDescriptionItem(additionalFacade));
            ++i;
        }
    }

    public void addAdditionalFacadeToExpose(PublicationDescriptionItem publicationDescriptionItem) {
        this.addAdditionalFacadesToExpose(new PublicationDescriptionItem[]{publicationDescriptionItem});
    }

    public void addAdditionalFacadesToExpose(PublicationDescriptionItem[] publicationDescriptionItems) {
        int i = 0;
        while (i < publicationDescriptionItems.length) {
            PublicationDescriptionItem publicationDescriptionItem = publicationDescriptionItems[i];
            if (publicationDescriptionItem == null) {
                throw new RuntimeException("'PubDescItem' cannot be null");
            }
            if (publicationDescriptionItem.getFacadeClass() == null) {
                throw new RuntimeException("'Class' cannot be null");
            }
            this.m_additionalFacades.add(publicationDescriptionItem);
            ++i;
        }
    }

    public PublicationDescriptionItem[] getInterfacesToExpose() {
        PublicationDescriptionItem[] items = new PublicationDescriptionItem[this.m_interfacesToExpose.size()];
        this.m_interfacesToExpose.toArray(items);
        return items;
    }

    public PublicationDescriptionItem[] getAdditionalFacades() {
        PublicationDescriptionItem[] items = new PublicationDescriptionItem[this.m_additionalFacades.size()];
        this.m_additionalFacades.toArray(items);
        return items;
    }

    public Class getMostDerivedType(Object beanImpl) {
        Class facadeRetVal = null;
        int i = 0;
        while (i < this.m_additionalFacades.size()) {
            Class facadeClass = ((PublicationDescriptionItem)this.m_additionalFacades.get(i)).getFacadeClass();
            if (facadeClass.isAssignableFrom(beanImpl.getClass())) {
                if (facadeRetVal == null) {
                    facadeRetVal = facadeClass;
                } else if (facadeRetVal.isAssignableFrom(facadeClass)) {
                    facadeRetVal = facadeClass;
                }
            }
            ++i;
        }
        return facadeRetVal;
    }
}

