/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.helpers;

import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SourceProperty
implements XMLizable {
    private static final String URI = "http://www.w3.org/2000/xmlns/";
    private static final String NS_PREFIX = "property";
    private static final String D_PREFIX = "property:";
    private String namespace;
    private String name;
    private Element value;

    public SourceProperty(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
        try {
            DOMBuilder builder = new DOMBuilder();
            builder.startDocument();
            builder.startPrefixMapping(NS_PREFIX, namespace);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(URI, NS_PREFIX, "xmlns:property", "NMTOKEN", namespace);
            builder.startElement(namespace, name, D_PREFIX + name, (Attributes)attrs);
            builder.endElement(namespace, name, D_PREFIX + name);
            builder.endPrefixMapping(NS_PREFIX);
            Document doc = builder.getDocument();
            this.value = doc.getDocumentElement();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public SourceProperty(String namespace, String name, String value) {
        this.namespace = namespace;
        this.name = name;
        this.setValue(value);
    }

    public SourceProperty(Element property) {
        this.namespace = property.getNamespaceURI();
        this.name = property.getLocalName();
        this.value = property;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String value) {
        try {
            DOMBuilder builder = new DOMBuilder();
            builder.startDocument();
            builder.startPrefixMapping(NS_PREFIX, this.namespace);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(URI, NS_PREFIX, "xmlns:property", "NMTOKEN", this.namespace);
            builder.startElement(this.namespace, this.name, D_PREFIX + this.name, (Attributes)attrs);
            builder.characters(value.toCharArray(), 0, value.length());
            builder.endElement(this.namespace, this.name, D_PREFIX + this.name);
            builder.endPrefixMapping(NS_PREFIX);
            builder.endDocument();
            Document doc = builder.getDocument();
            this.value = doc.getDocumentElement();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public String getValueAsString() {
        NodeList nodeslist = this.value.getChildNodes();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < nodeslist.getLength(); ++i) {
            if (nodeslist.item(i).getNodeType() != 3 && nodeslist.item(i).getNodeType() != 4) continue;
            buffer.append(nodeslist.item(i).getNodeValue());
        }
        return buffer.toString();
    }

    public void setValue(NodeList values) {
        try {
            DOMBuilder builder = new DOMBuilder();
            builder.startDocument();
            builder.startElement(this.namespace, this.name, this.name, (Attributes)new AttributesImpl());
            DOMStreamer stream = new DOMStreamer((XMLConsumer)builder);
            for (int i = 0; i < values.getLength(); ++i) {
                stream.stream(values.item(i));
            }
            builder.endElement(this.namespace, this.name, this.name);
            builder.endDocument();
            Document doc = builder.getDocument();
            this.value = doc.getDocumentElement();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public Element getValue() {
        return this.value;
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        DOMStreamer stream = new DOMStreamer(handler);
        stream.stream((Node)this.value);
    }
}

