/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.impl.AbstractImageSourceInspector;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;

public class JPEGSourceInspector
extends AbstractImageSourceInspector
implements ThreadSafe {
    protected final boolean isImageMimeType(Source source) {
        String uri = source.getURI();
        int index = uri.lastIndexOf(46);
        if (index != -1) {
            String extension = uri.substring(index);
            return extension.equalsIgnoreCase(".jpg") || extension.equalsIgnoreCase(".JPEG");
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isImageFileType(Source source) throws SourceException {
        BufferedInputStream in;
        block11: {
            byte[] buf;
            block10: {
                in = null;
                in = new BufferedInputStream(source.getInputStream());
                buf = new byte[2];
                int count = in.read(buf, 0, 2);
                if (count >= 2) break block10;
                boolean bl = false;
                Object var7_8 = null;
                if (in == null) return bl;
                try {
                    in.close();
                    return bl;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return bl;
            }
            if (buf[0] != -1 || buf[1] != -40) break block11;
            boolean bl = true;
            Object var7_9 = null;
            if (in == null) return bl;
            try {
                in.close();
                return bl;
            }
            catch (Exception e) {
                // empty catch block
            }
            return bl;
        }
        try {
            Object var7_10 = null;
            if (in == null) return false;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return false;
        }
        catch (Exception e) {}
        return false;
        {
            catch (IOException ioe) {
                throw new SourceException("Could not read source", (Throwable)ioe);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final int[] getImageSize(Source source) throws SourceException {
        BufferedInputStream in = null;
        try {
            int[] nArray;
            try {
                int[] dim;
                in = new BufferedInputStream(source.getInputStream());
                byte[] buf = new byte[2];
                int count = in.read(buf, 0, 2);
                if (count < 2) {
                    throw new SourceException("Not a valid Jpeg file!");
                }
                if (buf[0] != -1) throw new SourceException("Not a valid Jpeg file!");
                if (buf[1] != -40) {
                    throw new SourceException("Not a valid Jpeg file!");
                }
                int width = 0;
                int height = 0;
                boolean done = false;
                int ch = 0;
                try {
                    while (ch != 218 && !done) {
                        while (ch != 255) {
                            ch = in.read();
                        }
                        while (ch == 255) {
                            ch = in.read();
                        }
                        if (ch >= 192 && ch <= 195) {
                            in.read();
                            in.read();
                            in.read();
                            height = 256 * in.read();
                            height += in.read();
                            width = 256 * in.read();
                            width += in.read();
                            done = true;
                            continue;
                        }
                        int length = 256 * in.read();
                        if ((length += in.read()) < 2) {
                            throw new RuntimeException("Erroneous JPEG marker length");
                        }
                        for (int foo = 0; foo < length - 2; ++foo) {
                            in.read();
                        }
                    }
                }
                catch (Exception e) {
                    throw new SourceException("Not a valid Jpeg file!", (Throwable)e);
                }
                nArray = dim = new int[]{width, height};
                Object var12_15 = null;
                if (in == null) return nArray;
            }
            catch (IOException ioe) {
                throw new SourceException("Could not read source", (Throwable)ioe);
            }
            try {
                in.close();
                return nArray;
            }
            catch (Exception e) {
                // empty catch block
            }
            return nArray;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (in == null) throw throwable;
            try {}
            catch (Exception e) {
                throw throwable;
            }
            in.close();
            throw throwable;
        }
    }
}

