/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.SourceDescriptor;
import org.apache.cocoon.components.source.impl.RepositorySource;
import org.apache.excalibur.source.ModifiableTraversableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceResolver;

public class RepositorySourceFactory
extends AbstractLogEnabled
implements SourceFactory,
Serviceable,
Configurable,
ThreadSafe {
    private ServiceManager m_manager;
    private SourceResolver m_resolver;
    private SourceDescriptor m_descriptor;
    private String m_name;
    private boolean m_isInitialized;

    private synchronized void lazyInitialize() throws IOException {
        if (this.m_isInitialized) {
            return;
        }
        if (this.m_resolver == null) {
            try {
                this.m_resolver = (SourceResolver)this.m_manager.lookup(SourceResolver.ROLE);
            }
            catch (ServiceException e) {
                throw new IOException("Resolver service is not available: " + e.toString());
            }
        }
        if (this.m_manager.hasService(SourceDescriptor.ROLE)) {
            try {
                this.m_descriptor = (SourceDescriptor)this.m_manager.lookup(SourceDescriptor.ROLE);
            }
            catch (ServiceException e) {}
        } else {
            this.m_descriptor = null;
            if (this.getLogger().isInfoEnabled()) {
                String message = "SourceDescriptor is not available. RepositorySource will not support source properties.";
                this.getLogger().info("SourceDescriptor is not available. RepositorySource will not support source properties.");
            }
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_name = configuration.getAttribute("name");
    }

    public void service(ServiceManager manager) {
        this.m_manager = manager;
    }

    public Source getSource(String location, Map parameters) throws IOException, MalformedURLException {
        Source source;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating RepositorySource for " + location);
        }
        if (!this.m_isInitialized) {
            this.lazyInitialize();
        }
        if (!((source = this.m_resolver.resolveURI(location = location.substring(this.m_name.length() + 1))) instanceof ModifiableTraversableSource)) {
            String message = "Delegate should be a ModifiableTraversableSource";
            throw new SourceException("Delegate should be a ModifiableTraversableSource");
        }
        return new RepositorySource(this.m_name, (ModifiableTraversableSource)source, this.m_descriptor, this.getLogger());
    }

    public void release(Source source) {
        if (source instanceof RepositorySource) {
            this.m_resolver.release((Source)((RepositorySource)source).m_delegate);
        }
    }
}

