/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.source.impl.MultiSourceValidity;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.TraversableSource;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TraversableGenerator
extends ServiceableGenerator
implements CacheableProcessingComponent {
    protected static final String URI = "http://apache.org/cocoon/collection/1.0";
    protected static final String PREFIX = "collection";
    protected static final String COL_NODE_NAME = "collection";
    protected static final String RESOURCE_NODE_NAME = "resource";
    protected static final String RES_NAME_ATTR_NAME = "name";
    protected static final String URI_ATTR_NAME = "uri";
    protected static final String LASTMOD_ATTR_NAME = "lastModified";
    protected static final String DATE_ATTR_NAME = "date";
    protected static final String SIZE_ATTR_NAME = "size";
    protected MultiSourceValidity validity;
    protected AttributesImpl attributes;
    protected List cacheKeyParList;
    protected int depth;
    protected SimpleDateFormat dateFormatter;
    protected long refreshDelay;
    protected String sort;
    protected boolean reverse;
    protected RE rootRE;
    protected RE includeRE;
    protected RE excludeRE;
    protected boolean isRequestedSource;

    public void setup(org.apache.cocoon.environment.SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        String locale;
        if (src == null) {
            throw new ProcessingException("No src attribute pointing to a traversable source to be XMLized specified.");
        }
        super.setup(resolver, objectModel, src, par);
        this.cacheKeyParList = new ArrayList();
        this.cacheKeyParList.add(src);
        this.depth = par.getParameterAsInteger("depth", 1);
        this.cacheKeyParList.add(String.valueOf(this.depth));
        String dateFormatString = par.getParameter("dateFormat", null);
        this.cacheKeyParList.add(dateFormatString);
        this.dateFormatter = dateFormatString != null ? ((locale = par.getParameter("locale", null)) != null ? new SimpleDateFormat(dateFormatString, new Locale(locale, "")) : new SimpleDateFormat(dateFormatString)) : new SimpleDateFormat();
        String timeZone = par.getParameter("timeZone", null);
        if (timeZone != null) {
            this.dateFormatter.setTimeZone(TimeZone.getTimeZone(timeZone));
        }
        this.sort = par.getParameter("sort", RES_NAME_ATTR_NAME);
        this.cacheKeyParList.add(this.sort);
        this.reverse = par.getParameterAsBoolean("reverse", false);
        this.cacheKeyParList.add(String.valueOf(this.reverse));
        this.refreshDelay = par.getParameterAsLong("refreshDelay", 1L) * 1000L;
        this.cacheKeyParList.add(String.valueOf(this.refreshDelay));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("depth: " + this.depth);
            this.getLogger().debug("dateFormat: " + this.dateFormatter.toPattern());
            this.getLogger().debug("timeZone: " + timeZone);
            this.getLogger().debug("sort: " + this.sort);
            this.getLogger().debug("reverse: " + this.reverse);
            this.getLogger().debug("refreshDelay: " + this.refreshDelay);
        }
        String rePattern = null;
        try {
            rePattern = par.getParameter("root", null);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("root pattern: " + rePattern);
            }
            this.cacheKeyParList.add(rePattern);
            this.rootRE = rePattern == null ? null : new RE(rePattern);
            rePattern = par.getParameter("include", null);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("include pattern: " + rePattern);
            }
            this.cacheKeyParList.add(rePattern);
            this.includeRE = rePattern == null ? null : new RE(rePattern);
            rePattern = par.getParameter("exclude", null);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("exclude pattern: " + rePattern);
            }
            this.cacheKeyParList.add(rePattern);
            this.excludeRE = rePattern == null ? null : new RE(rePattern);
        }
        catch (RESyntaxException rese) {
            throw new ProcessingException("Syntax error in regexp pattern '" + rePattern + "'", (Throwable)rese);
        }
        this.isRequestedSource = false;
        this.attributes = new AttributesImpl();
    }

    public Serializable getKey() {
        StringBuffer buffer = new StringBuffer();
        int len = this.cacheKeyParList.size();
        for (int i = 0; i < len; ++i) {
            buffer.append((String)this.cacheKeyParList.get(i) + ":");
        }
        return buffer.toString();
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            this.validity = new MultiSourceValidity((SourceResolver)this.resolver, this.refreshDelay);
        }
        return this.validity;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws SAXException, ProcessingException {
        Vector ancestors;
        block13: {
            Source src = null;
            ancestors = null;
            try {
                try {
                    src = this.resolver.resolveURI(this.source);
                    if (!(src instanceof TraversableSource)) {
                        throw new SourceException(this.source + " is not a traversable source");
                    }
                    TraversableSource inputSource = (TraversableSource)this.resolver.resolveURI(this.source);
                    if (!inputSource.exists()) {
                        throw new ResourceNotFoundException(this.source + " does not exist.");
                    }
                    this.contentHandler.startDocument();
                    this.contentHandler.startPrefixMapping("collection", URI);
                    ancestors = this.getAncestors(inputSource);
                    this.addAncestorPath(inputSource, (Stack)ancestors);
                    this.contentHandler.endPrefixMapping("collection");
                    this.contentHandler.endDocument();
                    if (this.validity != null) {
                        this.validity.close();
                    }
                }
                catch (SourceException se) {
                    throw SourceUtil.handle((SourceException)se);
                }
                catch (IOException ioe) {
                    throw new ResourceNotFoundException("Could not read collection " + this.source, (Throwable)ioe);
                }
                Object var5_6 = null;
                if (src == null) break block13;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (src != null) {
                    this.resolver.release(src);
                }
                if (ancestors != null) {
                    Enumeration enumeration = ancestors.elements();
                    while (enumeration.hasMoreElements()) {
                        this.resolver.release((Source)enumeration.nextElement());
                    }
                }
                throw throwable;
            }
            this.resolver.release(src);
        }
        if (ancestors != null) {
            Enumeration enumeration = ancestors.elements();
            while (enumeration.hasMoreElements()) {
                this.resolver.release((Source)enumeration.nextElement());
            }
        }
    }

    protected Stack getAncestors(TraversableSource source) throws IOException {
        TraversableSource parent = source;
        Stack<TraversableSource> ancestors = new Stack<TraversableSource>();
        while (parent != null && !this.isRoot(parent)) {
            if ((parent = (TraversableSource)parent.getParent()) != null) {
                ancestors.push(parent);
                continue;
            }
            ancestors.clear();
        }
        return ancestors;
    }

    protected void addAncestorPath(TraversableSource source, Stack ancestors) throws SAXException, ProcessingException {
        if (ancestors.empty()) {
            this.isRequestedSource = true;
            this.addPath(source, this.depth);
        } else {
            this.startNode("collection", (TraversableSource)ancestors.pop());
            this.addAncestorPath(source, ancestors);
            this.endNode("collection");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addPath(TraversableSource source, int depth) throws SAXException, ProcessingException {
        block16: {
            if (!source.isCollection()) {
                if (!this.isIncluded(source)) return;
                if (this.isExcluded(source)) return;
                this.startNode(RESOURCE_NODE_NAME, source);
                this.addContent(source);
                this.endNode(RESOURCE_NODE_NAME);
                return;
            }
            this.startNode("collection", source);
            this.addContent(source);
            if (depth > 0) {
                Iterator iter2222;
                Collection contents = null;
                try {
                    try {
                        contents = source.getChildren();
                        if (this.sort.equals(RES_NAME_ATTR_NAME)) {
                            Arrays.sort(contents.toArray(), new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    if (TraversableGenerator.this.reverse) {
                                        return ((TraversableSource)o2).getName().compareTo(((TraversableSource)o1).getName());
                                    }
                                    return ((TraversableSource)o1).getName().compareTo(((TraversableSource)o2).getName());
                                }
                            });
                        } else if (this.sort.equals(SIZE_ATTR_NAME)) {
                            Arrays.sort(contents.toArray(), new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    if (TraversableGenerator.this.reverse) {
                                        return new Long(((TraversableSource)o2).getContentLength()).compareTo(new Long(((TraversableSource)o1).getContentLength()));
                                    }
                                    return new Long(((TraversableSource)o1).getContentLength()).compareTo(new Long(((TraversableSource)o2).getContentLength()));
                                }
                            });
                        } else if (this.sort.equals("lastmodified")) {
                            Arrays.sort(contents.toArray(), new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    if (TraversableGenerator.this.reverse) {
                                        return new Long(((TraversableSource)o2).getLastModified()).compareTo(new Long(((TraversableSource)o1).getLastModified()));
                                    }
                                    return new Long(((TraversableSource)o1).getLastModified()).compareTo(new Long(((TraversableSource)o2).getLastModified()));
                                }
                            });
                        } else if (this.sort.equals("collection")) {
                            Arrays.sort(contents.toArray(), new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    TraversableSource ts1 = (TraversableSource)o1;
                                    TraversableSource ts2 = (TraversableSource)o2;
                                    if (TraversableGenerator.this.reverse) {
                                        if (ts2.isCollection() && !ts1.isCollection()) {
                                            return -1;
                                        }
                                        if (!ts2.isCollection() && ts1.isCollection()) {
                                            return 1;
                                        }
                                        return ts2.getName().compareTo(ts1.getName());
                                    }
                                    if (ts2.isCollection() && !ts1.isCollection()) {
                                        return 1;
                                    }
                                    if (!ts2.isCollection() && ts1.isCollection()) {
                                        return -1;
                                    }
                                    return ts1.getName().compareTo(ts2.getName());
                                }
                            });
                        }
                        for (int i = 0; i < contents.size(); ++i) {
                            if (!this.isIncluded((TraversableSource)contents.toArray()[i]) || this.isExcluded((TraversableSource)contents.toArray()[i])) continue;
                            this.addPath((TraversableSource)contents.toArray()[i], depth - 1);
                        }
                        Object var6_6 = null;
                        if (contents == null) break block16;
                        iter2222 = contents.iterator();
                    }
                    catch (SourceException e) {
                        throw new ProcessingException("Error adding paths", (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (contents == null) throw throwable;
                    Iterator iter2222 = contents.iterator();
                    while (iter2222.hasNext()) {
                        this.resolver.release((Source)iter2222.next());
                    }
                    throw throwable;
                }
                while (iter2222.hasNext()) {
                    this.resolver.release((Source)iter2222.next());
                }
            }
        }
        this.endNode("collection");
    }

    protected void addContent(TraversableSource source) throws SAXException, ProcessingException {
    }

    protected void startNode(String nodeName, TraversableSource source) throws SAXException, ProcessingException {
        if (this.validity != null) {
            this.validity.addSource((Source)source);
        }
        this.setNodeAttributes(source);
        this.contentHandler.startElement(URI, nodeName, "collection:" + nodeName, this.attributes);
    }

    protected void setNodeAttributes(TraversableSource source) throws SAXException, ProcessingException {
        long lastModified = source.getLastModified();
        this.attributes.clear();
        this.attributes.addAttribute("", RES_NAME_ATTR_NAME, RES_NAME_ATTR_NAME, "CDATA", source.getName());
        this.attributes.addAttribute("", URI_ATTR_NAME, URI_ATTR_NAME, "CDATA", source.getURI());
        this.attributes.addAttribute("", LASTMOD_ATTR_NAME, LASTMOD_ATTR_NAME, "CDATA", Long.toString(source.getLastModified()));
        this.attributes.addAttribute("", DATE_ATTR_NAME, DATE_ATTR_NAME, "CDATA", this.dateFormatter.format(new Date(lastModified)));
        this.attributes.addAttribute("", SIZE_ATTR_NAME, SIZE_ATTR_NAME, "CDATA", Long.toString(source.getContentLength()));
        if (this.isRequestedSource) {
            this.attributes.addAttribute("", "sort", "sort", "CDATA", this.sort);
            this.attributes.addAttribute("", "reverse", "reverse", "CDATA", String.valueOf(this.reverse));
            this.attributes.addAttribute("", "requested", "requested", "CDATA", "true");
            this.isRequestedSource = false;
        }
    }

    protected void endNode(String nodeName) throws SAXException {
        this.contentHandler.endElement(URI, nodeName, "collection:" + nodeName);
    }

    protected boolean isRoot(TraversableSource source) {
        return this.rootRE == null ? true : this.rootRE.match(source.getName());
    }

    protected boolean isIncluded(TraversableSource source) {
        return this.includeRE == null ? true : this.includeRE.match(source.getName());
    }

    protected boolean isExcluded(TraversableSource source) {
        return this.excludeRE == null ? false : this.excludeRE.match(source.getName());
    }

    public void recycle() {
        this.cacheKeyParList = null;
        this.attributes = null;
        this.dateFormatter = null;
        this.rootRE = null;
        this.includeRE = null;
        this.excludeRE = null;
        this.validity = null;
        super.recycle();
    }
}

