/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.InspectableSource;
import org.apache.cocoon.components.source.helpers.SourceProperty;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.excalibur.source.Source;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SourcePropsWritingTransformer
extends AbstractSAXTransformer {
    public static final String SPWT_URI = "http://apache.org/cocoon/propwrite/1.0";
    public static final String PATCH_ELEMENT = "patch";
    public static final String SOURCE_ELEMENT = "source";
    public static final String SET_ELEMENT = "set";
    public static final String REMOVE_ELEMENT = "remove";
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_PATCH = 1;
    private static final int STATE_SOURCE = 2;
    private static final int STATE_SET = 3;
    private static final int STATE_REMOVE = 4;
    private int state;

    public SourcePropsWritingTransformer() {
        this.defaultNamespaceURI = SPWT_URI;
    }

    public void recycle() {
        super.recycle();
        this.state = 0;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.state = 0;
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws SAXException, IOException, ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN startTransformingElement uri=" + uri + ", name=" + name + ", raw=" + raw + ", attr=" + attr);
        }
        if (this.state == 0 && name.equals(PATCH_ELEMENT)) {
            this.state = 1;
            this.stack.push("END");
        } else if (this.state == 1 && name.equals(SOURCE_ELEMENT)) {
            this.state = 2;
            this.startTextRecording();
        } else if (this.state == 1 && name.equals(SET_ELEMENT)) {
            this.state = 3;
            this.startRecording();
        } else if (this.state == 1 && name.equals(REMOVE_ELEMENT)) {
            this.state = 4;
            this.startRecording();
        } else {
            super.startTransformingElement(uri, name, raw, attr);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END startTransformingElement");
        }
    }

    public void endTransformingElement(String uri, String name, String raw) throws SAXException, IOException, ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN endTransformingElement uri=" + uri + ", name=" + name + ", raw=" + raw);
        }
        if (this.state == 1 && name.equals(PATCH_ELEMENT)) {
            int i;
            Node node;
            NodeList list;
            this.state = 0;
            String sourceName = null;
            String tag = null;
            DocumentFragment setfrag = null;
            DocumentFragment removefrag = null;
            do {
                if ((tag = (String)this.stack.pop()).equals(SOURCE_ELEMENT)) {
                    sourceName = (String)this.stack.pop();
                    continue;
                }
                if (tag.equals(SET_ELEMENT)) {
                    setfrag = (DocumentFragment)this.stack.pop();
                    continue;
                }
                if (!tag.equals(REMOVE_ELEMENT)) continue;
                removefrag = (DocumentFragment)this.stack.pop();
            } while (!tag.equals("END"));
            if (setfrag != null) {
                list = setfrag.getChildNodes();
                node = null;
                for (i = 0; i < list.getLength(); ++i) {
                    node = list.item(i);
                    if (!(node instanceof Element)) continue;
                    this.setProperty(sourceName, (Element)node);
                }
            }
            if (removefrag != null) {
                list = removefrag.getChildNodes();
                node = null;
                for (i = 0; i < list.getLength(); ++i) {
                    node = list.item(i);
                    if (!(node instanceof Element)) continue;
                    this.removeProperty(sourceName, (Element)node);
                }
            }
        } else if (this.state == 2 && name.equals(SOURCE_ELEMENT)) {
            this.state = 1;
            String sourceName = this.endTextRecording();
            this.stack.push(sourceName);
            this.stack.push(SOURCE_ELEMENT);
        } else if (this.state == 3 && name.equals(SET_ELEMENT)) {
            this.state = 1;
            this.stack.push(this.endRecording());
            this.stack.push(SET_ELEMENT);
        } else if (this.state == 4 && name.equals(REMOVE_ELEMENT)) {
            this.state = 1;
            this.stack.push(this.endRecording());
            this.stack.push(REMOVE_ELEMENT);
        } else {
            super.endTransformingElement(uri, name, raw);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END endTransformingElement");
        }
    }

    private void setProperty(String src, Element element) throws ProcessingException, IOException, SAXException {
        if (src != null && element != null) {
            try {
                Source source = this.resolver.resolveURI(src);
                if (source instanceof InspectableSource) {
                    SourceProperty property = new SourceProperty(element);
                    ((InspectableSource)source).setSourceProperty(property);
                }
                this.getLogger().error("Cannot set properties on " + src + ": not an inspectable source");
            }
            catch (Exception e) {
                throw new ProcessingException("Error setting properties on " + src, (Throwable)e);
            }
        } else {
            this.getLogger().error("Error setting properties on " + src);
        }
    }

    private void removeProperty(String src, Element element) throws ProcessingException, IOException, SAXException {
        if (src != null && element != null) {
            try {
                Source source = this.resolver.resolveURI(src);
                if (source instanceof InspectableSource) {
                    ((InspectableSource)source).removeSourceProperty(element.getNamespaceURI(), element.getLocalName());
                }
                this.getLogger().error("Cannot remove properties on " + src + ": not an inspectable source");
            }
            catch (Exception e) {
                throw new ProcessingException("Error removing properties on " + src, (Throwable)e);
            }
        } else {
            this.getLogger().error("Error removing properties on " + src);
        }
    }
}

