/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.source.helpers.SourceCredential;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class XMLDBSource
extends AbstractLogEnabled
implements Source,
ModifiableSource,
XMLizable {
    public static final String URI = "http://apache.org/cocoon/xmldb/1.0";
    public static final String PREFIX = "db";
    protected static final String COLLECTIONS = "collections";
    protected static final String QCOLLECTIONS = "db:collections";
    protected static final String RESOURCE_COUNT_ATTR = "resources";
    protected static final String COLLECTION_COUNT_ATTR = "collections";
    protected static final String COLLECTION_BASE_ATTR = "base";
    protected static final String COLLECTION = "collection";
    protected static final String QCOLLECTION = "db:collection";
    protected static final String RESOURCE = "resource";
    protected static final String QRESOURCE = "db:resource";
    protected static final String NAME_ATTR = "name";
    protected static final String RESULTSET = "results";
    protected static final String QRESULTSET = "db:results";
    protected static final String QUERY_ATTR = "query";
    protected static final String RESULTS_COUNT_ATTR = "resources";
    protected static final String RESULT = "result";
    protected static final String QRESULT = "db:result";
    protected static final String RESULT_DOCID_ATTR = "docid";
    protected static final String RESULT_ID_ATTR = "id";
    protected static final String CDATA = "CDATA";
    protected String url;
    protected String user;
    protected String password;
    protected String query;
    protected String systemId;
    protected final ServiceManager manager;
    protected XMLDBOutputStream os;
    protected final Context context;

    public XMLDBSource(Logger logger, SourceCredential credential, String url, ServiceManager manager, Context context) {
        this.enableLogging(logger);
        this.context = context;
        this.manager = manager;
        this.user = credential.getPrincipal();
        this.password = credential.getPassword();
        int start = url.indexOf(35);
        if (start != -1) {
            this.url = url.substring(0, start);
            this.query = url.substring(start + 1);
        } else {
            this.url = url;
        }
        this.os = null;
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        try {
            if (this.url.endsWith("/")) {
                this.collectionToSAX(handler);
            } else {
                this.resourceToSAX(handler);
            }
        }
        catch (ProcessingException pe) {
            throw new SAXException("ProcessingException", (Exception)((Object)pe));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resourceToSAX(ContentHandler handler) throws SAXException, ProcessingException {
        String col = this.url.substring(0, this.url.lastIndexOf(47));
        String res = this.url.substring(this.url.lastIndexOf(47) + 1);
        Collection collection = null;
        try {
            try {
                collection = DatabaseManager.getCollection((String)col, (String)this.user, (String)this.password);
                if (collection == null) {
                    throw new ResourceNotFoundException("Document " + this.url + " not found");
                }
                XMLResource xmlResource = (XMLResource)collection.getResource(res);
                if (xmlResource == null) {
                    throw new ResourceNotFoundException("Document " + this.url + " not found");
                }
                if (this.query != null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Querying resource " + res + " from collection " + this.url + "; query= " + this.query);
                    }
                    this.queryToSAX(handler, collection, res);
                } else {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Obtaining resource " + res + " from collection " + col);
                    }
                    xmlResource.getContentAsSAX(handler);
                }
            }
            catch (XMLDBException xde) {
                String error = "Unable to fetch content. Error " + xde.errorCode + ": " + xde.getMessage();
                throw new SAXException(error, (Exception)((Object)xde));
            }
            Object var8_7 = null;
            if (collection == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (collection == null) throw throwable;
            try {
                collection.close();
                throw throwable;
            }
            catch (XMLDBException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (XMLDBException ignored) {}
        collection.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void collectionToSAX(ContentHandler handler) throws SAXException, ProcessingException {
        AttributesImpl attributes = new AttributesImpl();
        Collection collection = null;
        try {
            try {
                collection = DatabaseManager.getCollection((String)this.url, (String)this.user, (String)this.password);
                if (collection == null) {
                    throw new ResourceNotFoundException("Collection " + this.url + " not found");
                }
                if (this.query != null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Querying collection " + this.url + "; query= " + this.query);
                    }
                    this.queryToSAX(handler, collection, null);
                } else {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Listing collection " + this.url);
                    }
                    String nresources = Integer.toString(collection.getResourceCount());
                    attributes.addAttribute("", "resources", "resources", CDATA, nresources);
                    String ncollections = Integer.toString(collection.getChildCollectionCount());
                    attributes.addAttribute("", "collections", "collections", CDATA, ncollections);
                    attributes.addAttribute("", COLLECTION_BASE_ATTR, COLLECTION_BASE_ATTR, CDATA, this.url);
                    handler.startDocument();
                    handler.startPrefixMapping(PREFIX, URI);
                    handler.startElement(URI, "collections", QCOLLECTIONS, attributes);
                    String[] collections = collection.listChildCollections();
                    for (int i = 0; i < collections.length; ++i) {
                        attributes.clear();
                        attributes.addAttribute("", NAME_ATTR, NAME_ATTR, CDATA, collections[i]);
                        handler.startElement(URI, COLLECTION, QCOLLECTION, attributes);
                        handler.endElement(URI, COLLECTION, QCOLLECTION);
                    }
                    String[] resources = collection.listResources();
                    for (int i = 0; i < resources.length; ++i) {
                        attributes.clear();
                        attributes.addAttribute("", NAME_ATTR, NAME_ATTR, CDATA, resources[i]);
                        handler.startElement(URI, RESOURCE, QRESOURCE, attributes);
                        handler.endElement(URI, RESOURCE, QRESOURCE);
                    }
                    handler.endElement(URI, "collections", QCOLLECTIONS);
                    handler.endPrefixMapping(PREFIX);
                    handler.endDocument();
                }
            }
            catch (XMLDBException xde) {
                String error = "Collection listing failed. Error " + xde.errorCode + ": " + xde.getMessage();
                throw new SAXException(error, (Exception)((Object)xde));
            }
            Object var10_12 = null;
            if (collection == null) return;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (collection == null) throw throwable;
            try {
                collection.close();
                throw throwable;
            }
            catch (XMLDBException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (XMLDBException ignored) {}
        collection.close();
        return;
    }

    private void queryToSAX(ContentHandler handler, Collection collection, String resource) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        try {
            XPathQueryService service = (XPathQueryService)collection.getService("XPathQueryService", "1.0");
            ResourceSet resultSet = resource == null ? service.query(this.query) : service.queryResource(resource, this.query);
            attributes.addAttribute("", QUERY_ATTR, QUERY_ATTR, CDATA, this.query);
            attributes.addAttribute("", "resources", "resources", CDATA, Long.toString(resultSet.getSize()));
            handler.startDocument();
            handler.startPrefixMapping(PREFIX, URI);
            handler.startElement(URI, RESULTSET, QRESULTSET, attributes);
            IncludeXMLConsumer includeHandler = new IncludeXMLConsumer(handler);
            ResourceIterator results = resultSet.getIterator();
            while (results.hasMoreResources()) {
                XMLResource result = (XMLResource)results.nextResource();
                String id = result.getId();
                String documentId = result.getDocumentId();
                attributes.clear();
                if (id != null) {
                    attributes.addAttribute("", RESULT_ID_ATTR, RESULT_ID_ATTR, CDATA, id);
                }
                if (documentId != null) {
                    attributes.addAttribute("", RESULT_DOCID_ATTR, RESULT_DOCID_ATTR, CDATA, documentId);
                }
                handler.startElement(URI, RESULT, QRESULT, attributes);
                result.getContentAsSAX((ContentHandler)includeHandler);
                handler.endElement(URI, RESULT, QRESULT);
            }
            handler.endElement(URI, RESULTSET, QRESULTSET);
            handler.endPrefixMapping(PREFIX);
            handler.endDocument();
        }
        catch (XMLDBException xde) {
            String error = "Query failed. Error " + xde.errorCode + ": " + xde.getMessage();
            throw new SAXException(error, (Exception)((Object)xde));
        }
    }

    public void recycle() {
        this.url = null;
        this.user = null;
        this.password = null;
        this.query = null;
    }

    public String getURI() {
        return this.url;
    }

    public long getContentLength() {
        return -1L;
    }

    public long getLastModified() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean exists() {
        Collection collection;
        boolean result;
        block10: {
            String col = this.url.substring(0, this.url.lastIndexOf(47));
            String res = this.url.substring(this.url.lastIndexOf(47) + 1);
            result = true;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Testing existence of resource `" + res + "' from collection `" + this.url + "'; query (ignored) = `" + this.query + "'");
            }
            collection = null;
            collection = DatabaseManager.getCollection((String)col, (String)this.user, (String)this.password);
            if (collection == null) {
                result = false;
                break block10;
            }
            XMLResource xmlResource = (XMLResource)collection.getResource(res);
            if (xmlResource != null) break block10;
            result = false;
        }
        Object var7_7 = null;
        if (collection == null) return result;
        try {
            collection.close();
            return result;
        }
        catch (XMLDBException ignored) {}
        return result;
        {
            catch (XMLDBException xde) {
                result = false;
                Object var7_8 = null;
                if (collection == null) return result;
                try {
                    collection.close();
                    return result;
                }
                catch (XMLDBException ignored) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (collection == null) throw throwable;
            try {
                collection.close();
                throw throwable;
            }
            catch (XMLDBException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String getMimeType() {
        return null;
    }

    public String getScheme() {
        return this.url.substring(this.url.indexOf(47) - 1);
    }

    public SourceValidity getValidity() {
        return null;
    }

    public void refresh() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getInputStream() throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        ServiceSelector serializerSelector;
        ServiceManager manager;
        block8: {
            manager = null;
            serializerSelector = null;
            Serializer serializer = null;
            try {
                try {
                    manager = (ServiceManager)this.context.get((Object)"sitemap-service-manager");
                    serializerSelector = (ServiceSelector)manager.lookup(Serializer.ROLE + "Selector");
                    serializer = (Serializer)serializerSelector.select((Object)"xml");
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    serializer.setOutputStream((OutputStream)os);
                    this.toSAX((ContentHandler)serializer);
                    byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
                    Object var7_9 = null;
                    if (serializer == null) break block8;
                }
                catch (ServiceException e) {
                    throw new CascadingIOException("Could not lookup pipeline components", (Throwable)e);
                }
                catch (ContextException ce) {
                    throw new CascadingIOException("Could not get service manager.", (Throwable)ce);
                }
                catch (Exception e) {
                    throw new CascadingIOException("Exception during processing of " + this.getURI(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (serializer != null) {
                    serializerSelector.release(serializer);
                }
                if (serializerSelector == null) throw throwable;
                manager.release(serializerSelector);
                throw throwable;
            }
            serializerSelector.release((Object)serializer);
        }
        if (serializerSelector == null) return byteArrayInputStream;
        manager.release((Object)serializerSelector);
        return byteArrayInputStream;
    }

    public OutputStream getOutputStream() throws IOException, MalformedURLException {
        if (this.query != null) {
            throw new MalformedURLException("Cannot modify a resource that includes an XPATH expression");
        }
        this.os = new XMLDBOutputStream();
        return this.os;
    }

    private void writeOutputStream(String content) throws SourceException {
        String name = null;
        String base = null;
        try {
            if (this.url.endsWith("/")) {
                name = "";
                base = this.url.substring(0, this.url.length() - 1);
            } else {
                base = this.url.substring(0, this.url.lastIndexOf("/"));
                name = this.url.substring(this.url.lastIndexOf("/") + 1);
            }
            Collection collection = DatabaseManager.getCollection((String)base, (String)this.user, (String)this.password);
            if (name.equals("")) {
                name = collection.createId();
                this.url = this.url + name;
            }
            Resource resource = collection.createResource(name, "XMLResource");
            resource.setContent((Object)content);
            collection.storeResource(resource);
            this.getLogger().debug("Written to resource " + name);
        }
        catch (XMLDBException e) {
            String message = "Failed to create resource " + name + ": " + e.errorCode;
            this.getLogger().debug(message, (Throwable)e);
            throw new SourceException(message);
        }
    }

    public void delete() throws SourceException {
        String base = null;
        String name = null;
        if (this.url.endsWith("/")) {
            try {
                String k = this.url.substring(0, this.url.length() - 1);
                base = k.substring(0, k.lastIndexOf("/"));
                name = k.substring(k.lastIndexOf("/") + 1);
                Collection collection = DatabaseManager.getCollection((String)base, (String)this.user, (String)this.password);
                CollectionManagementService service = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
                service.removeCollection(name);
            }
            catch (XMLDBException e) {
                String message = "Failed to remove collection " + name + ": " + e.errorCode;
                this.getLogger().error(message, (Throwable)e);
                throw new SourceException(message);
            }
        }
        try {
            base = this.url.substring(0, this.url.lastIndexOf("/"));
            name = this.url.substring(this.url.lastIndexOf("/") + 1);
            Collection collection = DatabaseManager.getCollection((String)base, (String)this.user, (String)this.password);
            Resource resource = collection.getResource(name);
            if (resource == null) {
                String message = "Resource " + name + " does not exist";
                this.getLogger().debug(message);
                throw new SourceException(message);
            }
            collection.removeResource(resource);
            this.getLogger().debug("Removed resource: " + name);
        }
        catch (XMLDBException e) {
            String message = "Failed to delete resource " + name + ": " + e.errorCode;
            this.getLogger().debug(message, (Throwable)e);
            throw new SourceException(message);
        }
    }

    public boolean canCancel(OutputStream stream) {
        return !this.os.isClosed();
    }

    public void cancel(OutputStream stream) throws IOException {
        this.os.cancel();
        this.os = null;
    }

    public class XMLDBOutputStream
    extends OutputStream {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private boolean isClosed = false;

        public void write(int b) throws IOException {
            this.baos.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.baos.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.baos.write(b, off, len);
        }

        public void close() throws IOException, SourceException {
            if (!this.isClosed) {
                XMLDBSource.this.writeOutputStream(this.baos.toString());
                this.baos.close();
                this.isClosed = true;
            }
        }

        public void flush() throws IOException {
        }

        public int size() {
            return this.baos.size();
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public void cancel() {
            this.isClosed = true;
        }
    }
}

