/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.helpers.SourceCredential;
import org.apache.cocoon.components.source.impl.XMLDBSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceFactory;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public final class XMLDBSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
Contextualizable,
Configurable,
Serviceable,
ThreadSafe {
    protected ServiceManager m_manager;
    protected HashMap credentialMap;
    protected Context context;

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.credentialMap = new HashMap();
        Configuration[] drivers = conf.getChildren("driver");
        for (int i = 0; i < drivers.length; ++i) {
            String msg;
            String type = drivers[i].getAttribute("type");
            String driver = drivers[i].getAttribute("class");
            SourceCredential credential = new SourceCredential(null, null);
            credential.setPrincipal(drivers[i].getAttribute("user", null));
            credential.setPassword(drivers[i].getAttribute("password", null));
            this.credentialMap.put(type, credential);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Initializing XML:DB connection, using driver " + driver);
            }
            try {
                Database db = (Database)Class.forName(driver).newInstance();
                Configuration[] params = drivers[i].getChildren();
                for (int j = 0; j < params.length; ++j) {
                    db.setProperty(params[j].getName(), params[j].getValue());
                }
                DatabaseManager.registerDatabase((Database)db);
                continue;
            }
            catch (XMLDBException e) {
                msg = "Unable to connect to the XMLDB database '" + type + "'." + " Error " + e.errorCode + ": " + e.getMessage();
                this.getLogger().debug(msg, (Throwable)e);
                throw new ConfigurationException(msg, (Throwable)e);
            }
            catch (Exception e) {
                msg = "Unable to load XMLDB database driver '" + driver + "'." + " Make sure that the driver is available. Error: " + e.getMessage();
                this.getLogger().debug(msg, (Throwable)e);
                throw new ConfigurationException(msg, (Throwable)e);
            }
        }
    }

    public void service(ServiceManager cm) {
        this.m_manager = cm;
    }

    public Source getSource(String location, Map parameters) throws MalformedURLException, IOException {
        int start = location.indexOf(58) + 1;
        int end = location.indexOf(58, start);
        if (start == 0 || end == -1) {
            throw new MalformedURLException("Mispelled XML:DB URL. The syntax is \"xmldb:databasetype://host/collection/resource\"");
        }
        String type = location.substring(start, end);
        SourceCredential credential = (SourceCredential)this.credentialMap.get(type);
        return new XMLDBSource(this.getLogger(), credential, location, this.m_manager, this.context);
    }

    public void release(Source source) {
        if (null != source) {
            ((XMLDBSource)source).recycle();
        }
    }
}

