/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.util.Deprecation;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class XMLDBCollectionGenerator
extends ServiceableGenerator
implements CacheableProcessingComponent,
Configurable,
Initializable {
    protected static final String URI = "http://apache.org/cocoon/xmldb/1.0";
    protected static final String PREFIX = "collection";
    protected static final String RESOURCE_COUNT_ATTR = "resources";
    protected static final String COLLECTION_COUNT_ATTR = "collections";
    protected static final String COLLECTION = "collection";
    protected static final String QCOLLECTION = "collection:collection";
    protected static final String RESOURCE = "resource";
    protected static final String QRESOURCE = "collection:resource";
    protected String driver;
    protected String base;
    protected String col;
    protected Database database;
    protected Collection collection;
    protected final AttributesImpl attributes = new AttributesImpl();

    public void recycle() {
        super.recycle();
        this.col = null;
        this.collection = null;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.driver = conf.getChild("driver").getValue();
        this.base = conf.getChild("base").getValue();
    }

    public void initialize() throws Exception {
        try {
            Class<?> c = Class.forName(this.driver);
            this.database = (Database)c.newInstance();
            DatabaseManager.registerDatabase((Database)this.database);
        }
        catch (XMLDBException xde) {
            this.getLogger().error("Unable to connect to the XML:DB database");
            throw new ProcessingException("Unable to connect to the XML DB" + xde.getMessage());
        }
        catch (Exception e) {
            this.getLogger().error("There was a problem setting up the connection");
            this.getLogger().error("Make sure that your driver is available");
            throw new ProcessingException("Problem setting up the connection: " + e.getMessage());
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        Deprecation.logger.warn("The XMLDBCollectionGenerator is deprecated. Use the XML:DB pseudo protocol instead");
        super.setup(resolver, objectModel, src, par);
    }

    public SourceValidity getValidity() {
        return null;
    }

    public Serializable getKey() {
        return null;
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.col = this.source;
        try {
            this.collection = DatabaseManager.getCollection((String)(this.base + this.col));
            if (this.collection == null) {
                throw new ResourceNotFoundException("Collection " + this.col + " not found");
            }
            this.collectionToSAX(this.collection);
            this.collection.close();
        }
        catch (XMLDBException xde) {
            throw new ProcessingException("Unable to fetch content '" + this.source + "':" + xde.getMessage());
        }
        catch (NullPointerException npe) {
            this.getLogger().error("The XML:DB driver raised an exception");
            this.getLogger().error("probably the document was not found");
            throw new ProcessingException("Null pointer exception while retrieving document : " + npe.getMessage());
        }
    }

    public void collectionToSAX(Collection collection) throws SAXException {
        try {
            int i;
            String ncollections = Integer.toString(collection.getChildCollectionCount());
            String nresources = Integer.toString(collection.getResourceCount());
            this.attributes.clear();
            this.attributes.addAttribute("", RESOURCE_COUNT_ATTR, RESOURCE_COUNT_ATTR, "CDATA", nresources);
            this.attributes.addAttribute("", COLLECTION_COUNT_ATTR, COLLECTION_COUNT_ATTR, "CDATA", ncollections);
            String[] collections = collection.listChildCollections();
            String[] resources = collection.listResources();
            this.xmlConsumer.startDocument();
            this.xmlConsumer.startPrefixMapping("collection", URI);
            this.xmlConsumer.startElement(URI, COLLECTION_COUNT_ATTR, "collection:collections", (Attributes)this.attributes);
            for (i = 0; i < collections.length; ++i) {
                this.attributes.clear();
                this.attributes.addAttribute("", "name", "name", "CDATA", collections[i]);
                this.xmlConsumer.startElement(URI, "collection", QCOLLECTION, (Attributes)this.attributes);
                this.xmlConsumer.endElement(URI, "collection", "collection");
            }
            for (i = 0; i < resources.length; ++i) {
                this.attributes.clear();
                this.attributes.addAttribute("", "name", "name", "CDATA", resources[i]);
                this.xmlConsumer.startElement(URI, RESOURCE, QRESOURCE, (Attributes)this.attributes);
                this.xmlConsumer.endElement(URI, RESOURCE, RESOURCE);
            }
            this.xmlConsumer.endElement(URI, COLLECTION_COUNT_ATTR, "collection:collections");
            this.xmlConsumer.endPrefixMapping("collection");
            this.xmlConsumer.endDocument();
        }
        catch (XMLDBException xde) {
            this.getLogger().warn("Collection listing failed: " + xde.getMessage());
            throw new SAXException("Collection listing failed: " + xde.getMessage());
        }
    }
}

