/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.util.TraxErrorHandler;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XUpdateQueryService;

public class XMLDBTransformer
extends AbstractTransformer
implements CacheableProcessingComponent,
Configurable,
Initializable {
    private static String XMLDB_URI = "http://apache.org/cocoon/xmldb/1.0";
    private static String XMLDB_QUERY_ELEMENT = "query";
    private static String XMLDB_QUERY_TYPE_ATTRIBUTE = "type";
    private static String XMLDB_QUERY_CONTEXT_ATTRIBUTE = "collection";
    private static String XMLDB_QUERY_OID_ATTRIBUTE = "oid";
    private static String XMLDB_QUERY_RESULT_ATTRIBUTE = "result";
    private SAXTransformerFactory tfactory = null;
    private Properties format = new Properties();
    private Map prefixMap = new HashMap();
    private String driver = null;
    private String default_base;
    private String local_base;
    private String xbase;
    private Collection collection;
    private String operation;
    private String key;
    private String result;
    private String message;
    private StringWriter queryWriter;
    private TransformerHandler queryHandler;
    private boolean processing;

    public XMLDBTransformer() {
        this.format.put("encoding", "utf-8");
        this.format.put("indent", "no");
        this.format.put("omit-xml-declaration", "yes");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.driver = configuration.getChild("driver").getValue(null);
        if (this.driver == null) {
            this.getLogger().debug("Driver parameter is missing. Transformer will not initialize database.");
        }
        this.default_base = configuration.getChild("base").getValue(null);
    }

    public void initialize() throws Exception {
        if (this.driver != null) {
            Class<?> c = Class.forName(this.driver);
            Database database = (Database)c.newInstance();
            DatabaseManager.registerDatabase((Database)database);
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        this.local_base = par.getParameter("base", this.default_base);
        if (this.local_base == null) {
            throw new ProcessingException("Required base parameter is missing. Syntax is: xmldb:xindice:///db/collection");
        }
        try {
            this.collection = DatabaseManager.getCollection((String)this.local_base);
        }
        catch (XMLDBException e) {
            throw new ProcessingException("Could not get collection " + this.local_base + ": " + e.errorCode, (Throwable)e);
        }
        if (this.collection == null) {
            throw new ResourceNotFoundException("Collection " + this.local_base + " does not exist");
        }
    }

    protected SAXTransformerFactory getTransformerFactory() {
        if (this.tfactory == null) {
            this.tfactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            this.tfactory.setErrorListener((ErrorListener)new TraxErrorHandler(this.getLogger()));
        }
        return this.tfactory;
    }

    public Serializable getKey() {
        return null;
    }

    public SourceValidity getValidity() {
        return null;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!this.processing) {
            super.startPrefixMapping(prefix, uri);
            this.prefixMap.put(prefix, uri);
        } else if (this.queryHandler != null) {
            this.queryHandler.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (!this.processing) {
            super.endPrefixMapping(prefix);
            this.prefixMap.remove(prefix);
        } else if (this.queryHandler != null) {
            this.queryHandler.endPrefixMapping(prefix);
        }
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (!this.processing) {
            if (XMLDB_URI.equals(uri) && XMLDB_QUERY_ELEMENT.equals(loc)) {
                this.operation = a.getValue(XMLDB_QUERY_TYPE_ATTRIBUTE);
                if (!("create".equals(this.operation) || "delete".equals(this.operation) || "update".equals(this.operation))) {
                    throw new SAXException("Supported operation types are: create, delete, update");
                }
                this.key = a.getValue(XMLDB_QUERY_OID_ATTRIBUTE);
                if ("delete".equals(this.operation) && this.key == null) {
                    throw new SAXException("Object ID attribute is missing on query element");
                }
                this.xbase = a.getValue(XMLDB_QUERY_CONTEXT_ATTRIBUTE);
                this.result = "failure";
                this.message = null;
                this.processing = true;
                if (!("create".equals(this.operation) && this.key != null && this.key.endsWith("/") || "delete".equals(this.operation))) {
                    this.queryWriter = new StringWriter(256);
                    try {
                        this.queryHandler = this.getTransformerFactory().newTransformerHandler();
                        this.queryHandler.setResult(new StreamResult(this.queryWriter));
                        this.queryHandler.getTransformer().setOutputProperties(this.format);
                    }
                    catch (TransformerConfigurationException e) {
                        throw new SAXException("Failed to get transformer handler", e);
                    }
                    this.queryHandler.startDocument();
                    Iterator i = this.prefixMap.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        this.queryHandler.startPrefixMapping((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            } else {
                super.startElement(uri, loc, raw, a);
            }
        } else if (this.queryHandler != null) {
            this.queryHandler.startElement(uri, loc, raw, a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endElement(String uri, String loc, String raw) throws SAXException {
        block33: {
            block31: {
                if (!this.processing) {
                    super.endElement(uri, loc, raw);
                    return;
                }
                if (!XMLDBTransformer.XMLDB_URI.equals(uri) || !XMLDBTransformer.XMLDB_QUERY_ELEMENT.equals(loc)) break block33;
                this.processing = false;
                document = null;
                if (this.queryHandler != null) {
                    i = this.prefixMap.entrySet().iterator();
                    while (i.hasNext()) {
                        entry = i.next();
                        this.queryHandler.endPrefixMapping((String)entry.getKey());
                    }
                    this.queryHandler.endDocument();
                    document = this.queryWriter.toString();
                }
                collection = null;
                try {
                    try {
                        block30: {
                            block36: {
                                block35: {
                                    block34: {
                                        v0 = collection = this.xbase != null ? DatabaseManager.getCollection((String)(this.local_base + "/" + this.xbase)) : this.collection;
                                        if (collection != null) break block34;
                                        this.message = "Failed to " + this.operation + " resource " + this.key + ": Collection " + this.local_base + "/" + this.xbase + " not found.";
                                        this.getLogger().debug(this.message);
                                        break block30;
                                    }
                                    if (!"create".equals(this.operation)) break block35;
                                    if (this.key != null && this.key.endsWith("/")) {
                                        try {
                                            k = this.key.substring(0, this.key.length() - 1);
                                            service = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
                                            service.createCollection(k);
                                            this.result = "success";
                                        }
                                        catch (XMLDBException e) {
                                            this.message = "Failed to create collection " + this.key + ": " + e.errorCode;
                                            this.getLogger().error(this.message, (Throwable)e);
                                        }
                                        break block30;
                                    } else {
                                        try {
                                            if (this.key == null) {
                                                this.key = collection.createId();
                                            }
                                            resource = collection.createResource(this.key, "XMLResource");
                                            resource.setContent((Object)document);
                                            collection.storeResource(resource);
                                            this.result = "success";
                                            this.key = resource.getId();
                                        }
                                        catch (XMLDBException e) {
                                            this.message = "Failed to create resource " + this.key + ": " + e.errorCode;
                                            this.getLogger().debug(this.message, (Throwable)e);
                                        }
                                    }
                                    break block30;
                                }
                                if (!"delete".equals(this.operation)) break block36;
                                if (this.key != null && this.key.endsWith("/")) {
                                    try {
                                        k = this.key.substring(0, this.key.length() - 1);
                                        service = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
                                        service.removeCollection(k);
                                        this.result = "success";
                                    }
                                    catch (XMLDBException e) {
                                        this.message = "Failed to delete collection " + this.key + ": " + e.errorCode;
                                        this.getLogger().error(this.message, (Throwable)e);
                                    }
                                    break block30;
                                } else {
                                    try {
                                        resource = collection.getResource(this.key);
                                        if (resource == null) {
                                            this.message = "Resource " + this.key + " does not exist";
                                            this.getLogger().debug(this.message);
                                            break block30;
                                        }
                                        collection.removeResource(resource);
                                        this.result = "success";
                                    }
                                    catch (XMLDBException e) {
                                        this.message = "Failed to delete resource " + this.key + ": " + e.errorCode;
                                        this.getLogger().debug(this.message, (Throwable)e);
                                    }
                                }
                                break block30;
                            }
                            if ("update".equals(this.operation)) {
                                try {
                                    service = (XUpdateQueryService)collection.getService("XUpdateQueryService", "1.0");
                                    count = this.key == null ? service.update(document) : service.updateResource(this.key, document);
                                    this.message = count + " entries updated.";
                                    this.result = "success";
                                }
                                catch (XMLDBException e) {
                                    this.message = "Failed to update resource " + this.key + ": " + e.errorCode;
                                    this.getLogger().debug(this.message, (Throwable)e);
                                }
                            }
                        }
                        var10_16 = null;
                        if (this.xbase == null || collection == null) break block31;
                    }
                    catch (XMLDBException e) {
                        this.message = "Failed to get context collection for the query (base: " + this.local_base + ", context: " + this.xbase + "): " + e.errorCode;
                        this.getLogger().debug(this.message, (Throwable)e);
                        var10_17 = null;
                        if (this.xbase != null && collection != null) {
                            try {
                                collection.close();
                            }
                            catch (XMLDBException ignored) {}
                        }
                        break block31;
                    }
                }
                catch (Throwable var9_22) {
                    var10_18 = null;
                    if (this.xbase == null) throw var9_22;
                    if (collection == null) throw var9_22;
                    ** try [egrp 7[TRYBLOCK] [9 : 1081->1091)] { 
lbl109:
                    // 1 sources

                    collection.close();
                    throw var9_22;
lbl111:
                    // 1 sources

                    catch (XMLDBException ignored) {
                        // empty catch block
                    }
                    throw var9_22;
                }
                try {}
                catch (XMLDBException ignored) {}
                collection.close();
            }
            attrs = new AttributesImpl();
            attrs.addAttribute(null, XMLDBTransformer.XMLDB_QUERY_OID_ATTRIBUTE, XMLDBTransformer.XMLDB_QUERY_OID_ATTRIBUTE, "CDATA", this.key);
            attrs.addAttribute(null, XMLDBTransformer.XMLDB_QUERY_TYPE_ATTRIBUTE, XMLDBTransformer.XMLDB_QUERY_TYPE_ATTRIBUTE, "CDATA", this.operation);
            attrs.addAttribute(null, XMLDBTransformer.XMLDB_QUERY_RESULT_ATTRIBUTE, XMLDBTransformer.XMLDB_QUERY_RESULT_ATTRIBUTE, "CDATA", this.result);
            super.startElement(uri, loc, raw, (Attributes)attrs);
            if (this.message != null) {
                super.characters(this.message.toCharArray(), 0, this.message.length());
            }
            super.endElement(uri, loc, raw);
            return;
        }
        if (this.queryHandler == null) return;
        this.queryHandler.endElement(uri, loc, raw);
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        if (!this.processing) {
            super.characters(c, start, len);
        } else if (this.queryHandler != null) {
            this.queryHandler.characters(c, start, len);
        }
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        if (!this.processing) {
            super.ignorableWhitespace(c, start, len);
        } else if (this.queryHandler != null) {
            this.queryHandler.ignorableWhitespace(c, start, len);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (!this.processing) {
            super.processingInstruction(target, data);
        } else if (this.queryHandler != null) {
            this.queryHandler.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (!this.processing) {
            super.skippedEntity(name);
        } else if (this.queryHandler != null) {
            this.queryHandler.skippedEntity(name);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.processing) {
            throw new SAXException("Recieved startDTD after beginning SVG extraction process.");
        }
        super.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        if (this.processing) {
            throw new SAXException("Recieved endDTD after xmldb element.");
        }
        super.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        if (!this.processing) {
            super.startEntity(name);
        } else if (this.queryHandler != null) {
            this.queryHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (!this.processing) {
            super.endEntity(name);
        } else if (this.queryHandler != null) {
            this.queryHandler.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (!this.processing) {
            super.startCDATA();
        } else if (this.queryHandler != null) {
            this.queryHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (!this.processing) {
            super.endCDATA();
        } else if (this.queryHandler != null) {
            this.queryHandler.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        if (!this.processing) {
            super.comment(ch, start, len);
        } else if (this.queryHandler != null) {
            this.queryHandler.comment(ch, start, len);
        }
    }

    public void recycle() {
        this.prefixMap.clear();
        this.queryHandler = null;
        this.queryWriter = null;
        try {
            if (this.collection != null) {
                this.collection.close();
            }
        }
        catch (XMLDBException e) {
            this.getLogger().error("Failed to close collection " + this.local_base + ". Error " + e.errorCode, (Throwable)e);
        }
        this.collection = null;
        super.recycle();
    }
}

