/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.authentication.components;

import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.webapps.authentication.components.Authenticator;
import org.apache.cocoon.webapps.authentication.configuration.HandlerConfiguration;
import org.apache.cocoon.webapps.authentication.user.UserHandler;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.xml.dom.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ServletAuthenticator
extends AbstractLogEnabled
implements Contextualizable,
ThreadSafe,
Serviceable,
Authenticator {
    protected Context context;
    protected ServiceManager manager;

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    protected void fillContext(Document contextDoc) {
        Request req = ContextHelper.getRequest((Context)this.context);
        Element root = contextDoc.getDocumentElement();
        Element id = contextDoc.createElement("ID");
        id.appendChild(contextDoc.createTextNode(req.getRemoteUser()));
        root.appendChild(id);
    }

    public Authenticator.AuthenticationResult authenticate(HandlerConfiguration configuration, SourceParameters parameters) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("start authenticator using handler " + configuration.getName());
        }
        Request req = ContextHelper.getRequest((Context)this.context);
        Authenticator.AuthenticationResult result = null;
        if (req.getRemoteUser() != null) {
            DOMParser parser = null;
            try {
                parser = (DOMParser)this.manager.lookup(DOMParser.ROLE);
                Document doc = parser.createDocument();
                Element root = doc.createElement("authentication");
                doc.appendChild(root);
                this.fillContext(doc);
                result = new Authenticator.AuthenticationResult(true, doc);
            }
            catch (SAXException se) {
                throw new ProcessingException("Unable to create document.", (Throwable)se);
            }
            catch (ServiceException se) {
                throw new ProcessingException("Unable to lookup dom parser.", (Throwable)se);
            }
            finally {
                this.manager.release((Object)parser);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("end authenticator: " + result);
        }
        return result;
    }

    public void logout(UserHandler handler) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logout using handler " + handler.getHandlerName());
        }
    }
}

