/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.components.source.impl.PartSource;
import org.apache.cocoon.environment.Redirector;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;

public class CopySourceAction
extends ServiceableAction
implements ThreadSafe {
    private SourceResolver resolver;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map act(Redirector redirector, org.apache.cocoon.environment.SourceResolver oldResolver, Map objectModel, String source, Parameters par) throws Exception {
        TraversableSource trDest;
        Source src = this.resolver.resolveURI(source);
        Source dest = this.resolver.resolveURI(par.getParameter("dest"));
        if (!(dest instanceof ModifiableSource)) {
            throw new IllegalArgumentException("Non-writeable URI : " + dest.getURI());
        }
        if (dest instanceof TraversableSource && (trDest = (TraversableSource)dest).isCollection()) {
            if (src instanceof TraversableSource) {
                dest = trDest.getChild(((TraversableSource)src).getName());
            } else if (src instanceof PartSource) {
                dest = trDest.getChild(((PartSource)src).getPart().getFileName());
            }
        }
        ModifiableSource wdest = (ModifiableSource)dest;
        InputStream is = src.getInputStream();
        OutputStream os = wdest.getOutputStream();
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                os.write(buffer, 0, len);
            }
            os.close();
        }
        catch (Exception e) {
            if (wdest.canCancel(os)) {
                wdest.cancel(os);
            }
        }
        finally {
            is.close();
        }
        return EMPTY_MAP;
    }
}

