/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.classloader;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.classloader.ClassLoaderManager;
import org.apache.cocoon.components.classloader.RepositoryClassLoader;

public class ClassLoaderManagerImpl
implements ClassLoaderManager,
ThreadSafe {
    private static RepositoryClassLoader instance = null;
    protected static final Set fileSet = Collections.synchronizedSet(new HashSet());

    public ClassLoaderManagerImpl() {
        if (instance == null) {
            this.reinstantiate();
        }
    }

    public void addDirectory(File directoryName) throws IOException {
        if (!fileSet.contains(directoryName)) {
            fileSet.add(directoryName);
            instance.addDirectory(directoryName);
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return instance.loadClass(className);
    }

    public void reinstantiate() {
        instance = fileSet.isEmpty() ? new RepositoryClassLoader() : new RepositoryClassLoader(new Vector(fileSet));
    }
}

