/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.util.IOUtils;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.StoreJanitor;

public class EHDefaultStore
extends AbstractLogEnabled
implements Store,
Contextualizable,
Serviceable,
Parameterizable,
Initializable,
Disposable,
ThreadSafe {
    private static final String CONFIG_FILE = "org/apache/cocoon/components/store/impl/ehcache.xml";
    private static int instanceCount = 0;
    private Cache cache;
    private CacheManager cacheManager;
    private final String cacheName = "cocoon-ehcache-" + ++instanceCount;
    private int maxObjects;
    private boolean overflowToDisk;
    private ServiceManager manager;
    private StoreJanitor storeJanitor;
    private File workDir;
    private File cacheDir;

    public void contextualize(Context context) throws ContextException {
        this.workDir = (File)context.get((Object)"work-directory");
        this.cacheDir = (File)context.get((Object)"cache-directory");
    }

    public void service(ServiceManager aManager) throws ServiceException {
        this.manager = aManager;
        this.storeJanitor = (StoreJanitor)this.manager.lookup(StoreJanitor.ROLE);
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.maxObjects = parameters.getParameterAsInteger("maxobjects", 10000);
        this.overflowToDisk = parameters.getParameterAsBoolean("overflow-to-disk", true);
        try {
            if (parameters.getParameterAsBoolean("use-cache-directory", false)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using cache directory: " + this.cacheDir);
                }
                this.setDirectory(this.cacheDir);
            } else if (parameters.getParameterAsBoolean("use-work-directory", false)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using work directory: " + this.workDir);
                }
                this.setDirectory(this.workDir);
            } else if (parameters.getParameter("directory", null) != null) {
                String dir = parameters.getParameter("directory");
                dir = IOUtils.getContextFilePath(this.workDir.getPath(), dir);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using directory: " + dir);
                }
                this.setDirectory(new File(dir));
            } else {
                try {
                    this.setDirectory(this.workDir);
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            throw new ParameterException("Unable to set directory", (Throwable)e);
        }
    }

    private void setDirectory(File directory) throws IOException {
        String directoryPath = EHDefaultStore.getFullFilename(directory);
        directoryPath = directoryPath + File.separator;
        if (!directory.exists() && !directory.mkdir()) {
            throw new IOException("Error creating store directory '" + directoryPath + "': ");
        }
        if (!directory.isDirectory()) {
            throw new IOException("'" + directoryPath + "' is not a directory");
        }
        if (!directory.canRead() || !directory.canWrite()) {
            throw new IOException("Directory '" + directoryPath + "' is not readable/writable");
        }
        System.setProperty("java.io.tmpdir", directoryPath);
    }

    private static String getFullFilename(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    public void initialize() throws Exception {
        URL configFileURL = Thread.currentThread().getContextClassLoader().getResource(CONFIG_FILE);
        this.cacheManager = CacheManager.create((URL)configFileURL);
        this.cache = new Cache(this.cacheName, this.maxObjects, this.overflowToDisk, true, 0L, 0L, true, 120L);
        this.cacheManager.addCache(this.cache);
        this.storeJanitor.register((Store)this);
    }

    public void dispose() {
        if (this.storeJanitor != null) {
            this.storeJanitor.unregister((Store)this);
            this.manager.release((Object)this.storeJanitor);
            this.storeJanitor = null;
        }
        this.manager = null;
        this.cacheManager.shutdown();
        this.cacheManager = null;
        this.cache = null;
    }

    public Object get(Object key) {
        Serializable value = null;
        try {
            Element element = this.cache.get((Serializable)key);
            if (element != null) {
                value = element.getValue();
            }
        }
        catch (CacheException e) {
            this.getLogger().error("Failure retrieving object from store", (Throwable)e);
        }
        if (this.getLogger().isDebugEnabled()) {
            if (value != null) {
                this.getLogger().debug("Found key: " + key);
            } else {
                this.getLogger().debug("NOT Found key: " + key);
            }
        }
        return value;
    }

    public void store(Object key, Object value) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Store object " + value + " with key " + key);
        }
        Element element = new Element((Serializable)key, (Serializable)value);
        this.cache.put(element);
    }

    public void free() {
        block5: {
            try {
                List keys = this.cache.getKeysNoDuplicateCheck();
                if (!keys.isEmpty()) {
                    Serializable key = (Serializable)keys.get(0);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Freeing cache");
                        this.getLogger().debug("key: " + key);
                        this.getLogger().debug("value: " + this.cache.get(key));
                    }
                    if (!this.cache.remove(key) && this.getLogger().isInfoEnabled()) {
                        this.getLogger().info("Concurrency condition in free()");
                    }
                }
            }
            catch (CacheException e) {
                if (!this.getLogger().isWarnEnabled()) break block5;
                this.getLogger().warn("Error in free()", (Throwable)e);
            }
        }
    }

    public void remove(Object key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Removing item " + key);
        }
        this.cache.remove((Serializable)key);
    }

    public void clear() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Clearing the store");
        }
        try {
            this.cache.removeAll();
        }
        catch (IOException e) {
            this.getLogger().error("Failure to clearing store", (Throwable)e);
        }
    }

    public boolean containsKey(Object key) {
        try {
            return this.cache.get((Serializable)key) != null;
        }
        catch (CacheException e) {
            this.getLogger().error("Failure retrieving object from store", (Throwable)e);
            return false;
        }
    }

    public Enumeration keys() {
        List keys = null;
        try {
            keys = this.cache.getKeys();
        }
        catch (CacheException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Error while getting cache keys", (Throwable)e);
            }
            keys = Collections.EMPTY_LIST;
        }
        return Collections.enumeration(keys);
    }

    public int size() {
        try {
            return this.cache.getSize();
        }
        catch (CacheException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Error while getting cache size", (Throwable)e);
            }
            return 0;
        }
    }
}

