/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.util.IOUtils;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.StoreJanitor;
import org.apache.jcs.access.GroupCacheAccess;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.engine.memory.MemoryCache;

public class JCSDefaultStore
extends AbstractLogEnabled
implements Store,
Contextualizable,
Parameterizable,
Initializable,
Disposable,
ThreadSafe,
Serviceable {
    protected Properties properties;
    protected String region;
    private CompositeCacheManager cacheManager;
    private JCSCacheAccess jcs;
    private static final String DEFAULT_PROPERTIES = "org/apache/cocoon/components/store/default.ccf";
    private Context context;
    private ServiceManager manager;
    private StoreJanitor janitor;

    public void contextualize(Context aContext) throws ContextException {
        this.context = aContext;
    }

    public void service(ServiceManager aManager) throws ServiceException {
        this.manager = aManager;
        this.janitor = (StoreJanitor)this.manager.lookup(StoreJanitor.ROLE);
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.region = parameters.getParameter("region-name", "main");
        Properties defaults = new Properties();
        try {
            String defaultsFile = this.getDefaultPropertiesFile();
            if (defaultsFile != null) {
                defaults.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(defaultsFile));
            }
        }
        catch (IOException e) {
            throw new ParameterException("Failure loading cache defaults", (Throwable)e);
        }
        this.properties = new Properties(defaults);
        String[] names = parameters.getNames();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].startsWith("jcs.")) continue;
            this.properties.put(names[i], parameters.getParameter(names[i]));
        }
        int maxobjects = parameters.getParameterAsInteger("maxobjects", -1);
        if (maxobjects != -1) {
            String key = "jcs.region." + this.region + ".cacheattributes.MaxObjects";
            this.properties.setProperty(key, String.valueOf(maxobjects));
        }
        try {
            File workDir = (File)this.context.get((Object)"work-directory");
            if (parameters.getParameterAsBoolean("use-cache-directory", false)) {
                File cacheDir = (File)this.context.get((Object)"cache-directory");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using cache directory: " + cacheDir);
                }
                this.setDirectory(cacheDir);
            } else if (parameters.getParameterAsBoolean("use-work-directory", false)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using work directory: " + workDir);
                }
                this.setDirectory(workDir);
            } else if (parameters.getParameter("directory", null) != null) {
                String dir = parameters.getParameter("directory");
                dir = IOUtils.getContextFilePath(workDir.getPath(), dir);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using directory: " + dir);
                }
                this.setDirectory(new File(dir));
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using default directory: " + workDir);
                }
                this.setDirectory(workDir);
            }
        }
        catch (ContextException ce) {
            throw new ParameterException("Unable to get directory information from context.", (Throwable)ce);
        }
        catch (IOException e) {
            throw new ParameterException("Unable to set directory", (Throwable)e);
        }
    }

    public void initialize() throws Exception {
        this.cacheManager = CompositeCacheManager.getUnconfiguredInstance();
        this.cacheManager.configure(this.properties);
        this.jcs = new JCSCacheAccess(this.cacheManager.getCache(this.region));
        this.janitor.register((Store)this);
    }

    public void dispose() {
        if (this.janitor != null) {
            this.janitor.unregister((Store)this);
        }
        if (this.jcs != null) {
            this.jcs.dispose();
            this.jcs = null;
        }
        if (this.cacheManager != null) {
            this.cacheManager.release();
            this.cacheManager = null;
        }
        this.properties = null;
        if (this.manager != null) {
            this.manager.release((Object)this.janitor);
            this.janitor = null;
            this.manager = null;
        }
    }

    protected String getDefaultPropertiesFile() {
        return DEFAULT_PROPERTIES;
    }

    private void setDirectory(File directory) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Error creating store directory '" + directory.getAbsolutePath() + "'. ");
        }
        if (!directory.isDirectory()) {
            throw new IOException("'" + directory.getAbsolutePath() + "' is not a directory");
        }
        if (!directory.canRead() || !directory.canWrite()) {
            throw new IOException("Directory '" + directory.getAbsolutePath() + "' is not readable/writable");
        }
        this.properties.setProperty("jcs.auxiliary.DC.attributes.DiskPath", directory.getAbsolutePath());
    }

    public Object get(Object key) {
        Object value = this.jcs.get(key);
        if (this.getLogger().isDebugEnabled()) {
            if (value != null) {
                this.getLogger().debug("Found key: " + key);
            } else {
                this.getLogger().debug("NOT Found key: " + key);
            }
        }
        return value;
    }

    public void store(Object key, Object value) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Store object " + value + " with key " + key);
        }
        try {
            this.jcs.put(key, value);
        }
        catch (CacheException ce) {
            this.getLogger().error("Failure storing object ", (Throwable)ce);
        }
    }

    public void free() {
        MemoryCache memoryCache = this.cacheManager.getCache(this.region).getMemoryCache();
        Object[] keys = memoryCache.getKeyArray();
        if (keys != null && keys.length > 0) {
            Object key = keys[0];
            try {
                memoryCache.remove((Serializable)key);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public void clear() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Clearing the store");
        }
        try {
            this.jcs.remove();
        }
        catch (CacheException ce) {
            this.getLogger().error("Failure clearing store", (Throwable)ce);
        }
    }

    public void remove(Object key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Removing item " + key);
        }
        try {
            this.jcs.remove(key);
        }
        catch (CacheException ce) {
            this.getLogger().error("Failure removing object", (Throwable)ce);
        }
    }

    public boolean containsKey(Object key) {
        return this.jcs.get(key) != null;
    }

    public Enumeration keys() {
        MemoryCache memoryCache = this.cacheManager.getCache(this.region).getMemoryCache();
        Object[] keys = memoryCache.getKeyArray();
        return new IteratorEnumeration(Arrays.asList(keys).iterator());
    }

    public int size() {
        MemoryCache memoryCache = this.cacheManager.getCache(this.region).getMemoryCache();
        return memoryCache.getSize();
    }

    private static class JCSCacheAccess
    extends GroupCacheAccess {
        private JCSCacheAccess(CompositeCache cacheControl) {
            super(cacheControl);
        }

        public void dispose() {
            super.dispose();
        }
    }
}

