/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.NamespacedSAXConfigurationHandler;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ExtendedComponentSelector;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.ConcreteTreeProcessor;
import org.apache.cocoon.components.treeprocessor.LinkedProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.TreeBuilder;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.cocoon.sitemap.SitemapParameters;
import org.apache.excalibur.source.Source;
import org.xml.sax.ContentHandler;

public class DefaultTreeBuilder
extends AbstractLogEnabled
implements TreeBuilder,
Recomposable,
Configurable,
Contextualizable,
RoleManageable,
Recyclable,
Disposable {
    protected Map attributes = new HashMap();
    protected ConcreteTreeProcessor processor;
    protected Context context;
    protected ComponentManager parentManager;
    protected RoleManager parentRoleManager;
    protected Configuration configuration;
    protected ComponentManager manager;
    protected RoleManager roleManager;
    protected ComponentSelector builderSelector;
    protected LifecycleHelper lifecycle;
    protected String namespace;
    protected String parameterElement;
    protected String languageName;
    protected String fileName;
    private List initializableNodes = new ArrayList();
    private List disposableNodes = new ArrayList();
    private List linkedBuilders = new ArrayList();
    private boolean canGetNode = false;
    private Map registeredNodes = new HashMap();

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.parentManager = manager;
    }

    public void recompose(ComponentManager manager) throws ComponentException {
        this.parentManager = manager;
    }

    public void setRoleManager(RoleManager rm) {
        this.parentRoleManager = rm;
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.configuration = config;
        this.languageName = config.getAttribute("name");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Configuring Builder for language : " + this.languageName);
        }
        this.fileName = config.getChild("file").getAttribute("name");
        this.namespace = config.getChild("namespace").getAttribute("uri", "");
        this.parameterElement = config.getChild("parameter").getAttribute("element", "parameter");
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    protected RoleManager createRoleManager() throws Exception {
        DefaultRoleManager roles = new DefaultRoleManager(this.parentRoleManager);
        LifecycleHelper.setupComponent((Object)roles, this.getLogger(), this.context, this.manager, this.parentRoleManager, this.configuration.getChild("roles"));
        return roles;
    }

    protected ComponentManager createComponentManager(Configuration tree) throws Exception {
        return this.parentManager;
    }

    protected ComponentSelector createBuilderSelector() throws Exception {
        ExtendedComponentSelector selector = new ExtendedComponentSelector(){

            protected String getComponentInstanceName() {
                return "node";
            }

            protected String getClassAttributeName() {
                return "builder";
            }
        };
        LifecycleHelper.setupComponent((Object)selector, this.getLogger(), this.context, this.manager, this.roleManager, this.configuration.getChild("nodes"));
        return selector;
    }

    public void setProcessor(ConcreteTreeProcessor processor) {
        this.processor = processor;
    }

    public ConcreteTreeProcessor getProcessor() {
        return this.processor;
    }

    public String getLanguage() {
        return this.languageName;
    }

    public String getParameterName() {
        return this.parameterElement;
    }

    public void registerNode(String name, ProcessingNode node) {
        this.registeredNodes.put(name, node);
    }

    public ProcessingNode getRegisteredNode(String name) {
        if (this.canGetNode) {
            return (ProcessingNode)this.registeredNodes.get(name);
        }
        throw new IllegalArgumentException("Categories are only available during buildNode()");
    }

    public ProcessingNodeBuilder createNodeBuilder(Configuration config) throws Exception {
        ProcessingNodeBuilder builder;
        String nodeName = config.getName();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating node builder for " + nodeName);
        }
        try {
            builder = (ProcessingNodeBuilder)this.builderSelector.select((Object)nodeName);
        }
        catch (ComponentException ce) {
            if (this.builderSelector.hasComponent((Object)nodeName)) {
                throw ce;
            }
            String msg = "Unknown element '" + nodeName + "' at " + config.getLocation();
            throw new ConfigurationException(msg);
        }
        if (builder instanceof Recomposable) {
            ((Recomposable)builder).recompose(this.manager);
        }
        builder.setBuilder(this);
        if (builder instanceof LinkedProcessingNodeBuilder) {
            this.linkedBuilders.add(builder);
        }
        return builder;
    }

    protected ProcessingNode createTree(Configuration tree) throws Exception {
        ProcessingNodeBuilder rootBuilder = this.createNodeBuilder(tree);
        return rootBuilder.buildNode(tree);
    }

    protected void linkNodes() throws Exception {
        Iterator iter = this.linkedBuilders.iterator();
        while (iter.hasNext()) {
            ((LinkedProcessingNodeBuilder)iter.next()).linkNode();
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ProcessingNode build(Source source) throws Exception {
        try {
            NamespacedSAXConfigurationHandler handler = new NamespacedSAXConfigurationHandler();
            SourceUtil.toSAX(source, (ContentHandler)handler);
            Configuration treeConfig = handler.getConfiguration();
            return this.build(treeConfig);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to load " + this.languageName + " from " + source.getURI(), e);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public ProcessingNode build(Configuration tree) throws Exception {
        this.roleManager = this.createRoleManager();
        this.manager = this.createComponentManager(tree);
        this.lifecycle = new LifecycleHelper(this.getLogger(), this.context, this.manager, this.roleManager, null);
        this.builderSelector = this.createBuilderSelector();
        this.canGetNode = false;
        VariableResolverFactory.setDisposableCollector(this.disposableNodes);
        ProcessingNode result = this.createTree(tree);
        this.canGetNode = true;
        this.linkNodes();
        Iterator iter = this.initializableNodes.iterator();
        while (iter.hasNext()) {
            ((Initializable)iter.next()).initialize();
        }
        return result;
    }

    public List getDisposableNodes() {
        return this.disposableNodes;
    }

    public ComponentManager getSitemapComponentManager() {
        return this.manager;
    }

    public ProcessingNode setupNode(ProcessingNode node, Configuration config) throws Exception {
        if (node instanceof AbstractProcessingNode) {
            ((AbstractProcessingNode)node).setLocation(config.getLocation());
        }
        this.lifecycle.setupComponent(node, false);
        if (node instanceof ParameterizableProcessingNode) {
            Map params = this.getParameters(config);
            ((ParameterizableProcessingNode)node).setParameters(params);
        }
        if (node instanceof Initializable) {
            this.initializableNodes.add(node);
        }
        if (node instanceof Disposable) {
            this.disposableNodes.add(node);
        }
        return node;
    }

    protected Map getParameters(Configuration config) throws ConfigurationException {
        Configuration[] children = config.getChildren(this.parameterElement);
        if (children.length == 0) {
            return new SitemapParameters.ExtendedHashMap(config);
        }
        SitemapParameters.ExtendedHashMap params = new SitemapParameters.ExtendedHashMap(config, children.length + 1);
        for (int i = 0; i < children.length; ++i) {
            Configuration child = children[i];
            String name = child.getAttribute("name");
            String value = child.getAttribute("value");
            try {
                params.put(VariableResolverFactory.getResolver(name, this.manager), VariableResolverFactory.getResolver(value, this.manager));
                continue;
            }
            catch (PatternException pe) {
                String msg = "Invalid pattern '" + value + "' at " + child.getLocation();
                throw new ConfigurationException(msg, (Throwable)((Object)pe));
            }
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTypeForStatement(Configuration statement, String role) throws ConfigurationException {
        String type = statement.getAttribute("type", null);
        ComponentSelector selector = null;
        try {
            try {
                selector = (ComponentSelector)this.manager.lookup(role);
            }
            catch (ComponentException ce) {
                String msg = "Cannot get component selector for '" + statement.getName() + "' at " + statement.getLocation();
                throw new ConfigurationException(msg, (Throwable)ce);
            }
            if (type == null && selector instanceof ExtendedComponentSelector) {
                type = ((ExtendedComponentSelector)selector).getDefaultHint();
            }
            if (type == null) {
                String msg = "No default type exists for '" + statement.getName() + "' at " + statement.getLocation();
                throw new ConfigurationException(msg);
            }
            if (!selector.hasComponent((Object)type)) {
                String msg = "Type '" + type + "' is not defined for '" + statement.getName() + "' at " + statement.getLocation();
                throw new ConfigurationException(msg);
            }
        }
        catch (Throwable throwable) {
            this.manager.release(selector);
            throw throwable;
        }
        this.manager.release((Component)selector);
        return type;
    }

    public void recycle() {
        this.lifecycle = null;
        this.initializableNodes.clear();
        this.linkedBuilders.clear();
        this.canGetNode = false;
        this.registeredNodes.clear();
        this.disposableNodes = new ArrayList();
        VariableResolverFactory.setDisposableCollector(null);
        this.processor = null;
        this.manager = null;
        this.roleManager = null;
    }

    public void dispose() {
        LifecycleHelper.dispose(this.builderSelector);
    }
}

