/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.environment.Environment;

public class FlowNode
extends AbstractProcessingNode
implements Composable,
Disposable {
    private ComponentManager manager;
    private String language;
    private Interpreter interpreter;
    private ComponentSelector interpreterSelector;

    public FlowNode(String language) {
        this.language = language;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        try {
            this.interpreterSelector = (ComponentSelector)manager.lookup(Interpreter.ROLE);
            this.interpreter = (Interpreter)this.interpreterSelector.select((Object)this.language);
            this.interpreter.setInterpreterID(this.location);
        }
        catch (ComponentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ComponentException(this.language, "FlowNode: Couldn't obtain a flow interpreter for '" + this.language + "' at " + this.getLocation(), (Throwable)e);
        }
    }

    public boolean invoke(Environment env, InvokeContext context) throws Exception {
        return true;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public void dispose() {
        if (this.manager != null) {
            if (this.interpreterSelector != null) {
                this.interpreterSelector.release((Component)this.interpreter);
                this.interpreter = null;
                this.manager.release((Component)this.interpreterSelector);
                this.interpreterSelector = null;
            }
            this.manager = null;
        }
    }
}

