/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment;

import java.util.Map;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;

public final class ObjectModelHelper {
    public static final String REQUEST_OBJECT = "request";
    public static final String RESPONSE_OBJECT = "response";
    public static final String CONTEXT_OBJECT = "context";
    public static final String EXPIRES_OBJECT = "expires";
    public static final String THROWABLE_OBJECT = "throwable";
    public static final String PARENT_CONTEXT = "parent-context";

    private ObjectModelHelper() {
    }

    public static final Request getRequest(Map objectModel) {
        return (Request)objectModel.get(REQUEST_OBJECT);
    }

    public static final Response getResponse(Map objectModel) {
        return (Response)objectModel.get(RESPONSE_OBJECT);
    }

    public static final Context getContext(Map objectModel) {
        return (Context)objectModel.get(CONTEXT_OBJECT);
    }

    public static final Long getExpires(Map objectModel) {
        return (Long)objectModel.get(EXPIRES_OBJECT);
    }

    public static final Throwable getThrowable(Map objectModel) {
        return (Throwable)objectModel.get(THROWABLE_OBJECT);
    }

    public static Cookie getCookie(Map objectModel, String cookieName, int cookieIndex) {
        boolean retrieveByName = false;
        boolean retrieveByIndex = false;
        boolean matchFound = false;
        int count = 0;
        Request request = ObjectModelHelper.getRequest(objectModel);
        Cookie currentCookie = null;
        if (cookieName != null) {
            retrieveByName = true;
        } else if (cookieIndex >= 0) {
            retrieveByIndex = true;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null && retrieveByName) {
            for (count = 0; count < cookies.length; ++count) {
                currentCookie = cookies[count];
                if (!currentCookie.getName().equals(cookieName)) continue;
                matchFound = true;
                break;
            }
        } else if (cookies != null && retrieveByIndex && cookies.length > cookieIndex) {
            currentCookie = cookies[cookieIndex];
            matchFound = true;
        }
        if (matchFound) {
            return currentCookie;
        }
        return null;
    }
}

