/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.i18n;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.i18n.Bundle;
import org.apache.cocoon.xml.ParamSaxBuffer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLResourceBundle
extends AbstractLogEnabled
implements Bundle,
Serviceable {
    public static final String NS = "http://apache.org/cocoon/i18n/2.0";
    public static final String EL_CATALOGUE = "catalogue";
    public static final String EL_MESSAGE = "message";
    public static final String AT_KEY = "key";
    private String name;
    private SourceValidity validity;
    private Locale locale;
    protected Bundle parent;
    protected HashMap values;
    protected ServiceManager manager;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void dispose() {
        this.manager = null;
    }

    public void init(String name, String sourceURL, Locale locale, Bundle parent) throws IOException, ProcessingException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Loading XML bundle: " + name + ", locale: " + locale);
        }
        this.name = name;
        this.locale = locale;
        this.parent = parent;
        this.values = new HashMap();
        this.load(sourceURL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void load(String sourceURL) throws IOException, ProcessingException, SAXException {
        SourceResolver resolver;
        block9: {
            Source source = null;
            resolver = null;
            try {
                block8: {
                    try {
                        int valid;
                        int n = valid = this.validity == null ? -1 : this.validity.isValid();
                        if (valid == 1) break block8;
                        resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                        source = resolver.resolveURI(sourceURL);
                        SourceValidity sourceValidity = source.getValidity();
                        if (valid != -1 && this.validity.isValid(sourceValidity) == 1) break block8;
                        HashMap values = new HashMap();
                        SourceUtil.toSAX(source, new SAXContentHandler(values));
                        this.validity = sourceValidity;
                        this.values = values;
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Loaded XML bundle: " + this.name + ", locale: " + this.locale);
                        }
                    }
                    catch (ServiceException e) {
                        throw new ProcessingException("Can't lookup source resolver", e);
                    }
                    catch (MalformedURLException e) {
                        throw new SourceNotFoundException("Invalid resource URL: " + sourceURL, (Throwable)e);
                    }
                }
                Object var8_9 = null;
                if (source == null) break block9;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (source != null) {
                    resolver.release(source);
                }
                this.manager.release(resolver);
                throw throwable;
            }
            resolver.release(source);
        }
        this.manager.release((Object)resolver);
    }

    public String getName() {
        return this.name;
    }

    public SourceValidity getValidity() {
        return this.validity;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object getObject(String key) {
        if (key == null) {
            return null;
        }
        Object value = this.values.get(key);
        if (value == null && this.parent != null) {
            value = this.parent.getObject(key);
        }
        return value;
    }

    public String getString(String key) {
        if (key == null) {
            return null;
        }
        Object value = this.values.get(key);
        if (value != null) {
            return value.toString();
        }
        if (this.parent != null) {
            return this.parent.getString(key);
        }
        return null;
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    public void update(String sourceURL) {
        try {
            this.load(sourceURL);
        }
        catch (Exception e) {
            this.getLogger().info("Resource update failed. " + this.name + ", locale: " + this.locale + " Exception: " + e);
        }
    }

    private static class SAXContentHandler
    implements ContentHandler {
        private Map values;
        private int state;
        private String namespace;
        private ParamSaxBuffer buffer;

        public SAXContentHandler(Map values) {
            this.values = values;
        }

        public void setDocumentLocator(Locator arg0) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        public void skippedEntity(String arg0) throws SAXException {
        }

        public void startElement(String ns, String localName, String qName, Attributes atts) throws SAXException {
            switch (this.state) {
                case 0: {
                    if (!"".equals(ns) && !XMLResourceBundle.NS.equals(ns)) {
                        throw new SAXException("Root element <catalogue> must be non-namespaced or in i18n namespace.");
                    }
                    if (!XMLResourceBundle.EL_CATALOGUE.equals(localName)) {
                        throw new SAXException("Root element must be <catalogue>.");
                    }
                    this.namespace = ns;
                    ++this.state;
                    break;
                }
                case 1: {
                    if (!XMLResourceBundle.EL_MESSAGE.equals(localName)) {
                        throw new SAXException("<catalogue> must contain <message> elements only.");
                    }
                    if (!this.namespace.equals(ns)) {
                        throw new SAXException("<message> element must be in '" + this.namespace + "' namespace.");
                    }
                    String key = atts.getValue(XMLResourceBundle.AT_KEY);
                    if (key == null) {
                        throw new SAXException("<message> must have 'key' attribute.");
                    }
                    this.buffer = new ParamSaxBuffer();
                    this.values.put(key, this.buffer);
                    ++this.state;
                    break;
                }
                case 2: {
                    this.buffer.startElement(ns, localName, qName, atts);
                    break;
                }
                default: {
                    throw new SAXException("Internal error: Invalid state");
                }
            }
        }

        public void endElement(String ns, String localName, String qName) throws SAXException {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    --this.state;
                    break;
                }
                case 2: {
                    if (this.namespace.equals(ns) && XMLResourceBundle.EL_MESSAGE.equals(localName)) {
                        this.buffer = null;
                        --this.state;
                        break;
                    }
                    this.buffer.endElement(ns, localName, qName);
                    break;
                }
                default: {
                    throw new SAXException("Internal error: Invalid state");
                }
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (this.buffer != null) {
                this.buffer.startPrefixMapping(prefix, uri);
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            if (this.buffer != null) {
                this.buffer.endPrefixMapping(prefix);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.buffer != null) {
                this.buffer.ignorableWhitespace(ch, start, length);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buffer != null) {
                this.buffer.characters(ch, start, length);
            }
        }
    }
}

