/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.selection;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.selection.AbstractSwitchSelector;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;

public abstract class AbstractRegexpSelector
extends AbstractSwitchSelector
implements Configurable,
ThreadSafe {
    protected Map patterns = new HashMap();

    protected AbstractRegexpSelector() {
    }

    public boolean select(String patternName, Object selectorContext) {
        if (selectorContext == null) {
            return false;
        }
        REProgram pattern = (REProgram)this.patterns.get(patternName);
        if (pattern == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("The specified pattern name \"" + patternName + "\" was not configured in this instance");
            }
            return false;
        }
        return new RE(pattern).match(selectorContext.toString());
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] patterns = configuration.getChildren("pattern");
        for (int x = 0; x < patterns.length; ++x) {
            String name = patterns[x].getAttribute("name");
            String pattern = patterns[x].getValue();
            this.patterns.put(name, this.compile(pattern));
        }
    }

    protected REProgram compile(String pattern) throws ConfigurationException {
        if (pattern == null) {
            throw new ConfigurationException("Null pattern");
        }
        if (pattern.length() == 0) {
            pattern = "^$";
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("The empty pattern string was rewritten to '^$' to match for empty strings.  If you intended to match all strings, please change your pattern to '.*'");
            }
        }
        try {
            RECompiler compiler = new RECompiler();
            REProgram program = compiler.compile(pattern);
            return program;
        }
        catch (RESyntaxException rse) {
            this.getLogger().debug("Failed to compile the pattern '" + pattern + "'", (Throwable)rse);
            throw new ConfigurationException(rse.getMessage(), (Throwable)rse);
        }
    }
}

