/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.transformation.MyFilter;
import org.apache.cocoon.transformation.helpers.IncludeCacheManager;
import org.apache.cocoon.transformation.helpers.IncludeCacheManagerSession;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class CIncludeTransformer
extends AbstractSAXTransformer
implements Disposable,
CacheableProcessingComponent {
    public static final String CINCLUDE_NAMESPACE_URI = "http://apache.org/cocoon/include/1.0";
    public static final String CINCLUDE_INCLUDE_ELEMENT = "include";
    public static final String CINCLUDE_INCLUDE_ELEMENT_SRC_ATTRIBUTE = "src";
    public static final String CINCLUDE_INCLUDE_ELEMENT_ELEMENT_ATTRIBUTE = "element";
    public static final String CINCLUDE_INCLUDE_ELEMENT_SELECT_ATTRIBUTE = "select";
    public static final String CINCLUDE_INCLUDE_ELEMENT_NS_ATTRIBUTE = "ns";
    public static final String CINCLUDE_INCLUDE_ELEMENT_PREFIX_ATTRIBUTE = "prefix";
    public static final String CINCLUDE_INCLUDE_ELEMENT_STRIP_ROOT_ATTRIBUTE = "strip-root";
    public static final String CINCLUDE_INCLUDEXML_ELEMENT = "includexml";
    public static final String CINCLUDE_INCLUDEXML_ELEMENT_IGNORE_ERRORS_ATTRIBUTE = "ignoreErrors";
    public static final String CINCLUDE_SRC_ELEMENT = "src";
    public static final String CINCLUDE_CONFIGURATION_ELEMENT = "configuration";
    public static final String CINCLUDE_PARAMETERS_ELEMENT = "parameters";
    public static final String CINCLUDE_PARAMETER_ELEMENT = "parameter";
    public static final String CINCLUDE_NAME_ELEMENT = "name";
    public static final String CINCLUDE_VALUE_ELEMENT = "value";
    public static final String CINCLUDE_CACHED_INCLUDE_ELEMENT = "cached-include";
    protected static final String CINCLUDE_CACHED_INCLUDE_PLACEHOLDER_ELEMENT = "cached-includep";
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_INCLUDE = 1;
    protected Parameters configurationParameters;
    protected SourceParameters resourceParameters;
    protected int state;
    protected IncludeCacheManager cacheManager;
    protected IncludeCacheManagerSession cachingSession;
    protected boolean compiling;
    protected IncludeXMLConsumer filter;
    protected XMLSerializer recorder;
    protected AttributesImpl srcAttributes = new AttributesImpl();
    protected boolean supportCaching;
    protected long startTime;

    public CIncludeTransformer() {
        this.defaultNamespaceURI = CINCLUDE_NAMESPACE_URI;
    }

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, source, parameters);
        this.state = 0;
        if (null != this.cacheManager) {
            this.cachingSession = this.cacheManager.getSession(this.parameters);
        }
        this.compiling = false;
        this.supportCaching = parameters.getParameterAsBoolean("support-caching", false);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting, session " + this.cachingSession);
            this.startTime = System.currentTimeMillis();
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        if (this.manager.hasService(IncludeCacheManager.ROLE)) {
            this.cacheManager = (IncludeCacheManager)this.manager.lookup(IncludeCacheManager.ROLE);
        } else {
            this.getLogger().warn("The cinclude transformer cannot find the IncludeCacheManager. Therefore caching is turned off for the include transformer.");
        }
    }

    public void dispose() {
        if (null != this.manager) {
            this.manager.release((Object)this.cacheManager);
            this.manager = null;
        }
    }

    public void recycle() {
        if (null != this.cachingSession) {
            this.cacheManager.terminateSession(this.cachingSession);
        }
        this.cachingSession = null;
        if (null != this.recorder) {
            this.manager.release((Object)this.recorder);
            this.recorder = null;
        }
        super.recycle();
        this.configurationParameters = null;
        this.resourceParameters = null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Finishing, time: " + (System.currentTimeMillis() - this.startTime));
            this.startTime = 0L;
        }
        this.filter = null;
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws ProcessingException, IOException, SAXException {
        if (name.equals(CINCLUDE_INCLUDE_ELEMENT)) {
            String stripRootValue = attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_STRIP_ROOT_ATTRIBUTE);
            boolean stripRoot = StringUtils.equals((String)stripRootValue, (String)"true");
            this.processCIncludeElement(attr.getValue("", "src"), attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_ELEMENT_ATTRIBUTE), attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_SELECT_ATTRIBUTE), attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_NS_ATTRIBUTE), attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_PREFIX_ATTRIBUTE), stripRoot, false);
        } else if (name.equals(CINCLUDE_INCLUDEXML_ELEMENT) && this.state == 0) {
            this.state = 1;
            String ignoreErrors = attr.getValue("", CINCLUDE_INCLUDEXML_ELEMENT_IGNORE_ERRORS_ATTRIBUTE);
            if (ignoreErrors == null || ignoreErrors.length() == 0) {
                ignoreErrors = "false";
            }
            this.stack.push(BooleanUtils.toBooleanObject((boolean)this.ignoreEmptyCharacters));
            this.stack.push(BooleanUtils.toBooleanObject((boolean)this.ignoreWhitespaces));
            this.stack.push(ignoreErrors);
            this.ignoreEmptyCharacters = false;
            this.ignoreWhitespaces = true;
        } else if (name.equals("src") && this.state == 1) {
            this.startTextRecording();
        } else if (name.equals(CINCLUDE_CONFIGURATION_ELEMENT) && this.state == 1) {
            this.stack.push("end");
        } else if (name.equals(CINCLUDE_PARAMETERS_ELEMENT) && this.state == 1) {
            this.stack.push("end");
        } else if (!name.equals(CINCLUDE_PARAMETER_ELEMENT) || this.state != 1) {
            if (name.equals(CINCLUDE_NAME_ELEMENT) && this.state == 1) {
                this.startTextRecording();
            } else if (name.equals(CINCLUDE_VALUE_ELEMENT) && this.state == 1) {
                this.startSerializedXMLRecording(XMLUtils.createPropertiesForXML(true));
            } else if (name.equals(CINCLUDE_CACHED_INCLUDE_ELEMENT)) {
                String src = this.processCIncludeElement(attr.getValue("", "src"), null, null, null, null, false, this.cacheManager != null);
                if (this.compiling) {
                    this.srcAttributes.addAttribute("", "src", "src", "CDATA", src);
                    super.startTransformingElement(uri, CINCLUDE_CACHED_INCLUDE_PLACEHOLDER_ELEMENT, raw + "p", this.srcAttributes);
                    this.srcAttributes.clear();
                }
            } else {
                super.startTransformingElement(uri, name, raw, attr);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void endTransformingElement(String uri, String name, String raw) throws ProcessingException, IOException, SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String processCIncludeElement(String src, String element, String select, String ns, String prefix, boolean stripRoot, boolean cache) throws SAXException, IOException {
        block29: {
            if (src == null) {
                throw new SAXException("Missing 'src' attribute on cinclude:include element");
            }
            if (element == null) {
                element = "";
            }
            if (select == null) {
                select = "";
            }
            if (ns == null) {
                ns = "";
            }
            if (prefix == null) {
                prefix = "";
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Processing include element: src=" + src + ", element=" + element + ", select=" + select + ", ns=" + ns + ", prefix=" + prefix + ", stripRoot=" + stripRoot + ", caching=" + cache);
            }
            if (cache) {
                src = this.cacheManager.load(src, this.cachingSession);
                if (this.cachingSession.isParallel() && !this.cachingSession.isPreemptive()) {
                    if (!this.compiling) {
                        this.compiling = true;
                        this.startCompiledXMLRecording();
                    }
                } else {
                    this.cacheManager.stream(src, this.cachingSession, this.filter);
                }
                return src;
            }
            if (!"".equals(element)) {
                AttributesImpl attrs = new AttributesImpl();
                if (!ns.equals("")) {
                    super.startPrefixMapping(prefix, ns);
                }
                super.startElement(ns, element, !ns.equals("") && !prefix.equals("") ? prefix + ":" + element : element, attrs);
            }
            Source source = null;
            try {
                source = this.resolver.resolveURI(src);
                if (!"".equals(select)) {
                    DOMParser parser = null;
                    XPathProcessor processor = null;
                    try {
                        parser = (DOMParser)this.manager.lookup(DOMParser.ROLE);
                        processor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
                        InputSource input = SourceUtil.getInputSource(source);
                        Document document = parser.parseDocument(input);
                        NodeList list = processor.selectNodeList((Node)document, select);
                        int length = list.getLength();
                        for (int i = 0; i < length; ++i) {
                            IncludeXMLConsumer.includeNode(list.item(i), (ContentHandler)((Object)this), (LexicalHandler)((Object)this));
                        }
                        Object var17_21 = null;
                    }
                    catch (Throwable throwable) {
                        Object var17_22 = null;
                        this.manager.release((Object)parser);
                        this.manager.release((Object)processor);
                        throw throwable;
                    }
                    this.manager.release((Object)parser);
                    this.manager.release((Object)processor);
                    {
                        break block29;
                    }
                }
                String mimeType = null;
                if (null != this.configurationParameters) {
                    mimeType = this.configurationParameters.getParameter("mime-type", mimeType);
                }
                if (this.compiling) {
                    SourceUtil.toSAX(source, mimeType, (ContentHandler)((Object)new IncludeXMLConsumer(this.contentHandler, this.lexicalHandler)));
                } else {
                    this.filter.setIgnoreRootElement(stripRoot);
                    SourceUtil.toSAX(source, mimeType, (ContentHandler)((Object)this.filter));
                }
            }
            catch (SourceException se) {
                throw new SAXException("Exception in CIncludeTransformer", (Exception)((Object)se));
            }
            catch (IOException e) {
                throw new SAXException("CIncludeTransformer could not read resource", e);
            }
            catch (ProcessingException e) {
                throw new SAXException("Exception in CIncludeTransformer", (Exception)((Object)e));
            }
            catch (ServiceException e) {
                throw new SAXException((Exception)((Object)e));
            }
            finally {
                this.resolver.release(source);
            }
        }
        if (!"".equals(element)) {
            super.endElement(ns, element, !ns.equals("") && !prefix.equals("") ? prefix + ":" + element : element);
            if (!ns.equals("")) {
                super.endPrefixMapping(prefix);
            }
        }
        return src;
    }

    protected void startCompiledXMLRecording() throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN startCompiledXMLRecording");
        }
        try {
            this.recorder = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
            this.addRecorder(this.recorder);
        }
        catch (ServiceException ce) {
            throw new SAXException("Unable to lookup xml serializer for compiling xml.", (Exception)((Object)ce));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END startCompiledXMLRecording");
        }
    }

    protected Object endCompiledXMLRecording() throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN endCompiledXMLRecording");
        }
        XMLSerializer recorder = (XMLSerializer)this.removeRecorder();
        Object text = recorder.getSAXFragment();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END endCompiledXMLRecording text=" + text);
        }
        return text;
    }

    public void startDocument() throws SAXException {
        this.filter = new MyFilter(this.xmlConsumer, this);
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        if (this.compiling) {
            Object compiledXML = this.endCompiledXMLRecording();
            XMLDeserializer deserializer = null;
            try {
                deserializer = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                deserializer.setConsumer(this.filter);
                deserializer.deserialize(compiledXML);
            }
            catch (ServiceException ce) {
                throw new SAXException("Unable to lookup xml deserializer.", (Exception)((Object)ce));
            }
            finally {
                this.manager.release((Object)deserializer);
            }
        }
        super.endDocument();
    }

    public Serializable getKey() {
        if (this.supportCaching && null != this.cacheManager && this.cachingSession.getExpires() > 0L) {
            return "1";
        }
        return null;
    }

    public SourceValidity getValidity() {
        if (this.supportCaching && null != this.cacheManager && this.cachingSession.getExpires() > 0L && !this.cachingSession.isPurging()) {
            return this.cachingSession.getExpiresValidity();
        }
        return null;
    }
}

