/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.socket;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.apache.altrmi.server.impl.AbstractServer;
import org.apache.altrmi.server.impl.AbstractServerStreamReadWriter;
import org.apache.altrmi.server.impl.adapters.InvocationHandlerAdapter;
import org.apache.altrmi.server.impl.socket.SocketStreamServerConnection;

public abstract class AbstractPartialSocketStreamServer
extends AbstractServer {
    public AbstractPartialSocketStreamServer() {
        this(new InvocationHandlerAdapter());
    }

    public AbstractPartialSocketStreamServer(InvocationHandlerAdapter invocationHandlerAdapter) {
        super(invocationHandlerAdapter);
    }

    public void handleConnection(Socket socket) {
        try {
            socket.setSoTimeout(36000);
        }
        catch (SocketException se) {
            this.getServerMonitor().connectionProblem(this.getClass(), "AbstractPartialSocketStreamServer.handleConnection(): Some error during socket handling", (IOException)se);
        }
        try {
            if (this.getState() == 303) {
                AbstractServerStreamReadWriter ssrw = this.createServerStreamReadWriter();
                ssrw.setStreams(socket.getInputStream(), socket.getOutputStream(), socket);
                SocketStreamServerConnection sssc = new SocketStreamServerConnection(this, socket, ssrw);
                sssc.setServerMonitor(this.getServerMonitor());
                sssc.run();
            }
        }
        catch (IOException ioe) {
            this.getServerMonitor().connectionProblem(this.getClass(), "AbstractPartialSocketStreamServer.handleConnection(): Some problem connecting client via sockets: ", ioe);
        }
    }

    protected abstract AbstractServerStreamReadWriter createServerStreamReadWriter();

    public void start() {
        this.setState(303);
    }

    public void stop() {
        this.setState(101);
        this.killAllConnections();
        this.setState(404);
    }
}

