/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.ojb.components;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.ojb.broker.accesslayer.ConnectionFactory;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;

public class ConnectionFactoryImpl
implements Component,
ThreadSafe,
Serviceable,
Disposable,
ConnectionFactory {
    private static ServiceManager manager;
    private static ServiceSelector datasources;

    public void service(ServiceManager manager) throws ServiceException {
        ConnectionFactoryImpl.manager = manager;
        datasources = (ServiceSelector)manager.lookup(DataSourceComponent.ROLE + "Selector");
    }

    public void dispose() {
        if (manager != null) {
            manager.release((Object)datasources);
            datasources = null;
            manager = null;
        }
    }

    public Connection lookupConnection(JdbcConnectionDescriptor conDesc) throws LookupException {
        if (manager == null) {
            throw new LookupException("ConnectionFactoryImpl is not initialized! Please check your cocoon.xconf");
        }
        try {
            return ((DataSourceComponent)datasources.select((Object)conDesc.getJcdAlias())).getConnection();
        }
        catch (ServiceException e) {
            throw new LookupException("Cannot lookup DataSource " + conDesc.getJcdAlias(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new LookupException("Cannot get connection from DataSource " + conDesc.getJcdAlias(), (Throwable)e);
        }
    }

    public void releaseConnection(JdbcConnectionDescriptor conDesc, Connection con) {
        try {
            con.close();
        }
        catch (SQLException e) {
            throw new CascadingRuntimeException("Cannot release SQL Connection to DataSource", (Throwable)e);
        }
    }

    public void releaseAllResources() {
    }
}

