/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms;

import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.forms.CacheManager;
import org.apache.cocoon.forms.FormManager;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.FormDefinition;
import org.apache.cocoon.forms.formmodel.FormDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilder;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.forms.util.SimpleServiceSelector;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class DefaultFormManager
extends AbstractLogEnabled
implements FormManager,
Contextualizable,
ThreadSafe,
Serviceable,
Disposable,
Configurable,
Component,
Initializable {
    protected static final String PREFIX = "CocoonForm:";
    protected ServiceManager manager;
    protected Configuration configuration;
    protected SimpleServiceSelector widgetDefinitionBuilderSelector;
    protected CacheManager cacheManager;
    private Context avalonContext;

    public void contextualize(Context context) throws ContextException {
        this.avalonContext = context;
    }

    public Context getAvalonContext() {
        return this.avalonContext;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.cacheManager = (CacheManager)manager.lookup(CacheManager.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    public void initialize() throws Exception {
        this.widgetDefinitionBuilderSelector = new SimpleServiceSelector("widget", WidgetDefinitionBuilder.class);
        this.widgetDefinitionBuilderSelector.service(new ServiceManager(){
            final String WIDGET_DEFINITION_BUILDER_SELECTOR_ROLE = (class$org$apache$cocoon$forms$formmodel$WidgetDefinitionBuilder == null ? (class$org$apache$cocoon$forms$formmodel$WidgetDefinitionBuilder = DefaultFormManager.class$("org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilder")) : class$org$apache$cocoon$forms$formmodel$WidgetDefinitionBuilder).getName() + "Selector";

            public Object lookup(String name) throws ServiceException {
                if (this.WIDGET_DEFINITION_BUILDER_SELECTOR_ROLE.equals(name)) {
                    return DefaultFormManager.this.widgetDefinitionBuilderSelector;
                }
                return DefaultFormManager.this.manager.lookup(name);
            }

            public boolean hasService(String name) {
                if (this.WIDGET_DEFINITION_BUILDER_SELECTOR_ROLE.equals(name)) {
                    return true;
                }
                return DefaultFormManager.this.manager.hasService(name);
            }

            public void release(Object service) {
                if (service != DefaultFormManager.this.widgetDefinitionBuilderSelector) {
                    DefaultFormManager.this.manager.release(service);
                }
            }
        });
        this.widgetDefinitionBuilderSelector.configure(this.configuration.getChild("widgets"));
    }

    public Form createForm(Source source) throws Exception {
        FormDefinition formDefinition = this.getFormDefinition(source);
        Form form = (Form)formDefinition.createInstance();
        form.initialize();
        return form;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Form createForm(String uri) throws Exception {
        Form form;
        SourceResolver sourceResolver;
        block4: {
            sourceResolver = null;
            Source source = null;
            try {
                Form form2;
                sourceResolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                source = sourceResolver.resolveURI(uri);
                form = form2 = this.createForm(source);
                Object var7_6 = null;
                if (source == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_7 = null;
                    if (source != null) {
                        sourceResolver.release(source);
                    }
                    if (sourceResolver == null) break block5;
                    this.manager.release((Object)sourceResolver);
                }
                throw throwable;
            }
            sourceResolver.release(source);
        }
        if (sourceResolver != null) {
            this.manager.release((Object)sourceResolver);
        }
        return form;
    }

    public Form createForm(Element formElement) throws Exception {
        Form form = (Form)this.getFormDefinition(formElement).createInstance();
        form.initialize();
        return form;
    }

    public FormDefinition createFormDefinition(Element formElement) throws Exception {
        return this.getFormDefinition(formElement);
    }

    public FormDefinition getFormDefinition(Source source) throws Exception {
        FormDefinition formDefinition = (FormDefinition)this.cacheManager.get(source, PREFIX);
        if (formDefinition == null) {
            Document formDocument;
            try {
                InputSource inputSource = new InputSource(source.getInputStream());
                inputSource.setSystemId(source.getURI());
                formDocument = DomHelper.parse(inputSource, this.manager);
            }
            catch (Exception e) {
                throw new CascadingException("Could not parse form definition from " + source.getURI(), (Throwable)e);
            }
            Element formElement = formDocument.getDocumentElement();
            formDefinition = this.getFormDefinition(formElement);
            this.cacheManager.set(formDefinition, source, PREFIX);
        }
        return formDefinition;
    }

    public FormDefinition getFormDefinition(Element formElement) throws Exception {
        if (!formElement.getLocalName().equals("form") && !"http://apache.org/cocoon/forms/1.0#definition".equals(formElement.getNamespaceURI())) {
            throw new Exception("Expected a Cocoon Forms form element at " + DomHelper.getLocation(formElement));
        }
        FormDefinitionBuilder formDefinitionBuilder = (FormDefinitionBuilder)this.widgetDefinitionBuilderSelector.select("form");
        return (FormDefinition)formDefinitionBuilder.buildWidgetDefinition(formElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormDefinition createFormDefinition(String uri) throws Exception {
        Document formDocument;
        SourceResolver sourceResolver;
        block7: {
            sourceResolver = null;
            Source source = null;
            formDocument = null;
            try {
                sourceResolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                source = sourceResolver.resolveURI(uri);
                try {
                    InputSource inputSource = new InputSource(source.getInputStream());
                    inputSource.setSystemId(source.getURI());
                    formDocument = DomHelper.parse(inputSource, this.manager);
                }
                catch (Exception e) {
                    throw new CascadingException("Could not parse form definition from " + source.getURI(), (Throwable)e);
                }
                Object var7_7 = null;
                if (source == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (source != null) {
                    sourceResolver.release(source);
                }
                if (sourceResolver != null) {
                    this.manager.release((Object)sourceResolver);
                }
                throw throwable;
            }
            sourceResolver.release(source);
        }
        if (sourceResolver != null) {
            this.manager.release((Object)sourceResolver);
        }
        Element formElement = formDocument.getDocumentElement();
        return this.getFormDefinition(formElement);
    }

    public void dispose() {
        if (this.widgetDefinitionBuilderSelector != null) {
            this.widgetDefinitionBuilderSelector.dispose();
            this.widgetDefinitionBuilderSelector = null;
        }
        this.manager.release((Object)this.cacheManager);
        this.cacheManager = null;
        this.manager = null;
    }
}

