/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.HashMap;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.forms.binding.Binding;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.commons.jxpath.JXPathContext;

public class ComposedJXPathBindingBase
extends JXPathBindingBase {
    private final JXPathBindingBase[] subBindings;

    public ComposedJXPathBindingBase(JXPathBindingBuilderBase.CommonAttributes commonAtts, JXPathBindingBase[] childBindings) {
        super(commonAtts);
        this.subBindings = childBindings;
        if (this.subBindings != null) {
            for (int i = 0; i < this.subBindings.length; ++i) {
                this.subBindings[i].setParent(this);
            }
        }
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        if (this.subBindings != null) {
            for (int i = 0; i < this.subBindings.length; ++i) {
                this.subBindings[i].enableLogging(logger);
            }
        }
    }

    public Binding getClass(String id) {
        if (this.classes == null) {
            this.classes = new HashMap();
            if (this.subBindings != null) {
                for (int i = 0; i < this.subBindings.length; ++i) {
                    JXPathBindingBase binding = this.subBindings[i];
                    String bindingId = binding.getId();
                    if (bindingId == null) continue;
                    this.classes.put(bindingId, binding);
                }
            }
        }
        return super.getClass(id);
    }

    public JXPathBindingBase[] getChildBindings() {
        return this.subBindings;
    }

    public void doLoad(Widget frmModel, JXPathContext jxpc) throws BindingException {
        if (this.subBindings != null) {
            int size = this.subBindings.length;
            for (int i = 0; i < size; ++i) {
                this.subBindings[i].loadFormFromModel(frmModel, jxpc);
            }
        }
    }

    public void doSave(Widget frmModel, JXPathContext jxpc) throws BindingException {
        if (this.subBindings != null) {
            int size = this.subBindings.length;
            for (int i = 0; i < size; ++i) {
                this.subBindings[i].saveFormToModel(frmModel, jxpc);
            }
        }
    }
}

