/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.forms.CacheManager;
import org.apache.cocoon.forms.binding.Binding;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.BindingManager;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.datatype.DatatypeManager;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.forms.util.SimpleServiceSelector;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class JXPathBindingManager
extends AbstractLogEnabled
implements BindingManager,
Contextualizable,
Serviceable,
Disposable,
Initializable,
Configurable,
ThreadSafe {
    private static final String PREFIX = "CocoonFormBinding:";
    private ServiceManager manager;
    private DatatypeManager datatypeManager;
    private Configuration configuration;
    private SimpleServiceSelector bindingBuilderSelector;
    private CacheManager cacheManager;
    private Context avalonContext;

    public void contextualize(Context context) throws ContextException {
        this.avalonContext = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.datatypeManager = (DatatypeManager)manager.lookup(DatatypeManager.ROLE);
        this.cacheManager = (CacheManager)manager.lookup(CacheManager.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    public void initialize() throws Exception {
        this.bindingBuilderSelector = new SimpleServiceSelector("binding", JXPathBindingBuilderBase.class);
        LifecycleHelper.setupComponent((Object)((Object)this.bindingBuilderSelector), (Logger)this.getLogger(), (Context)this.avalonContext, (ServiceManager)this.manager, (Configuration)this.configuration.getChild("bindings"));
    }

    public Binding createBinding(Source source) throws BindingException {
        Binding binding = (Binding)this.cacheManager.get(source, PREFIX);
        if (binding == null) {
            try {
                InputSource is = new InputSource(source.getInputStream());
                is.setSystemId(source.getURI());
                Document doc = DomHelper.parse(is, this.manager);
                Element rootElm = doc.getDocumentElement();
                if ("http://apache.org/cocoon/forms/1.0#binding".equals(rootElm.getNamespaceURI())) {
                    binding = this.getBuilderAssistant().getBindingForConfigurationElement(rootElm);
                    ((JXPathBindingBase)binding).enableLogging(this.getLogger());
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Creation of new binding finished. " + binding);
                    }
                } else if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Root Element of said binding file is in wrong namespace.");
                }
                this.cacheManager.set(binding, source, PREFIX);
            }
            catch (BindingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BindingException("Error creating binding from " + source.getURI(), e);
            }
        }
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binding createBinding(String bindingURI) throws BindingException {
        Binding binding;
        SourceResolver sourceResolver;
        block6: {
            sourceResolver = null;
            Source source = null;
            try {
                try {
                    sourceResolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                    source = sourceResolver.resolveURI(bindingURI);
                }
                catch (Exception e) {
                    throw new BindingException("Error resolving binding source: " + bindingURI);
                }
                binding = this.createBinding(source);
                Object var6_6 = null;
                if (source == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var6_7 = null;
                    if (source != null) {
                        sourceResolver.release(source);
                    }
                    if (sourceResolver == null) break block7;
                    this.manager.release((Object)sourceResolver);
                }
                throw throwable;
            }
            sourceResolver.release(source);
        }
        if (sourceResolver != null) {
            this.manager.release((Object)sourceResolver);
        }
        return binding;
    }

    private Assistant getBuilderAssistant() {
        return new Assistant();
    }

    public void dispose() {
        if (this.bindingBuilderSelector != null) {
            this.bindingBuilderSelector.dispose();
            this.bindingBuilderSelector = null;
        }
        this.manager.release((Object)this.datatypeManager);
        this.datatypeManager = null;
        this.manager.release((Object)this.cacheManager);
        this.cacheManager = null;
        this.manager = null;
    }

    public class Assistant {
        private JXPathBindingBuilderBase getBindingBuilder(String bindingType) throws BindingException {
            try {
                return (JXPathBindingBuilderBase)JXPathBindingManager.this.bindingBuilderSelector.select(bindingType);
            }
            catch (ServiceException e) {
                throw new BindingException("Cannot handle binding element with name \"" + bindingType + "\".", (Exception)((Object)e));
            }
        }

        public JXPathBindingBase getBindingForConfigurationElement(Element configElm) throws BindingException {
            String bindingType = configElm.getLocalName();
            JXPathBindingBuilderBase bindingBuilder = this.getBindingBuilder(bindingType);
            JXPathBindingBase childBinding = bindingBuilder.buildBinding(configElm, this);
            return childBinding;
        }

        public JXPathBindingBase[] makeChildBindings(Element parentElement) throws BindingException {
            Element[] childElements;
            if (parentElement != null && (childElements = DomHelper.getChildElements(parentElement, "http://apache.org/cocoon/forms/1.0#binding")).length > 0) {
                JXPathBindingBase[] childBindings = new JXPathBindingBase[childElements.length];
                for (int i = 0; i < childElements.length; ++i) {
                    childBindings[i] = this.getBindingForConfigurationElement(childElements[i]);
                }
                return childBindings;
            }
            return null;
        }

        public DatatypeManager getDatatypeManager() {
            return JXPathBindingManager.this.datatypeManager;
        }

        public ServiceManager getServiceManager() {
            return JXPathBindingManager.this.manager;
        }
    }
}

