/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.Locale;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.binding.JXPathBindingManager;
import org.apache.cocoon.forms.binding.MultiValueJXPathBinding;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.i18n.I18nUtils;
import org.w3c.dom.Element;

public class MultiValueJXPathBindingBuilder
extends JXPathBindingBuilderBase {
    public JXPathBindingBase buildBinding(Element bindingElem, JXPathBindingManager.Assistant assistant) throws BindingException {
        try {
            JXPathBindingBuilderBase.CommonAttributes commonAtts = JXPathBindingBuilderBase.getCommonAttributes(bindingElem);
            String multiValueId = DomHelper.getAttribute(bindingElem, "id");
            String parentPath = DomHelper.getAttribute(bindingElem, "parent-path");
            String rowPath = DomHelper.getAttribute(bindingElem, "row-path");
            Element updateWrapElement = DomHelper.getChildElement(bindingElem, "http://apache.org/cocoon/forms/1.0#binding", "on-update");
            JXPathBindingBase[] updateBindings = assistant.makeChildBindings(updateWrapElement);
            Convertor convertor = null;
            Locale convertorLocale = Locale.US;
            Element convertorEl = DomHelper.getChildElement(bindingElem, "http://apache.org/cocoon/forms/1.0#definition", "convertor");
            if (convertorEl != null) {
                String datatype = DomHelper.getAttribute(convertorEl, "datatype");
                String localeStr = convertorEl.getAttribute("locale");
                if (localeStr != null && !localeStr.equals("")) {
                    convertorLocale = I18nUtils.parseLocale((String)localeStr);
                }
                convertor = assistant.getDatatypeManager().createConvertor(datatype, convertorEl);
            }
            return new MultiValueJXPathBinding(commonAtts, multiValueId, parentPath, rowPath, updateBindings, convertor, convertorLocale);
        }
        catch (BindingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException("Error building multi value binding defined at " + DomHelper.getLocation(bindingElem), e);
        }
    }
}

