/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.binding.JXPathBindingManager;
import org.apache.cocoon.forms.binding.RepeaterJXPathBinding;
import org.apache.cocoon.forms.binding.ValueJXPathBinding;
import org.apache.cocoon.forms.util.DomHelper;
import org.w3c.dom.Element;

public class RepeaterJXPathBindingBuilder
extends JXPathBindingBuilderBase {
    public JXPathBindingBase buildBinding(Element bindingElm, JXPathBindingManager.Assistant assistant) throws BindingException {
        try {
            JXPathBindingBuilderBase.CommonAttributes commonAtts = JXPathBindingBuilderBase.getCommonAttributes(bindingElm);
            String repeaterId = DomHelper.getAttribute(bindingElm, "id");
            String parentPath = DomHelper.getAttribute(bindingElm, "parent-path");
            String rowPath = DomHelper.getAttribute(bindingElm, "row-path");
            String rowPathForInsert = DomHelper.getAttribute(bindingElm, "row-path-insert", rowPath);
            Element childWrapElement = DomHelper.getChildElement(bindingElm, "http://apache.org/cocoon/forms/1.0#binding", "on-bind");
            if (childWrapElement == null) {
                throw new BindingException("RepeaterBinding misses '<on-bind>' child definition. " + DomHelper.getLocation(bindingElm));
            }
            JXPathBindingBase[] childBindings = assistant.makeChildBindings(childWrapElement);
            Element deleteWrapElement = DomHelper.getChildElement(bindingElm, "http://apache.org/cocoon/forms/1.0#binding", "on-delete-row");
            JXPathBindingBase[] deleteBindings = null;
            if (deleteWrapElement != null) {
                deleteBindings = assistant.makeChildBindings(deleteWrapElement);
            }
            Element insertWrapElement = DomHelper.getChildElement(bindingElm, "http://apache.org/cocoon/forms/1.0#binding", "on-insert-row");
            JXPathBindingBase insertBinding = null;
            if (insertWrapElement != null) {
                insertBinding = assistant.makeChildBindings(insertWrapElement)[0];
            }
            Element identityWrapElement = DomHelper.getChildElement(bindingElm, "http://apache.org/cocoon/forms/1.0#binding", "identity");
            JXPathBindingBase[] identityBinding = null;
            if (identityWrapElement != null && (identityBinding = assistant.makeChildBindings(identityWrapElement)) != null) {
                for (int i = 0; i < identityBinding.length; ++i) {
                    if (identityBinding[i] instanceof ValueJXPathBinding) continue;
                    throw new BindingException("Error building repeater binding defined at " + DomHelper.getLocation(bindingElm) + ": Only value binding (i.e. fb:value) " + "can be used inside fb:identity at the moment. You can read " + "http://marc.theaimsgroup.com/?l=xml-cocoon-dev&m=107906438632484&w=4" + " if you want to know more on this.");
                }
            }
            RepeaterJXPathBinding repeaterBinding = new RepeaterJXPathBinding(commonAtts, repeaterId, parentPath, rowPath, rowPathForInsert, childBindings, insertBinding, deleteBindings, identityBinding);
            return repeaterBinding;
        }
        catch (BindingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException("Error building repeater binding defined at " + DomHelper.getLocation(bindingElm), e);
        }
    }
}

