/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import java.util.Locale;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.DynamicSelectionList;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.datatype.SelectionListBuilder;
import org.apache.cocoon.forms.datatype.StaticSelectionList;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.datatype.convertor.DefaultFormatCache;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultSelectionListBuilder
implements SelectionListBuilder,
Serviceable {
    private ServiceManager serviceManager;

    public void service(ServiceManager manager) throws ServiceException {
        this.serviceManager = manager;
    }

    public SelectionList build(Element selectionListElement, Datatype datatype) throws Exception {
        SelectionList selectionList;
        String src = selectionListElement.getAttribute("src");
        if (src.length() > 0) {
            boolean dynamic = DomHelper.getAttributeAsBoolean(selectionListElement, "dynamic", false);
            if (!dynamic) {
                selectionListElement = this.readSelectionList(src);
                selectionList = this.buildStaticList(selectionListElement, datatype);
            } else {
                selectionList = new DynamicSelectionList(datatype, src, this.serviceManager);
            }
        } else {
            selectionList = this.buildStaticList(selectionListElement, datatype);
        }
        return selectionList;
    }

    private SelectionList buildStaticList(Element selectionListElement, Datatype datatype) throws Exception {
        StaticSelectionList selectionList = new StaticSelectionList(datatype);
        Convertor convertor = null;
        DefaultFormatCache formatCache = new DefaultFormatCache();
        NodeList children = selectionListElement.getChildNodes();
        int i = 0;
        while (children.item(i) != null) {
            Node node = children.item(i);
            if (convertor == null && node instanceof Element && "http://apache.org/cocoon/forms/1.0#definition".equals(node.getNamespaceURI()) && "convertor".equals(node.getLocalName())) {
                Element convertorConfigElement = (Element)node;
                try {
                    convertor = datatype.getBuilder().buildConvertor(convertorConfigElement);
                }
                catch (Exception e) {
                    throw new SAXException("Error building convertor from convertor configuration embedded in selection list XML.", e);
                }
            } else if (node instanceof Element && "http://apache.org/cocoon/forms/1.0#definition".equals(node.getNamespaceURI()) && "item".equals(node.getLocalName())) {
                Object value;
                Element element;
                String stringValue;
                if (convertor == null) {
                    convertor = datatype.getConvertor();
                }
                if ("".equals(stringValue = (element = (Element)node).getAttribute("value"))) {
                    value = null;
                } else {
                    ConversionResult conversionResult = convertor.convertFromString(stringValue, Locale.US, formatCache);
                    if (!conversionResult.isSuccessful()) {
                        throw new Exception("Could not convert the value \"" + stringValue + "\" to the type " + datatype.getDescriptiveName() + ", defined at " + DomHelper.getLocation(element));
                    }
                    value = conversionResult.getResult();
                }
                XMLizable label = null;
                Element labelEl = DomHelper.getChildElement(element, "http://apache.org/cocoon/forms/1.0#definition", "label");
                if (labelEl != null) {
                    label = DomHelper.compileElementContent(labelEl);
                }
                selectionList.addItem(value, label);
            }
            ++i;
        }
        return selectionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element readSelectionList(String src) throws Exception {
        Element element;
        block4: {
            SourceResolver resolver;
            block5: {
                resolver = null;
                Source source = null;
                try {
                    resolver = (SourceResolver)this.serviceManager.lookup(SourceResolver.ROLE);
                    source = resolver.resolveURI(src);
                    InputSource inputSource = new InputSource(source.getInputStream());
                    inputSource.setSystemId(source.getURI());
                    Document document = DomHelper.parse(inputSource, this.serviceManager);
                    Element selectionListElement = document.getDocumentElement();
                    if (!"http://apache.org/cocoon/forms/1.0#definition".equals(selectionListElement.getNamespaceURI()) || !"selection-list".equals(selectionListElement.getLocalName())) {
                        throw new Exception("Expected a fd:selection-list element at " + DomHelper.getLocation(selectionListElement));
                    }
                    element = selectionListElement;
                    Object var9_8 = null;
                    if (resolver == null) break block4;
                    if (source == null) break block5;
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var9_9 = null;
                        if (resolver == null) break block6;
                        if (source != null) {
                            resolver.release(source);
                        }
                        this.serviceManager.release((Object)resolver);
                    }
                    throw throwable;
                }
                resolver.release(source);
            }
            this.serviceManager.release((Object)resolver);
        }
        return element;
    }
}

