/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.typeimpl;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.forms.datatype.DatatypeBuilder;
import org.apache.cocoon.forms.datatype.DatatypeManager;
import org.apache.cocoon.forms.datatype.ValidationRule;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.datatype.convertor.ConvertorBuilder;
import org.apache.cocoon.forms.datatype.typeimpl.AbstractDatatype;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.forms.util.SimpleServiceSelector;
import org.w3c.dom.Element;

public abstract class AbstractDatatypeBuilder
extends AbstractLogEnabled
implements DatatypeBuilder,
Serviceable,
Configurable,
Contextualizable {
    protected ServiceManager serviceManager;
    private SimpleServiceSelector convertorBuilders;
    private String defaultConvertorHint;
    private Convertor plainConvertor;
    private Context context;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.serviceManager = serviceManager;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        ConvertorBuilder plainConvertorBuilder;
        this.convertorBuilders = new SimpleServiceSelector("convertor", ConvertorBuilder.class);
        try {
            this.convertorBuilders.enableLogging(this.getLogger());
            this.convertorBuilders.contextualize(this.context);
            this.convertorBuilders.service(this.serviceManager);
        }
        catch (Exception e) {
            throw new ConfigurationException("Error setting up convertor builder selector.", (Throwable)e);
        }
        Configuration convertorsConf = configuration.getChild("convertors");
        this.convertorBuilders.configure(convertorsConf);
        this.defaultConvertorHint = convertorsConf.getAttribute("default");
        String plainConvertorHint = convertorsConf.getAttribute("plain");
        try {
            plainConvertorBuilder = (ConvertorBuilder)this.convertorBuilders.select(plainConvertorHint);
        }
        catch (ServiceException e) {
            throw new ConfigurationException("Convertor defined in plain attribute unavailable.", (Throwable)e);
        }
        try {
            this.plainConvertor = plainConvertorBuilder.build(null);
        }
        catch (Exception e) {
            throw new ConfigurationException("Error create plain convertor.", (Throwable)e);
        }
    }

    public void buildConvertor(Element datatypeEl, AbstractDatatype datatype) throws Exception {
        Element convertorEl = DomHelper.getChildElement(datatypeEl, "http://apache.org/cocoon/forms/1.0#definition", "convertor", false);
        Convertor convertor = this.buildConvertor(convertorEl);
        datatype.setConvertor(convertor);
    }

    public Convertor buildConvertor(Element convertorEl) throws Exception {
        String type = null;
        if (convertorEl != null) {
            type = convertorEl.getAttribute("type");
        }
        if (type == null || type.equals("")) {
            type = this.defaultConvertorHint;
        }
        ConvertorBuilder convertorBuilder = (ConvertorBuilder)this.convertorBuilders.select(type);
        return convertorBuilder.build(convertorEl);
    }

    public Convertor getPlainConvertor() {
        return this.plainConvertor;
    }

    protected void buildValidationRules(Element datatypeElement, AbstractDatatype datatype, DatatypeManager datatypeManager) throws Exception {
        Element validationElement = DomHelper.getChildElement(datatypeElement, "http://apache.org/cocoon/forms/1.0#definition", "validation");
        if (validationElement != null) {
            Element[] validationElements = DomHelper.getChildElements(validationElement, "http://apache.org/cocoon/forms/1.0#definition");
            for (int i = 0; i < validationElements.length; ++i) {
                ValidationRule rule = datatypeManager.createValidationRule(validationElements[i]);
                if (!rule.supportsType(datatype.getTypeClass(), datatype.isArrayType())) {
                    throw new Exception("Validation rule \"" + validationElements[i].getLocalName() + "\" cannot be used with strings, error at " + DomHelper.getLocation(validationElements[i]));
                }
                datatype.addValidationRule(rule);
            }
        }
    }
}

