/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Iterator;
import java.util.Locale;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.datatype.SelectionListBuilder;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.formmodel.AbstractDatatypeWidgetDefinition;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinitionBuilder;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.i18n.I18nUtils;
import org.w3c.dom.Element;

public abstract class AbstractDatatypeWidgetDefinitionBuilder
extends AbstractWidgetDefinitionBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupDefinition(Element widgetElement, AbstractDatatypeWidgetDefinition definition) throws Exception {
        super.setupDefinition(widgetElement, definition);
        this.setDisplayData(widgetElement, definition);
        Iterator iter = this.buildEventListeners(widgetElement, "on-value-changed", ValueChangedListener.class).iterator();
        while (iter.hasNext()) {
            definition.addValueChangedListener((ValueChangedListener)iter.next());
        }
        Element datatypeElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "datatype");
        if (datatypeElement == null) {
            throw new Exception("A nested datatype element is required for the widget " + widgetElement.getTagName() + " at " + DomHelper.getLocation(widgetElement));
        }
        Datatype datatype = this.datatypeManager.createDatatype(datatypeElement, false);
        Object initialValue = null;
        Element initialValueElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "initial-value", false);
        if (initialValueElement != null) {
            String localeValue = DomHelper.getAttribute(initialValueElement, "locale", null);
            Locale locale = localeValue == null ? null : I18nUtils.parseLocale((String)localeValue);
            String value = DomHelper.getElementText(initialValueElement);
            ConversionResult result = datatype.convertFromString(value, locale);
            if (!result.isSuccessful()) {
                throw new Exception("Cannot parse initial value '" + value + "' at " + DomHelper.getLocation(initialValueElement));
            }
            initialValue = result.getResult();
        }
        definition.setDatatype(datatype, initialValue);
        definition.service(this.serviceManager);
        Element selectionListElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "selection-list");
        if (selectionListElement != null) {
            ServiceSelector builderSelector;
            block9: {
                builderSelector = (ServiceSelector)this.serviceManager.lookup(SelectionListBuilder.ROLE + "Selector");
                SelectionListBuilder builder = null;
                try {
                    String listType = selectionListElement.getAttribute("type");
                    if ("".equals(listType)) {
                        listType = null;
                    }
                    builder = (SelectionListBuilder)builderSelector.select((Object)listType);
                    SelectionList list = builder.build(selectionListElement, definition.getDatatype());
                    definition.setSelectionList(list);
                    Object var14_13 = null;
                    if (builder == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    if (builder != null) {
                        builderSelector.release(builder);
                    }
                    this.serviceManager.release((Object)builderSelector);
                    throw throwable;
                }
                builderSelector.release((Object)builder);
            }
            this.serviceManager.release((Object)builderSelector);
            {
            }
        }
    }
}

