/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.forms.datatype.DatatypeManager;
import org.apache.cocoon.forms.event.CreateListener;
import org.apache.cocoon.forms.event.WidgetListener;
import org.apache.cocoon.forms.event.WidgetListenerBuilder;
import org.apache.cocoon.forms.expression.ExpressionManager;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinition;
import org.apache.cocoon.forms.formmodel.FormDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.WidgetState;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.forms.validation.WidgetValidatorBuilder;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractWidgetDefinitionBuilder
implements WidgetDefinitionBuilder,
Serviceable,
Disposable {
    protected ServiceSelector widgetDefinitionBuilderSelector;
    protected ServiceSelector widgetValidatorBuilderSelector;
    protected ServiceSelector widgetListenerBuilderSelector;
    protected DatatypeManager datatypeManager;
    protected ExpressionManager expressionManager;
    protected ServiceManager serviceManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.serviceManager = serviceManager;
        this.widgetDefinitionBuilderSelector = (ServiceSelector)serviceManager.lookup(WidgetDefinitionBuilder.class.getName() + "Selector");
        this.datatypeManager = (DatatypeManager)serviceManager.lookup(DatatypeManager.ROLE);
        this.expressionManager = (ExpressionManager)serviceManager.lookup(ExpressionManager.ROLE);
        this.widgetValidatorBuilderSelector = (ServiceSelector)serviceManager.lookup(WidgetValidatorBuilder.ROLE + "Selector");
        this.widgetListenerBuilderSelector = (ServiceSelector)serviceManager.lookup(WidgetListenerBuilder.ROLE + "Selector");
    }

    protected void setupDefinition(Element widgetElement, AbstractWidgetDefinition definition) throws Exception {
        this.setCommonProperties(widgetElement, definition);
        this.setValidators(widgetElement, definition);
        this.setCreateListeners(widgetElement, definition);
    }

    private void setCommonProperties(Element widgetElement, AbstractWidgetDefinition widgetDefinition) throws Exception {
        Element[] attrs;
        Element attrContainer;
        widgetDefinition.setLocation(DomHelper.getLocation(widgetElement));
        if (widgetDefinition instanceof FormDefinition) {
            widgetDefinition.setId(DomHelper.getAttribute(widgetElement, "id", ""));
        } else {
            String id = DomHelper.getAttribute(widgetElement, "id");
            if (id.length() < 1) {
                throw new Exception("Missing id attribute on element '" + widgetElement.getTagName() + "' at " + DomHelper.getLocation(widgetElement));
            }
            widgetDefinition.setId(id);
        }
        String stateValue = DomHelper.getAttribute(widgetElement, "state", null);
        if (stateValue != null) {
            WidgetState state = WidgetState.stateForName(stateValue);
            if (state == null) {
                throw new Exception("Unknow value '" + stateValue + "' for state attribute at " + DomHelper.getLocation(widgetElement));
            }
            widgetDefinition.setState(state);
        }
        if ((attrContainer = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "attributes", false)) != null && (attrs = DomHelper.getChildElements(attrContainer, "http://apache.org/cocoon/forms/1.0#definition", "attribute")) != null && attrs.length > 0) {
            HashMap<String, String> attrMap = new HashMap<String, String>();
            for (int i = 0; i < attrs.length; ++i) {
                attrMap.put(DomHelper.getAttribute(attrs[i], "name"), DomHelper.getAttribute(attrs[i], "value"));
            }
            widgetDefinition.setAttributes(attrMap);
        }
    }

    protected WidgetDefinition buildAnotherWidgetDefinition(Element widgetDefinition) throws Exception {
        String widgetName = widgetDefinition.getLocalName();
        WidgetDefinitionBuilder builder = null;
        try {
            builder = (WidgetDefinitionBuilder)this.widgetDefinitionBuilderSelector.select((Object)widgetName);
        }
        catch (ServiceException e) {
            throw new CascadingException("Unknown kind of widget '" + widgetName + "' at " + DomHelper.getLocation(widgetDefinition), (Throwable)e);
        }
        return builder.buildWidgetDefinition(widgetDefinition);
    }

    protected List buildEventListeners(Element widgetElement, String elementName, Class listenerClass) throws Exception {
        ArrayList<WidgetListener> result = null;
        Element listenersElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", elementName);
        if (listenersElement != null) {
            NodeList list = listenersElement.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                Element listenerElement = (Element)list.item(i);
                WidgetListenerBuilder listenerBuilder = null;
                try {
                    listenerBuilder = (WidgetListenerBuilder)this.widgetListenerBuilderSelector.select((Object)listenerElement.getLocalName());
                }
                catch (ServiceException e) {
                    throw new CascadingException("Unknown kind of eventlistener '" + listenerElement.getLocalName() + "' at " + DomHelper.getLocation(listenerElement), (Throwable)e);
                }
                WidgetListener listener = listenerBuilder.buildListener(listenerElement, listenerClass);
                this.widgetListenerBuilderSelector.release((Object)listenerBuilder);
                if (result == null) {
                    result = new ArrayList<WidgetListener>();
                }
                result.add(listener);
            }
        }
        return result == null ? Collections.EMPTY_LIST : result;
    }

    protected void setDisplayData(Element widgetElement, AbstractWidgetDefinition widgetDefinition) throws Exception {
        String[] names = new String[]{"label", "help", "hint"};
        HashMap<String, XMLizable> displayData = new HashMap<String, XMLizable>(names.length);
        for (int i = 0; i < names.length; ++i) {
            XMLizable data = null;
            Element dataElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", names[i]);
            if (dataElement != null) {
                data = DomHelper.compileElementContent(dataElement);
            }
            displayData.put(names[i], data);
        }
        widgetDefinition.setDisplayData(displayData);
    }

    private void setValidators(Element widgetElement, AbstractWidgetDefinition widgetDefinition) throws Exception {
        Element validatorElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "validation");
        if (validatorElement != null) {
            NodeList list = validatorElement.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                WidgetValidatorBuilder builder;
                if (list.item(i).getNodeType() != 1) continue;
                Element element = (Element)list.item(i);
                String name = element.getLocalName();
                try {
                    builder = (WidgetValidatorBuilder)this.widgetValidatorBuilderSelector.select((Object)name);
                }
                catch (ServiceException e) {
                    throw new CascadingException("Unknow kind of validator '" + name + "' at " + DomHelper.getLocation(element), (Throwable)e);
                }
                widgetDefinition.addValidator(builder.build(element, widgetDefinition));
                this.widgetValidatorBuilderSelector.release((Object)builder);
            }
        }
    }

    private void setCreateListeners(Element widgetElement, AbstractWidgetDefinition widgetDefinition) throws Exception {
        Iterator iter = this.buildEventListeners(widgetElement, "on-create", CreateListener.class).iterator();
        while (iter.hasNext()) {
            widgetDefinition.addCreateListener((CreateListener)iter.next());
        }
    }

    public void dispose() {
        this.serviceManager.release((Object)this.widgetDefinitionBuilderSelector);
        this.widgetDefinitionBuilderSelector = null;
        this.serviceManager.release((Object)this.datatypeManager);
        this.datatypeManager = null;
        this.serviceManager.release((Object)this.expressionManager);
        this.expressionManager = null;
        this.serviceManager.release((Object)this.widgetValidatorBuilderSelector);
        this.widgetValidatorBuilderSelector = null;
        this.serviceManager = null;
    }
}

