/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Iterator;
import org.apache.cocoon.forms.event.ActionListener;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.ActionDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.util.Deprecation;
import org.w3c.dom.Element;

public class ActionDefinitionBuilder
extends AbstractWidgetDefinitionBuilder {
    public WidgetDefinition buildWidgetDefinition(Element widgetElement) throws Exception {
        ActionDefinition definition = new ActionDefinition();
        this.setupDefinition(widgetElement, definition);
        definition.makeImmutable();
        return definition;
    }

    protected void setupDefinition(Element widgetElement, ActionDefinition definition) throws Exception {
        super.setupDefinition(widgetElement, definition);
        this.setDisplayData(widgetElement, definition);
        String actionCommand = DomHelper.getAttribute(widgetElement, "command", null);
        if (actionCommand == null && (actionCommand = DomHelper.getAttribute(widgetElement, "action-command", null)) != null) {
            Deprecation.logger.warn("The 'action-command' attribute is deprecated and replaced by 'command', at " + DomHelper.getLocation(widgetElement));
        }
        definition.setActionCommand(actionCommand);
        Iterator iter = this.buildEventListeners(widgetElement, "on-action", ActionListener.class).iterator();
        while (iter.hasNext()) {
            definition.addActionListener((ActionListener)iter.next());
        }
    }
}

