/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Locale;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.event.DeferredValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.ValueChangedListenerEnabled;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.DataWidget;
import org.apache.cocoon.forms.formmodel.ExpressionContextImpl;
import org.apache.cocoon.forms.formmodel.FieldDefinition;
import org.apache.cocoon.forms.formmodel.SelectableWidget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Field
extends AbstractWidget
implements ValidationErrorAware,
DataWidget,
SelectableWidget,
ValueChangedListenerEnabled {
    private static final String FIELD_EL = "field";
    private static final String VALUE_EL = "value";
    private static final String VALIDATION_MSG_EL = "validation-message";
    protected SelectionList selectionList;
    private ValueChangedListener listener;
    private final FieldDefinition fieldDefinition;
    protected String enteredValue;
    protected Object value;
    protected static final int VALUE_UNPARSED = 0;
    protected static final int VALUE_PARSED = 1;
    protected static final int VALUE_PARSE_ERROR = 2;
    protected static final int VALUE_DISPLAY_PARSE_ERROR = 3;
    protected static final int VALUE_VALIDATING = 4;
    protected static final int VALUE_VALIDATED = 5;
    protected static final int VALUE_DISPLAY_VALIDATION = 6;
    protected int valueState = 1;
    protected ValidationError validationError;

    public Field(FieldDefinition fieldDefinition) {
        super(fieldDefinition);
        this.fieldDefinition = fieldDefinition;
    }

    public final FieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public WidgetDefinition getDefinition() {
        return this.fieldDefinition;
    }

    public void initialize() {
        Object value = this.fieldDefinition.getInitialValue();
        if (value != null) {
            this.setValue(value);
        }
        super.initialize();
    }

    public Object getValue() {
        if (this.valueState == 4) {
            return this.value;
        }
        if (this.valueState == 0) {
            this.doParse();
        }
        if (this.valueState == 1) {
            this.doValidate();
        }
        return this.validationError == null ? this.value : null;
    }

    public void setValue(Object newValue) {
        boolean changed;
        if (newValue != null && !this.getDatatype().getTypeClass().isAssignableFrom(newValue.getClass())) {
            throw new RuntimeException("Incorrect value type for \"" + this.getRequestParameterName() + "\" (expected " + this.getDatatype().getTypeClass() + ", got " + newValue.getClass() + ").");
        }
        if (this.valueState == 0) {
            changed = true;
        } else if (this.value == null) {
            changed = newValue != null;
        } else {
            boolean bl = changed = !this.value.equals(newValue);
        }
        if (changed || newValue == null) {
            boolean callListeners = changed && this.hasValueChangedListeners();
            Object oldValue = callListeners ? this.getValue() : null;
            this.value = newValue;
            this.validationError = null;
            this.valueState = 1;
            this.enteredValue = newValue != null ? this.getDatatype().convertToString(newValue, this.getForm().getLocale()) : null;
            if (callListeners) {
                this.getForm().addWidgetEvent(new ValueChangedEvent(this, oldValue, newValue));
            }
        }
    }

    public void readFromRequest(FormContext formContext) {
        if (!this.getCombinedState().isAcceptingInputs()) {
            return;
        }
        String newEnteredValue = formContext.getRequest().getParameter(this.getRequestParameterName());
        this.readFromRequest(newEnteredValue);
    }

    protected void readFromRequest(String newEnteredValue) {
        boolean changed;
        if (newEnteredValue != null && (newEnteredValue = newEnteredValue.trim()).length() == 0) {
            newEnteredValue = null;
        }
        if (this.enteredValue == null) {
            changed = newEnteredValue != null;
        } else {
            boolean bl = changed = !this.enteredValue.equals(newEnteredValue);
        }
        if (changed) {
            boolean hasListeners = this.hasValueChangedListeners();
            Object oldValue = hasListeners ? this.getValue() : null;
            this.enteredValue = newEnteredValue;
            this.validationError = null;
            this.value = null;
            this.valueState = 0;
            if (hasListeners) {
                this.getForm().addWidgetEvent(new DeferredValueChangedEvent(this, oldValue));
            }
        }
    }

    public boolean validate() {
        if (!this.getCombinedState().isValidatingValues()) {
            return true;
        }
        if (this.valueState == 0) {
            this.doParse();
        }
        if (this.valueState >= 5) {
            this.valueState = 1;
        }
        if (this.valueState == 1) {
            this.doValidate();
            this.valueState = 6;
        } else if (this.valueState == 2) {
            this.valueState = 3;
        }
        return this.validationError == null;
    }

    private void doParse() {
        if (this.valueState != 0) {
            throw new IllegalStateException("Field is not in UNPARSED state (" + this.valueState + ")");
        }
        this.value = null;
        this.validationError = null;
        if (this.enteredValue != null) {
            ConversionResult conversionResult = this.getDatatype().convertFromString(this.enteredValue, this.getForm().getLocale());
            if (conversionResult.isSuccessful()) {
                this.value = conversionResult.getResult();
                this.valueState = 1;
            } else {
                this.validationError = conversionResult.getValidationError();
                this.valueState = 2;
            }
        } else {
            this.valueState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidate() {
        if (this.valueState != 1) {
            throw new IllegalStateException("Field is not in PARSED state (" + this.valueState + ")");
        }
        this.valueState = 4;
        try {
            if (this.value == null && this.getFieldDefinition().isRequired()) {
                this.validationError = new ValidationError(new I18nMessage("general.field-required", "forms"));
            } else if (super.validate() && this.value != null) {
                this.validationError = this.getDatatype().validate(this.value, new ExpressionContextImpl(this));
            }
        }
        finally {
            this.valueState = 5;
        }
    }

    public ValidationError getValidationError() {
        this.getValue();
        return this.validationError;
    }

    public void setValidationError(ValidationError error) {
        this.validationError = error;
        this.valueState = 6;
    }

    public boolean isRequired() {
        return this.getFieldDefinition().isRequired();
    }

    public String getXMLElementName() {
        return FIELD_EL;
    }

    public AttributesImpl getXMLElementAttributes() {
        AttributesImpl attrs = super.getXMLElementAttributes();
        attrs.addCDATAAttribute("required", String.valueOf(this.isRequired()));
        return attrs;
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        if (locale == null) {
            locale = this.getForm().getLocale();
        }
        if (this.enteredValue != null || this.value != null) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
            String stringValue = this.value != null ? this.getDatatype().convertToString(this.value, locale) : this.enteredValue;
            contentHandler.characters(stringValue.toCharArray(), 0, stringValue.length());
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value");
        }
        if (this.validationError != null && (this.valueState == 6 || this.valueState == 3)) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
            this.validationError.generateSaxFragment(contentHandler);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message");
        }
        if (this.selectionList != null) {
            this.selectionList.generateSaxFragment(contentHandler, locale);
        }
        this.fieldDefinition.getDatatype().generateSaxFragment(contentHandler, locale);
    }

    public void setSelectionList(SelectionList selectionList) {
        if (selectionList != null && selectionList.getDatatype() != null && selectionList.getDatatype() != this.getDatatype()) {
            throw new RuntimeException("Tried to assign a SelectionList that is not associated with this widget's datatype.");
        }
        this.selectionList = selectionList;
    }

    public void setSelectionList(String uri) {
        this.setSelectionList(this.getFieldDefinition().buildSelectionList(uri));
    }

    public void setSelectionList(Object model, String valuePath, String labelPath) {
        this.setSelectionList(this.getFieldDefinition().buildSelectionListFromModel(model, valuePath, labelPath));
    }

    public Datatype getDatatype() {
        return this.getFieldDefinition().getDatatype();
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void removeValueChangedListener(ValueChangedListener listener) {
        this.listener = WidgetEventMulticaster.remove(this.listener, listener);
    }

    private boolean hasValueChangedListeners() {
        return this.listener != null || this.fieldDefinition.hasValueChangedListeners();
    }

    private void fireValueChangedEvent(ValueChangedEvent event) {
        if (this.listener != null) {
            this.listener.valueChanged(event);
        }
    }

    public void broadcastEvent(WidgetEvent event) {
        if (event instanceof ValueChangedEvent) {
            this.getFieldDefinition().fireValueChangedEvent((ValueChangedEvent)event);
            this.fireValueChangedEvent((ValueChangedEvent)event);
        } else {
            super.broadcastEvent(event);
        }
    }
}

