/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.lang.reflect.Array;
import java.util.Locale;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.DataWidget;
import org.apache.cocoon.forms.formmodel.ExpressionContextImpl;
import org.apache.cocoon.forms.formmodel.MultiValueFieldDefinition;
import org.apache.cocoon.forms.formmodel.SelectableWidget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MultiValueField
extends AbstractWidget
implements ValidationErrorAware,
SelectableWidget,
DataWidget {
    private static final String MULTIVALUEFIELD_EL = "multivaluefield";
    private static final String VALUES_EL = "values";
    private static final String VALUE_EL = "value";
    private static final String VALIDATION_MSG_EL = "validation-message";
    private final MultiValueFieldDefinition definition;
    private SelectionList selectionList;
    private String[] enteredValues;
    private Object[] values;
    private ValidationError validationError;

    public MultiValueField(MultiValueFieldDefinition definition) {
        super(definition);
        this.definition = definition;
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void readFromRequest(FormContext formContext) {
        if (!this.getCombinedState().isAcceptingInputs()) {
            return;
        }
        this.enteredValues = formContext.getRequest().getParameterValues(this.getRequestParameterName());
        this.validationError = null;
        this.values = null;
        boolean conversionFailed = false;
        if (this.enteredValues != null) {
            Object[] tempValues = (Object[])Array.newInstance(this.getDatatype().getTypeClass(), this.enteredValues.length);
            for (int i = 0; i < this.enteredValues.length; ++i) {
                String param = this.enteredValues[i];
                ConversionResult conversionResult = this.definition.getDatatype().convertFromString(param, formContext.getLocale());
                if (!conversionResult.isSuccessful()) {
                    conversionFailed = true;
                    break;
                }
                tempValues[i] = conversionResult.getResult();
            }
            this.values = !conversionFailed ? tempValues : null;
        } else {
            this.values = new Object[0];
        }
    }

    public boolean validate() {
        if (!this.getCombinedState().isValidatingValues()) {
            return true;
        }
        this.validationError = this.values != null ? this.definition.getDatatype().validate(this.values, new ExpressionContextImpl(this)) : new ValidationError(new I18nMessage("multivaluefield.conversionfailed", "forms"));
        return this.validationError == null ? super.validate() : false;
    }

    public String getXMLElementName() {
        return MULTIVALUEFIELD_EL;
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUES_EL, "fi:values", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
                String value = this.definition.getDatatype().getPlainConvertor().convertToString(this.values[i], locale, null);
                contentHandler.characters(value.toCharArray(), 0, value.length());
                contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value");
            }
        } else if (this.enteredValues != null) {
            for (int i = 0; i < this.enteredValues.length; ++i) {
                contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
                String value = this.definition.getDatatype().getPlainConvertor().convertToString(this.enteredValues[i], locale, null);
                contentHandler.characters(value.toCharArray(), 0, value.length());
                contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value");
            }
        }
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUES_EL, "fi:values");
        this.selectionList.generateSaxFragment(contentHandler, locale);
        if (this.validationError != null) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
            this.validationError.generateSaxFragment(contentHandler);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message");
        }
    }

    public Object getValue() {
        return this.values;
    }

    public void setValue(Object value) {
        if (value == null) {
            this.setValues(new Object[0]);
        } else if (value.getClass().isArray()) {
            this.setValues((Object[])value);
        } else {
            throw new RuntimeException("Cannot set value of field \"" + this.getRequestParameterName() + "\" with an object of type " + value.getClass().getName());
        }
    }

    public void setValues(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (this.definition.getDatatype().getTypeClass().isAssignableFrom(values[i].getClass())) continue;
            throw new RuntimeException("Cannot set value of field \"" + this.getRequestParameterName() + "\" with an object of type " + values[i].getClass().getName());
        }
        this.values = values;
    }

    public void setSelectionList(SelectionList selectionList) {
        if (selectionList == null) {
            throw new IllegalArgumentException("An MultiValueField's selection list cannot be null.");
        }
        if (selectionList.getDatatype() != null && selectionList.getDatatype() != this.definition.getDatatype()) {
            throw new RuntimeException("Tried to assign a SelectionList that is not associated with this widget's datatype.");
        }
        this.selectionList = selectionList;
    }

    public void setSelectionList(String uri) {
        this.setSelectionList(this.definition.buildSelectionList(uri));
    }

    public void setSelectionList(Object model, String valuePath, String labelPath) {
        this.setSelectionList(this.definition.buildSelectionListFromModel(model, valuePath, labelPath));
    }

    public void broadcastEvent(WidgetEvent event) {
        if (event instanceof ValueChangedEvent) {
            this.definition.fireValueChangedEvent((ValueChangedEvent)event);
        } else {
            super.broadcastEvent(event);
        }
    }

    public ValidationError getValidationError() {
        return this.validationError;
    }

    public void setValidationError(ValidationError error) {
        this.validationError = error;
    }

    public Datatype getDatatype() {
        return this.definition.getDatatype();
    }
}

