/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinition;
import org.apache.cocoon.forms.formmodel.ClassDefinition;
import org.apache.cocoon.forms.formmodel.ContainerDefinition;
import org.apache.cocoon.forms.formmodel.FormDefinition;
import org.apache.cocoon.forms.formmodel.UnionDefinition;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;

public class NewDefinition
extends AbstractWidgetDefinition {
    private boolean resolving = false;
    private ClassDefinition classDefinition = null;

    private ClassDefinition getClassDefinition() throws Exception {
        FormDefinition formDefinition = this.getFormDefinition();
        WidgetDefinition classDefinition = formDefinition.getWidgetDefinition(this.getId());
        if (classDefinition == null) {
            throw new Exception("NewDefinition: Class with id \"" + this.getId() + "\" does not exist (" + this.getLocation() + ")");
        }
        if (!(classDefinition instanceof ClassDefinition)) {
            throw new Exception("NewDefinition: Id \"" + this.getId() + "\" is not a class (" + this.getLocation() + ")");
        }
        return (ClassDefinition)classDefinition;
    }

    public void resolve(List parents, WidgetDefinition parent) throws Exception {
        WidgetDefinition definition;
        if (this.resolving) {
            ListIterator parentsIt = parents.listIterator(parents.size());
            while (parentsIt.hasPrevious() && !((definition = (WidgetDefinition)parentsIt.previous()) instanceof UnionDefinition)) {
                if (definition != this) continue;
                throw new Exception("NewDefinition: Non-terminating recursion detected in widget definition : " + parent.getId() + " (" + this.getLocation() + ")");
            }
        }
        this.resolving = true;
        parents.add(this);
        this.classDefinition = this.getClassDefinition();
        Iterator definitionsIt = this.classDefinition.getWidgetDefinitions().iterator();
        parents.add(this);
        while (definitionsIt.hasNext()) {
            definition = (WidgetDefinition)definitionsIt.next();
            if (definition instanceof ContainerDefinition) {
                ((ContainerDefinition)definition).resolve(parents, parent);
            }
            if (definition instanceof NewDefinition) {
                ((NewDefinition)definition).resolve(parents, parent);
                continue;
            }
            ((ContainerDefinition)parent).addWidgetDefinition(definition);
        }
        parents.remove(parents.size() - 1);
        this.resolving = false;
    }

    public Widget createInstance() {
        return null;
    }
}

